package com.artfess.cqxy.projectManagement.dao;

import com.artfess.cqxy.projectManagement.model.DirectoryManagement;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 目录管理表(BizDirectoryManagement)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-16 09:04:11
 */
public interface DirectoryManagementDao extends BaseMapper<DirectoryManagement> {

    /**
     * 根据父节点ID获取其子节点数据
     * @param pCode 父节点ID
     * @return 树状数据
     */
    List<DirectoryManagement> getByParentId(@Param("pCode") String pCode);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<DirectoryManagement> queryChildNodeByPage(IPage<DirectoryManagement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<DirectoryManagement> convert2Wrapper);


    /**
     * 更新是否有子节点状态
     * @param pCode 父节点编号
     * @param status 状态，有/无
     * @return num
     */
    int updateChildNodeStatus(@Param("pCode") String pCode,@Param("status") String status);
}

