package com.artfess.cqxy.ledger.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 项目审批台账VO对象
 *
 * @author Limuhua
 * @date 2022/3/17 9:19
 */
@Data
@ApiModel(value="台账-项目审批台账对象-ApprovalLedgerVo")
public class ApprovalLedgerVo {

    // 项目表
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("在办建设手续 / 项目状态")
    private String currentProcedure;
    @ApiModelProperty("项目类型")
    private Integer projectType;

    // 项目立项表
    @ApiModelProperty("立项批复文号及时间")
    private String establishDT;

    // 可研规划-可研批复表
    @ApiModelProperty("可研批复文号及时间")
    private String feasiblePlanDT;
    @ApiModelProperty("可研批复规模、总投资、建安投资")
    private String feasiblePlanInfo;

    // 设计概算-概算表
    @ApiModelProperty("概算文号及时间")
    private String estimateDT;
    @ApiModelProperty("概算总投资及建安投资")
    private String estimateInfo;

    // 规划许可-选址表
    @ApiModelProperty("选址文号及时间 / 用地预审与选址意见书")
    private String siteDT;

    // 规划许可-用地表
    @ApiModelProperty("用地文号及时间")
    private String useLandDT;
    @ApiModelProperty("规划用地许可编号 / 编号")
    private String useLandCode;

    // 规划许可-工程规划表，类型为规划许可时为规划许可，否则为专项审查
    @ApiModelProperty("规划许可文号及时间")
    private String porjectPlanningDT;
    @ApiModelProperty("规划许可规模")
    private String porjectPlanningScale;
    @ApiModelProperty("专项审查")
    private List<String> specialReview;

    // 设计概算 - 初步设计表
    @ApiModelProperty("初步设计文号及时间")
    private String preliminaryDesignDT;

    // 设计概算 - 施工图设计表
    @ApiModelProperty("施工图备案文号及时间")
    private String constructionDrawingDT;

    // 施工许可表
    @ApiModelProperty("施工许可名称")
    private String constructionPermitName;
    @ApiModelProperty("施工许可文号及时间")
    private String constructionPermitDT;

    // 竣工验收 - 联合备案验收表 目前暂缺  文号
    @ApiModelProperty("验收备案文号及时间")
    private String recordAcceptanceDT;

    public void replace(){
        projectName = null==projectName?"":projectName.replace("null","");

        currentProcedure = null==currentProcedure?"":currentProcedure.replace("null"," ");
        establishDT = null==establishDT?"":establishDT.replace("null","");

        feasiblePlanDT = null==feasiblePlanDT?"":feasiblePlanDT.replace("null","");
        feasiblePlanInfo = null==feasiblePlanInfo?"":feasiblePlanInfo.replace("null","");

        estimateDT = null==estimateDT?"":estimateDT.replace("null","");
        estimateInfo = null==estimateInfo?"":estimateInfo.replace("null","");

        siteDT = null==siteDT?"":siteDT.replace("null","");
        useLandDT = null==useLandDT?"":useLandDT.replace("null","");

        useLandCode = null==useLandCode?"":useLandCode.replace("null","");
        porjectPlanningDT = null==porjectPlanningDT?"":porjectPlanningDT.replace("null","");

        porjectPlanningScale = null==porjectPlanningScale?"":porjectPlanningScale.replace("null","");
        preliminaryDesignDT = null==preliminaryDesignDT?"":preliminaryDesignDT.replace("null","");

        constructionDrawingDT = null==constructionDrawingDT?"":constructionDrawingDT.replace("null","");
        constructionPermitName = null==constructionPermitName?"":constructionPermitName.replace("null","");

        constructionPermitDT = null==constructionPermitDT?"":constructionPermitDT.replace("null","");
        recordAcceptanceDT = null==recordAcceptanceDT?"":recordAcceptanceDT.replace("null","");
    }

    @Override
    public String toString() {
        return "ApprovalLedgerVo{" +
                "projectName='" + projectName + '\'' +
                ", currentProcedure='" + currentProcedure + '\'' +
                ", projectType=" + projectType +
                ", establishDT='" + establishDT + '\'' +
                ", feasiblePlanDT='" + feasiblePlanDT + '\'' +
                ", feasiblePlanInfo='" + feasiblePlanInfo + '\'' +
                ", estimateDT='" + estimateDT + '\'' +
                ", estimateInfo='" + estimateInfo + '\'' +
                ", siteDT='" + siteDT + '\'' +
                ", useLandDT='" + useLandDT + '\'' +
                ", useLandCode='" + useLandCode + '\'' +
                ", porjectPlanningDT='" + porjectPlanningDT + '\'' +
                ", porjectPlanningScale='" + porjectPlanningScale + '\'' +
                ", specialReview=" + specialReview +
                ", preliminaryDesignDT='" + preliminaryDesignDT + '\'' +
                ", constructionDrawingDT='" + constructionDrawingDT + '\'' +
                ", constructionPermitName='" + constructionPermitName + '\'' +
                ", constructionPermitDT='" + constructionPermitDT + '\'' +
                ", recordAcceptanceDT='" + recordAcceptanceDT + '\'' +
                '}';
    }
}
