package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cqxy.ledger.manager.MenuCustomizeFieldManager;
import com.artfess.cqxy.ledger.manager.MenuFieldTempManager;
import com.artfess.cqxy.ledger.model.MenuCustomizeField;
import com.artfess.cqxy.ledger.model.MenuFieldTemp;
import com.artfess.cqxy.ledger.vo.MenuCustomizeParamVo;
import com.artfess.cqxy.ledger.vo.MenuCustomizeVo;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * 自定义台账字段查询
 *
 * @author baseli
 * @since 2022年6月5日20:09:57
 */
@Slf4j
@RestController
@Api(tags = "台账-自定义台账-菜单自定义模板接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/menuFieldTemp/v1")
public class MenuFieldTempController extends BaseController<MenuFieldTempManager, MenuFieldTemp> {

    @Resource
    private MenuCustomizeFieldManager menuCustomizeFieldManager;

    @Resource
    private ProgressManageManager progressManageManager;

    /**
     * 删除数据
     * @param ids 主键集合
     * @return 删除结果
     */
    @PostMapping("/delete")
    @ApiOperation(value = "S-批量删除数据",httpMethod = "POST")
    public CommonResult delete(@ApiParam(name = "ids",value = "ID集合") @RequestParam("ids") String ids) {
        Assert.notNull(ids,"主键集合不能为空");
        List<String> idList = Arrays.asList(ids.split(","));
        baseService.removeByIds(idList);
        QueryWrapper<MenuCustomizeField> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("TEMP_ID_", idList);
        menuCustomizeFieldManager.remove(queryWrapper);
        return new CommonResult<String>(true, "数据删除成功");
    }

    /**
     * 保存或修改数据
     * @param menuFieldTemp 实体对象
     * @return 新增或更新结果
     */
    @PostMapping("/save")
    @ApiOperation(value = "S-批量保存或修改数据",httpMethod = "POST")
    public CommonResult insert(@RequestBody MenuFieldTemp menuFieldTemp) {
        Assert.notNull(menuFieldTemp,"参数不能为空");
//        baseService.saveBatch(menuFieldTempList);
        baseService.saveOrUpdate(menuFieldTemp);
        List<MenuCustomizeField> menuCustomizeFieldList = menuFieldTemp.getMenuCustomizeFieldList();
        if(null != menuCustomizeFieldList && menuCustomizeFieldList.size() > 0){
            for(MenuCustomizeField menuCustomizeField : menuCustomizeFieldList){
                menuCustomizeField.setTempId(menuFieldTemp.getId());
                menuCustomizeField.setProjectId(menuFieldTemp.getProjectId());
                menuCustomizeField.setProjectName(menuFieldTemp.getProjectName());
                menuCustomizeFieldManager.saveOrUpdate(menuCustomizeField);
            }
        }
        return new CommonResult(true, "数据保存成功！");
    }

    /**
     * 通过主键查询单条数据
     * @param id 主键
     * @return 单条数据
     */
    @PostMapping("/detail/{id}")
    @ApiOperation(value = "S-根据ID查询详情",httpMethod = "POST")
    public CommonResult<MenuFieldTemp> selectOne(@ApiParam(name = "id",value = "主键ID") @PathVariable String id) {
        Assert.notNull(id,"ID不能为空");
        MenuFieldTemp result = baseService.getById(id);
        QueryWrapper<MenuCustomizeField> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("TEMP_ID_", id);
        queryWrapper.orderByAsc("SN_");
        result.setMenuCustomizeFieldList(menuCustomizeFieldManager.list(queryWrapper));
        return new CommonResult<MenuFieldTemp>(true, "数据查询成功", result);
    }


    /**
     * 根据配置ID查询数据
     * @param menuCustomizeParamVo 模板参数对象
     * @return 数据
     */
    @PostMapping("/getDataById")
    @ApiOperation(value = "S-根据模板ID预览数据",httpMethod = "POST")
    public CommonResult<MenuCustomizeVo> getDataById(@RequestBody MenuCustomizeParamVo menuCustomizeParamVo) {
        Assert.notNull(menuCustomizeParamVo,"参数不能为空");
        return new CommonResult(true, "数据查询成功！", baseService.getDataByIdss(menuCustomizeParamVo));
    }

    /**
     * 根据配置ID导出数据
     * @param menuCustomizeParamVo 模板参数对象
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataById")
    @ApiOperation(value = "S-根据模板ID导出数据",httpMethod = "POST")
    public CommonResult<String> exportDataById(@RequestBody MenuCustomizeParamVo menuCustomizeParamVo, HttpServletResponse response) throws IOException {
        Assert.notNull(menuCustomizeParamVo,"参数不能为空");
        baseService.exportDataToExcel(menuCustomizeParamVo, response);
        return new CommonResult(true, "数据导出成功！");
    }

}

