package com.artfess.cqxy.contract.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.bidManagement.model.BidManagement;
import com.artfess.cqxy.contract.dao.AdministrativePaymentDao;
import com.artfess.cqxy.contract.manager.AdministrativePaymentManager;
import com.artfess.cqxy.contract.model.AdministrativePayment;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * (AdministrativePayment)表服务实现类
 *
 * @author makejava
 * @since 2022-11-28 10:07:40
 */
@Service
public class AdministrativePaymentManagerImpl extends BaseManagerImpl<AdministrativePaymentDao, AdministrativePayment> implements AdministrativePaymentManager {

    @Autowired
    private GlobalRetrievalManager grm;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private ProjectManagementManager pmm;

    @Override
    public PageList<AdministrativePayment> query(QueryFilter<AdministrativePayment> queryFilter) {
        PageList<AdministrativePayment> result = super.query(queryFilter);
        // 附件信息处理
        List<AdministrativePayment> records = result.getRows();
        for (AdministrativePayment ele: records ) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return result;
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    @Transactional
    public boolean save(AdministrativePayment entity) {
        Assert.notNull(entity, "参数不能为空");
        Assert.notNull(entity.getPaysDate(), "日期不能为空");
        entity.setPaysYear(String.valueOf(entity.getPaysDate().getYear()));
        boolean main = super.save(entity);
        boolean accessory = handleAccessory(entity);
        boolean sync = handleRetrieval(new GlobalRetrieval(),entity);
        return main && accessory && sync;
    }

    @Override
    @Transactional
    public boolean updateById(AdministrativePayment entity) {
        Assert.notNull(entity, "参数不能为空");
        Assert.notNull(entity.getPaysDate(), "日期不能为空");
        entity.setPaysYear(String.valueOf(entity.getPaysDate().getYear()));
        boolean main = super.updateById(entity);
        boolean accessory = handleAccessory(entity);
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        boolean sync = handleRetrieval(globalRetrieval,entity);
        return main && accessory && sync ;
    }

    private boolean handleAccessory(AdministrativePayment entity){
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>():flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.nine.getCode());
            ele.setGroup("AdministrativePayment");
            ele.setNode(ProjectStatusEnum.nine.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        return accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
    }

    private boolean handleRetrieval(GlobalRetrieval globalRetrieval, AdministrativePayment entity){
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirtySix.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirtySix.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirtySix.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirtySix.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.thirtySix.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.thirtySix.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.thirtySix.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.thirtySix.getFunctionPath());
        globalRetrieval.setName(entity.getPaysName());
        globalRetrieval.setSearchTitle(entity.getPaysName()+"_"+entity.getPaysName()+"_"+entity.getRemarks());
        return grm.saveOrUpdate(globalRetrieval);
    }

}

