package com.artfess.cqxy.contract.dao;

import com.artfess.cqxy.contract.model.FundPlan;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2022/7/7 11:30
 */
public interface FundPlanDao extends BaseMapper<FundPlan> {
    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    FundPlan getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<FundPlan> queryAllByPage(IPage<FundPlan> convert2IPage, @Param(Constants.WRAPPER) Wrapper<FundPlan> convert2Wrapper);
}
