package com.artfess.cqxy.bidManagement.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.extension.service.IService;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 招投标管理 - 招投标管理表(BiddingManagement)表服务接口
 *
 * @author 黎沐华
 * @since 2022-03-11 14:26:48
 */
public interface BiddingManagementManager extends BaseManager<BiddingManagement> {

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId);

    boolean deleteByIds(List<String> ids);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<BiddingManagement> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    BiddingManagement getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<BiddingManagement> queryAllByPage(QueryFilter<BiddingManagement> queryFilter);

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);


    /**
     * 根据条件查询每月招投标统计数据
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo);

}

