package com.artfess.cqxy.bidManagement.dao;

import java.util.List;
import java.util.Map;

import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;

/**
 * 招投标管理 - 招标管理表(BiddingManagement)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-04-08 15:32:29
 */
public interface BiddingManagementDao extends BaseMapper<BiddingManagement> {

    /**
     * 通过ID获取数 据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    BiddingManagement getById(@Param("id") String id);

    int saveEntity( @Param("entity") BiddingManagement entity);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<BiddingManagement> queryAllByPage(IPage<BiddingManagement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BiddingManagement> convert2Wrapper);

    /**
     * 根据条件查询每月的投资金额
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(@Param("statisticsVo") StatisticsVo statisticsVo);
}

