package com.artfess.cqxy.universal.manager;

import com.artfess.base.util.FileUtil;
import com.artfess.file.util.MinioUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;

import java.io.File;

/**
 * 工具类，为了实现异步上传，需要注册为@Service，才能正确执行代理
 * @author 黎沐华
 * @date 2022/2/18 15:00
 */
@Service
public class UtilsManager {

    @Async
    public void startMinIOUpload(File file, String bizPath, String name) throws Exception {
        String result = MinioUtil.upload(file, bizPath, name, "xypm");
        // MinIO上传成功后删除服务端缓存
        if(!StringUtils.isEmpty(result)){
            FileUtil.deleteDir(file.getParentFile());
        }
    }

    /**
     * 获取服务器存放文件的目录路径
     * @return 目录路径（String)
     */
    public String getFileDir(String subDir){
        String path= ClassUtils.getDefaultClassLoader().
                getResource("").getPath().substring(1)+"static/uploadingFileTemp/"+subDir.split("[.]")[0];
        File dir=new File(path);
        if(!dir.exists()){
            dir.mkdirs();
        }
        return path;
    }

    /**
     * 获取服务器存放文件的目录路径
     * @return 目录路径（String)
     */
    public String getofficeToPdfTempDir(String subDir){
        String path= ClassUtils.getDefaultClassLoader().
                getResource("").getPath().substring(1)+"static/officeToPdfTemp/"+subDir.split("[.]")[0];
        File dir=new File(path);
        if(!dir.exists()){
            dir.mkdirs();
        }
        return path;
    }

}
