package com.artfess.cqxy.projectManagement.dao;

import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 项目管理表(BizProjectManagement)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-02-10 15:43:43
 */
public interface ProjectManagementDao extends BaseMapper<ProjectManagement> {

    /**
     * 保存数据时，获取排序号
     * @return 数据总条数
     */
    Integer createSnNum();

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ProjectManagement> queryAllByPage(IPage<ProjectManagement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ProjectManagement> convert2Wrapper);

    /**
     * 重置当前项目为0以重新设置
     * @return num
     */
    Integer resetCurrentProject();

    /**
     * 设置默认的【当前项目】
     * @return num
     */
    int defaultCurrentProject();

    /**
     * 根据用户Id查询项目id集合
     * @param userId
     * @return
     */
    List<String> queryProjectIdsByUserId(String userId);

    /**
     *
     * @param convert2Wrapper 查询参数
     * @return
     */
    List<Map<String, Object>> queryProjectMoneyGroupByType(@Param(Constants.WRAPPER) Wrapper<ProjectManagement> convert2Wrapper);
}

