package com.artfess.cqxy.processManagermant.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 施工管理-技术资料(TechnicalInformation)表实体类
 *
 * @author basli
 * @since 2022年5月13日14:55:24
 */
@Data
@TableName("biz_technical_information")
@ApiModel(value="施工管理-技术资料-Technicalinformation", description="技术资料表")
public class TechnicalInformation extends BizModel<TechnicalInformation> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "会议时间",format = "yyyy-MM-dd")
    @TableField("CONFERENCE_DATE_")
    @ApiModelProperty(value = "会议时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date conferenceDate;

    @Excel(name = "会议地点")
    @TableField("CONFERENCE_PLACE_")
    @ApiModelProperty(value = "会议地点")
    private String conferencePlace;

    @Excel(name = "参加单位")
    @TableField("CONFERENCE_UNIT_")
    @ApiModelProperty(value = "参加单位")
    private String conferenceUnit;

    @Excel(name = "会议主题")
    @TableField("CONFERENCE_THEME_")
    @ApiModelProperty(value = "会议主题")
    private String conferenceTheme;

    @Excel(name = "经办人")
    @TableField("HANDLER_")
    @ApiModelProperty(value = "经办人，（默认值为：项目负责人）")
    private String handler;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "TechnicalInformation{" +
                "projectInfo=" + projectInfo +
                ", id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", conferenceDate=" + conferenceDate +
                ", conferencePlace='" + conferencePlace + '\'' +
                ", conferenceUnit='" + conferenceUnit + '\'' +
                ", conferenceTheme='" + conferenceTheme + '\'' +
                ", handler='" + handler + '\'' +
                ", remarks='" + remarks + '\'' +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }
}

