package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.processManagermant.dao.TechnicalInformationDao;
import com.artfess.cqxy.processManagermant.manager.TechnicalInformationManager;
import com.artfess.cqxy.processManagermant.model.TechnicalInformation;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 *
 * @author baseli
 * @since 2022-03-07 11:41:48
 */
@Service
public class TechnicalinformationManagerImpl extends BaseManagerImpl<TechnicalInformationDao, TechnicalInformation> implements TechnicalInformationManager {

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private ProjectManagementManager pmm;

    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdate(TechnicalInformation entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> accessoryList = entity.getAccessoryInfo();
        accessoryList = null == accessoryList ? new ArrayList<>() : accessoryList;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.ten.getCode());
            ele.setGroup("TechnicalInformation");
            ele.setNode(ProjectStatusEnum.ten.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eleven.getCode()));
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save || BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval,TechnicalInformation entity){
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirtyThree.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirtyThree.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirtyThree.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirtyThree.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyThree.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyThree.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyThree.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyThree.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getHandler()+"_"+entity.getConferenceUnit()+"_"+entity.getConferenceUnit());
        grm.saveOrUpdate(globalRetrieval);

    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    public TechnicalInformation getById(String id) {
        return baseMapper.getById(id);
    }

    @Override
    public PageList<TechnicalInformation> queryAllByPage(QueryFilter<TechnicalInformation> queryFilter) {
        BizUtils.handleFilter(queryFilter,"bpa" ,false);
        IPage<TechnicalInformation> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<TechnicalInformation> records = result.getRecords();
        for (TechnicalInformation ele: records ) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }

        return new PageList<>(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull(projectId,"项目ID不能为空");

        try(InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<TechnicalInformation> data = ExcelImportUtil.importExcel(inputStream,TechnicalInformation.class,new ImportParams());
            for(TechnicalInformation ele:data){
                ele.setProjectId(projectId);
                // 保存数据 & 同步到检索表
                save(ele);
                handleRetrieval(new GlobalRetrieval(),ele);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void exportDatatoExcel(QueryFilter<TechnicalInformation> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "施工管理-技术资料-导出结果";

        // 获取数据
        BizUtils.handleFilter(queryFilter,"bpa" ,false);
        List<TechnicalInformation> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0,-1,false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName += ".xlsx";

        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, TechnicalInformation.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper<TechnicalInformation> wrapper = new UpdateWrapper<TechnicalInformation>()
                .set(StringUtils.isNotBlank(newProjectId), "PROJECT_ID_", newProjectId)
                .in("PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update(wrapper);
    }
}

