package com.artfess.cqxy.ledger.manager.impl;

import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.completionAcceptance.manager.RecordAcceptanceManager;
import com.artfess.cqxy.completionAcceptance.model.RecordAcceptance;
import com.artfess.cqxy.constructionPermit.manager.ConstructionPermitManager;
import com.artfess.cqxy.constructionPermit.model.ConstructionPermit;
import com.artfess.cqxy.designEstimate.manager.ConstructionDrawingDesignManager;
import com.artfess.cqxy.designEstimate.manager.EstimateManager;
import com.artfess.cqxy.designEstimate.manager.PreliminaryDesignManager;
import com.artfess.cqxy.designEstimate.model.ConstructionDrawingDesign;
import com.artfess.cqxy.designEstimate.model.Estimate;
import com.artfess.cqxy.designEstimate.model.PreliminaryDesign;
import com.artfess.cqxy.feasiblePlan.manager.FeasibilityStudyReplyManager;
import com.artfess.cqxy.feasiblePlan.manager.PlanningEngineeringManager;
import com.artfess.cqxy.feasiblePlan.manager.PlanningSelectionSiteManager;
import com.artfess.cqxy.feasiblePlan.manager.PlanningUseLandManager;
import com.artfess.cqxy.feasiblePlan.model.FeasibilityStudyReply;
import com.artfess.cqxy.feasiblePlan.model.PlanningEngineering;
import com.artfess.cqxy.feasiblePlan.model.PlanningSelectionSite;
import com.artfess.cqxy.feasiblePlan.model.PlanningUseLand;
import com.artfess.cqxy.ledger.manager.ApprovalLedgerManager;
import com.artfess.cqxy.ledger.vo.ApprovalLedgerVo;
import com.artfess.cqxy.projectApproval.manager.ProjectEstablishmentManager;
import com.artfess.cqxy.projectApproval.model.ProjectEstablishment;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Limuhua
 * @date 2022/3/17 10:38
 */
@Service
public class ApprovalLedgerManagerImpl implements ApprovalLedgerManager {

    @Autowired
    private ProjectManagementManager projectManager;
    @Autowired
    private ProjectEstablishmentManager establishmentManager;
    @Autowired
    private FeasibilityStudyReplyManager replyManager;
    @Autowired
    private EstimateManager estimateManager;
    @Autowired
    private PlanningSelectionSiteManager siteManager;
    @Autowired
    private PlanningUseLandManager useLandManager;
    @Autowired
    private PlanningEngineeringManager engineeringManager;
    @Autowired
    private PreliminaryDesignManager designManager;
    @Autowired
    private ConstructionDrawingDesignManager drawingManager;
    @Autowired
    ConstructionPermitManager permitManager;
    @Autowired
    private RecordAcceptanceManager recordManager;
    @Autowired
    private SysDictionaryManager sdm;

    @Override
    public Map<String, Object> queryByPage(QueryFilter<ProjectManagement> queryFilter) {
        Map<String, Object> result = new HashMap<>(4);
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_",Direction.ASC));
        queryFilter.addFilter("PARENT_ID_","root", QueryOP.EQUAL);
        PageList project = projectManager.queryAllByPage(queryFilter);
        List<ProjectManagement> projectList = null == project.getRows() ? new ArrayList<>() : project.getRows();
        result.put("data", handleAppro(projectList));
        result.put("total", project.getTotal());
        result.put("page", project.getPage());
        result.put("pageSize", project.getPageSize());
        return result;
    }

    private List<ApprovalLedgerVo> handleAppro(List<ProjectManagement> projectList) {
        List<ApprovalLedgerVo> data = new ArrayList<>();
        for (ProjectManagement ele : projectList) {
            ApprovalLedgerVo temp = new ApprovalLedgerVo();
            // 项目信息
            List<DictModel> projectStatus = sdm.queryDictListItemsByCode("xmgl-xmzt");
            temp.setProjectName(ele.getProjectName());
            temp.setCurrentProcedure(BizUtils.getDicValueByCode(projectStatus, ele.getProjectStatus()));
            temp.setProjectType(Integer.valueOf(ele.getProjectType()));
            // 项目立项信息
//            ProjectEstablishment establishment = establishmentManager.getOne(new QueryWrapper<ProjectEstablishment>().
//                    eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
//                    .orderBy(true, false, "ESTABLISHMENT_DATE_").last("limit 1"));
//            temp.setEstablishDT(null == establishment ? "" : (StringUtils.isBlank(establishment.getDocumentNumber())? "" :
//                    establishment.getDocumentNumber()) + "  " +
//                    BizUtils.dateFormatChineseStyle(establishment.getEstablishmentDate()));

            List<ProjectEstablishment> establishments = establishmentManager.list(new QueryWrapper<ProjectEstablishment>().
                    eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
                    .orderBy(true, false, "ESTABLISHMENT_DATE_"));

            String establishDT = "";
            if(BeanUtils.isNotEmpty(establishments) && establishments.size()>0){
                for(ProjectEstablishment pe : establishments){
                    if(BeanUtils.isNotEmpty(pe.getDocumentNumber())){
                        if(establishments.indexOf(pe)==0){
                            establishDT = pe.getDocumentNumber() + " " +
                                    BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate());
                        }else {
                            establishDT = establishDT + "、" + pe.getDocumentNumber() + "  " +
                                    BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate());
                        }
                    }
                }
            }
            temp.setEstablishDT(establishDT);


            // 可研批复信息
            FeasibilityStudyReply reply = replyManager.getOne(new QueryWrapper<FeasibilityStudyReply>()
                    .eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
                    .orderBy(true, false, "ESTABLISHMENT_DATE_").last("limit 1"));
            reply  = reply == null? new FeasibilityStudyReply() : reply;
            temp.setFeasiblePlanDT(null == reply? "" : StringUtils.isBlank(reply.getDocumentNumber())?"": reply.getDocumentNumber() + "  " +
                    BizUtils.dateFormatChineseStyle(reply.getEstablishmentDate()));

            temp.setFeasiblePlanInfo((StringUtils.isBlank(reply.getEstablishmentInvestmentAmount()) ? "" :(StringUtils.isBlank(reply.getEstablishmentScale())?"":reply.getEstablishmentScale() + "总投资为" +
                    reply.getEstablishmentInvestmentAmount() +
                    "万元，建安" + (StringUtils.isBlank(reply.getEngineeringCost())?"0":reply.getEngineeringCost() + "万元。"))));
            // 概算信息
            Estimate estimate = estimateManager.getOne(new QueryWrapper<Estimate>().
                    eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
                    .orderBy(true, false, "ESTABLISHMENT_DATE_").last("limit 1"));
            estimate = (null == estimate)? new Estimate() : estimate;

            temp.setEstimateDT(StringUtils.isBlank(estimate.getDocumentNumber())?"": estimate.getDocumentNumber() + "  " +
                    BizUtils.dateFormatChineseStyle(estimate.getEstablishmentDate()));
            temp.setEstimateInfo((StringUtils.isBlank(estimate.getTotalEstimate())?"":("总投资为" + estimate.getTotalEstimate() +
                    "万元，建安" + (StringUtils.isBlank(estimate.getEngineeringCost())?"0":estimate.getEngineeringCost()) + "万元。")));
            // 选址信息
            PlanningSelectionSite site = siteManager.getOne(new QueryWrapper<PlanningSelectionSite>()
                    .eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0").last("limit 1"));
            temp.setSiteDT(null == site ? "" : (StringUtils.isBlank(site.getDocumentNumber())?"":
                    site.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(site.getEstablishmentDate())));
            // 用地信息
            PlanningUseLand useLand = useLandManager.getOne(new QueryWrapper<PlanningUseLand>().
                    eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
                    .orderBy(true, false, "ESTABLISHMENT_DATE_").last("limit 1"));
            temp.setUseLandDT(null == useLand ? "" : (StringUtils.isBlank(useLand.getCode())?"":useLand.getCode() + "  " +
                    BizUtils.dateFormatChineseStyle(useLand.getEstablishmentDate())));
            temp.setUseLandCode(null == useLand ? "" : BizUtils.handleStringFormat(useLand.getCode()));
            // 初步设计信息
            PreliminaryDesign design = designManager.getOne(new QueryWrapper<PreliminaryDesign>().
                    eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
                    .orderBy(true, false, "ESTABLISHMENT_DATE_").last("limit 1"));
            design = null == design? new PreliminaryDesign():design;
            temp.setPreliminaryDesignDT( StringUtils.isBlank(design.getDocumentNumber())?"":design.getDocumentNumber() + "  " +
                    BizUtils.dateFormatChineseStyle(design.getEstablishmentDate()));
            // 工程规划
            List<DictModel> engineeringType = sdm.queryDictListItemsByCode("gcgh-lx");// 字典
            List<PlanningEngineering> planningEngineeringList = engineeringManager.list(new QueryWrapper<PlanningEngineering>()
                    .eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0"));
            List<String> specialReview = new ArrayList<>();
            for (PlanningEngineering pe : planningEngineeringList) {
                if ("1".equals(pe.getType())) {
                    temp.setPorjectPlanningDT(StringUtils.isBlank(pe.getDocumentNumber())?"": pe.getDocumentNumber()+ "  " +
                            BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate()));
                    temp.setPorjectPlanningScale(StringUtils.isBlank(pe.getConstructionScale())?"":pe.getConstructionScale());
                } else {
                    specialReview.add(BizUtils.getDicValueByCode(engineeringType, pe.getType()) + "：" +
                            pe.getDocumentNumber() + "  " + BizUtils.dateFormatChineseStyle(pe.getEstablishmentDate()));
                }
            }
            temp.setSpecialReview(specialReview);
            // 施工图设计信息
            ConstructionDrawingDesign drawingDesign = drawingManager.getOne(new QueryWrapper<ConstructionDrawingDesign>().
                    eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
                    .orderBy(true, false, "ESTABLISHMENT_DATE_").last("limit 1"));
            temp.setConstructionDrawingDT(null == drawingDesign ? "" : (StringUtils.isBlank(drawingDesign.getDocumentNumber())?"" :
                    drawingDesign.getDocumentNumber() + "  " +
                    BizUtils.dateFormatChineseStyle(drawingDesign.getEstablishmentDate())));
            // 施工许可信息
            ConstructionPermit constructionPermit = permitManager.getOne(new QueryWrapper<ConstructionPermit>().
                    eq("PROJECT_ID_", ele.getId()).eq("IS_DELE_", "0")
                    .orderBy(true, false, "ESTABLISHMENT_DATE_").last("limit 1"));
            temp.setConstructionPermitName(null == constructionPermit ? "" : BizUtils.handleStringFormat(constructionPermit.getName()));
            temp.setConstructionDrawingDT(null == constructionPermit ? "" : (StringUtils.isBlank(constructionPermit.getCode())?"":
                    constructionPermit.getCode() + "  " +
                    BizUtils.dateFormatChineseStyle(constructionPermit.getEstablishmentDate())));
            // 备案验收信息
            RecordAcceptance record = recordManager.getOne(new QueryWrapper<RecordAcceptance>().
                    eq("PROJECT_ID_", ele.getId())
                    .eq("IS_DELE_", "0")
                    .orderBy(true, false, "APPROVAL_FILING_AUTHORITY_DATE_").last("limit 1"));
            record = null == record? new RecordAcceptance(): record;
            temp.setRecordAcceptanceDT( StringUtils.isBlank(record.getDocumentNumber())?"":record.getDocumentNumber() + "  " +
                    BizUtils.dateFormatChineseStyle(record.getApprovalFilingAuthorityDate()));
            // 封进List
            data.add(temp);
        }
        return data;
    }

    @Override
    public void exportDataToExcel(QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws IOException {
        // 获取字典
        List<DictModel> pType = sdm.queryDictListItemsByCode("xmgl-xmlx");
        List<DictModel> pStatus = sdm.queryDictListItemsByCode("xmgl-xmzt");
        List<DictModel> engineeringType = sdm.queryDictListItemsByCode("gcgh-lx");

        // 获取导出年份拼接表头
        String year = null;
        List<QueryField> test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if ("COMMENCEMENT_TIME_".equals(ele.getProperty()) || "COMMENCEMENT_TIME_".toLowerCase().equals(ele.getProperty())) {
                String value = ele.getValue().toString();
                year = value.split("-")[0].replaceAll("\\[","");
                break;
            }
        }
        // 拼接导出年份到文件名，没有则不添加
        String fileName = "西永微电园公司建设项目审批台账一览表" + (StringUtils.isEmpty(year) ? "" : "（" + year + "）");
        // 创建excel工作薄
        HSSFWorkbook workbook = new HSSFWorkbook();
        // 创建excel表
        HSSFSheet sheet = workbook.createSheet(fileName);
        //创建样式
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        //设置字体
        HSSFFont font = workbook.createFont();
        //设置字体名称
        font.setFontName("宋体");
        cellStyle.setFont(font);
        cellStyle.setWrapText(true);


        // 处理表头
        // 第一行
        HSSFRow titleRow = sheet.createRow(0);
        BizUtils.handelCell(workbook,fileName, titleRow.createCell(0), fileName, true);
        // 标题行
        // 拼接标题行数据
        List<String> heards = new ArrayList<>();
        // 注意：Arrays.asList 将会返回一个不可修改的List，不能在初始化时调用
        heards.addAll(Arrays.asList(new String[]{"序号", "项目名称", "立项/核准/备案", "可研", " ", "用地预审与选址意见书", "用地手续", "规划用地许可"
                ,"专项审查（轨道、环保、消防、行洪等）"}));
        List<String> subHeards = new ArrayList<>();
        subHeards.addAll(Arrays.asList(new String[]{" ", " ", "批复文号及时间", "批复文号及时间", "批复规模、总投资及建安投资（万元）",
                "批复文号及时间","类型、批文号及时间","批复文号及时间"}));

        // 获取数据
        queryFilter.withSorter(new FieldSort("PROJECT_TYPE_",Direction.ASC));
        queryFilter.addFilter("PARENT_ID_","root", QueryOP.EQUAL);
        List<ApprovalLedgerVo> result = handleAppro(projectManager.queryAllByPage(queryFilter).getRows());
        List<ApprovalLedgerVo> data = null == result ? new ArrayList<>() : result;

        //求出专项审查最多的个数,默认为1
        int maxSpecialNum = 1;
        for(int i = 0 ;i < data.size(); i++){
            int target = data.get(i).getSpecialReview().size();
            if(target>maxSpecialNum){
                maxSpecialNum = target;
            }
        }

        // 合并单元格的结束位置
        int cloEnd = 8;
//        int cloEnd = 13;
        for (int i = 0;i<maxSpecialNum;i++) {
            heards.add("");
            subHeards.add("类别、批复文号及时间");
            cloEnd++;
        }
//        for (DictModel ele : engineeringType) {
//            if (!"1".equals(ele.getValue())) {
//                heards.add("");
//                subHeards.add("类别、批复文号及时间");
//                cloEnd++;
//            }
//        }
        // 删除多添加的一个数据
        heards.remove(heards.size()-1);
        heards.addAll(Arrays.asList(new String[]{"规划许可"," ","初步设计","概算", " ","施工图审查备案", "施工许可", " ", "竣工验收备案"}));
        subHeards.addAll(Arrays.asList(new String[]{"批复文号及时间", "批复规模","批复文号及时间","批复文号及时间","批复总投资及建安投资（万元）","批复文号及时间","施工许可名称","批复文号及时间","批复文号及时间"}));
        // 创建标题行并写入数据
        HSSFRow titleRow1 = sheet.createRow(1);
        for (int i = 0; i < heards.size(); i++) {
            BizUtils.handelCell(workbook,fileName, titleRow1.createCell(i), heards.get(i));
        }
        HSSFRow titleRow2 = sheet.createRow(2);
        for (int i = 0; i < subHeards.size(); i++) {
            BizUtils.handelCell(workbook,fileName, titleRow2.createCell(i), subHeards.get(i));
        }
        // 合并单元格
        //表头
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, cloEnd+8));
        //序号
        sheet.addMergedRegion(new CellRangeAddress(1, 2, 0, 0));
        //项目名称
        sheet.addMergedRegion(new CellRangeAddress(1, 2, 1, 1));
        //可研
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 3, 4));
        //专项审查
        if(cloEnd!=9){
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 8, cloEnd-1));
        }

        //规划许可
        sheet.addMergedRegion(new CellRangeAddress(1, 1, cloEnd, cloEnd+1));
        //概算
        sheet.addMergedRegion(new CellRangeAddress(1, 1, cloEnd+3, cloEnd+4));
        //施工许可
        sheet.addMergedRegion(new CellRangeAddress(1, 1, cloEnd+6, cloEnd+7));

        // 数据行,从3行开始,共data.size行
        int row = 3;
        // 当前类型标记
        int currentType = data.get(0).getProjectType()-1;
        // 计数器，当前分类下的序号标记
        int counter = 1;

        // 处理第一条数据就漏分类的情况，即不从一开始就会丢失一到第一条数据的类别统计
        for(int j = 1;j<data.get(0).getProjectType();j++){
            HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
            handleSubTitle(j,fileName, subHeards.size(),pType, workbook, addRow);
            row++;
        }

        // 处理数据
        for (int i = 0; i < data.size(); i++) {
            HSSFRow listRow = sheet.createRow(row);// 创建行
            if (currentType != data.get(i).getProjectType()) {
                // 当前项目类型标记 不同于 循环中项目的项目类型时，需要为其分类
                // 更新当前项目类型标记
                int oldType = currentType;
                currentType = data.get(i).getProjectType();

                if(currentType - oldType > 1){
                    // 处理断层情况，当中间数据的项目类型丢失的情况，即上一类为1，当前类为3，那就要补上中间漏掉的类2
                    for (int j = oldType++; j < currentType; j = oldType++) {
                        if(oldType>7&&oldType<12){
                            continue;
                        }
                        handleSubTitleOther(oldType,fileName, subHeards.size(),pType, workbook, listRow);
                        if(oldType!=currentType){
                            row = row+1;
                            listRow = sheet.createRow(row);// 创建行
                        }
                    }
                }else {
                    // 处理子标题行
                    handleSubTitleOther(currentType,fileName, subHeards.size(),pType, workbook, listRow);
                }

                // 重置子标题下的序号计数器
                counter = 1;
                // 撤销当前循环
                i--;
            } else if (data.get(i).getProjectType() - currentType > 1) {
                // 处理断层情况，当中间数据的项目类型丢失的情况，即上一类为1，当前类为3，那就要补上中间漏掉的类2
                for (int j = currentType++; j < data.get(i).getProjectType(); j = currentType++) {
                    HSSFRow addRow = sheet.createRow(sheet.getLastRowNum() + 1);
                    handleSubTitleOther(currentType,fileName, subHeards.size(),pType, workbook, addRow);
                }
            } else {
                data.get(i).replace();
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(0), String.valueOf(counter));
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(1), data.get(i).getProjectName());
                  // 在办建设手续 cellStyle, font,
//              BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(2), BizUtils.getDicValueByCode(pStatus, data.get(i).getCurrentProcedure()));
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(2), data.get(i).getEstablishDT());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(3), data.get(i).getFeasiblePlanDT());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(4), data.get(i).getFeasiblePlanInfo());
                //土地
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(5), data.get(i).getSiteDT());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(6), data.get(i).getUseLandDT());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(7), data.get(i).getUseLandCode());

                //专项审查
                List<String> specialReview = null == data.get(i).getSpecialReview()?new ArrayList<>():data.get(i).getSpecialReview();
                int currCell = 8;
//                int currCell = 13;
                for(int t = 0;t<maxSpecialNum;t++){
                    if (t<specialReview.size()){
                        BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), specialReview.get(t));
                    }else{
                        BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), "");
                    }
                    currCell++;
                }

//                for(int t = 0;t<engineeringType.size();t++){
//                    if (t<specialReview.size()){
//                        BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), specialReview.get(t));
//                    }else{
//                        BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), "");
//                    }
//                    currCell++;
//                }
                //施工图审查备案文号及时间
                //规划许可
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell), data.get(i).getPorjectPlanningDT());
                BizUtils.handelCell(workbook, cellStyle, fileName, listRow.createCell(currCell+1), data.get(i).getPorjectPlanningScale());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell+2), data.get(i).getPreliminaryDesignDT());
                //概算
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell+3), data.get(i).getEstimateDT());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell+4), data.get(i).getEstimateInfo());

                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell+5), data.get(i).getConstructionDrawingDT());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell+6), data.get(i).getConstructionPermitName());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell+7), data.get(i).getConstructionPermitDT());
                BizUtils.handelCell(workbook, cellStyle, font, fileName, listRow.createCell(currCell+8), data.get(i).getRecordAcceptanceDT());
                counter++;
            }
            row++;
        }

        // 填充没有数据的分类
        // 最后一行
        int lastIndex = sheet.getLastRowNum() + 1;
        for (int i = currentType++; i < pType.size(); i = currentType++) {
            HSSFRow lastRow = sheet.createRow(lastIndex++);
            if(currentType==8){
                handleSubTitleOther(12,fileName, subHeards.size(),pType, workbook, lastRow);
            }else {
                handleSubTitleOther(currentType,fileName, subHeards.size(),pType, workbook, lastRow);
            }
        }


        sheet.setColumnWidth(0,2000);
        sheet.setColumnWidth(1,6000);
        sheet.setColumnWidth(2,8000);
        for(int i = 3;i<subHeards.size();i++){
            sheet.setColumnWidth(i,4000);
        }

        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    /**
     * 处理子标题行
     *
     * @param currentType 当前项目类型
     * @param fileName    文件名，即Sheet名，用于获取Sheet单元格
     * @param workbook    workBook工作蒲
     * @param row         行
     */
    private void handleSubTitle(int currentType,String fileName, int length ,List<DictModel> dic, HSSFWorkbook workbook, HSSFRow row) {
        for (int t = 0; t < length; t++) {
            if (t == 0) {
                BizUtils.handelCell(workbook,fileName, row.createCell(t), BizUtils.converttoChinaNumber(currentType));
            } else if (t == 1) {
                BizUtils.handelCell(workbook,fileName, row.createCell(t), BizUtils.getDicValueByCode(dic, currentType));
            } else {
                BizUtils.handelCell(workbook,fileName, row.createCell(t), "");
            }
        }
    }


    /**
     * 处理子标题行，字典值与分类序号不同的情况
     *
     * @param currentType 当前项目类型
     * @param fileName    文件名，即Sheet名，用于获取Sheet单元格
     * @param workbook    workBook工作蒲
     * @param row         行
     */
    private void handleSubTitleOther(int currentType,String fileName, int length ,List<DictModel> dic, HSSFWorkbook workbook, HSSFRow row) {
        for (int t = 0; t < length; t++) {
            if (t == 0) {
                BizUtils.handelCell(workbook,fileName, row.createCell(t), BizUtils.converttoChinaNumber((currentType==12)?8:currentType));
            } else if (t == 1) {
                BizUtils.handelCell(workbook,fileName, row.createCell(t), BizUtils.getDicValueByCode(dic,currentType));
            } else {
                BizUtils.handelCell(workbook,fileName, row.createCell(t), "");
            }
        }
    }

}
