package com.artfess.cqxy.ledger.manager;

import cn.hutool.json.JSONObject;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;

/**
 * @author Limuhua
 * @date 2022/3/30 14:23
 */
public interface InvestmentLedgerManager {

    /**
     * 分页查询数据，使用了项目管理的查询器
     * @param queryFilter 项目管理查询器
     * @return 数据
     */
    Map<String, Object> queryByPage(QueryFilter<ProjectManagement> queryFilter);

    /**
     * 导出数据到Excel
     * @param queryFilter 项目管理查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<ProjectManagement> queryFilter, HttpServletResponse response) throws Exception;

    JSONObject yearTotalInvest(Integer year);

    /**
     * 查询年度总投资
     * @param year
     * @return
     */
    BigDecimal totalInvestByYear(Integer year);
}
