package com.artfess.cqxy.feasiblePlan.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 规划许可-土地表(BizPlanningSelectionLand)表实体类
 * @author 黎沐华
 * @since 2022-02-15 10:13:19
 */
@Data
@TableName("BIZ_PLANNING_SELECTION_LAND")
@ApiModel(value="可研规划-规划许可-土地对象-PlanningSelectionLand", description="规划许可-土地表")
public class PlanningSelectionLand extends BizModel<PlanningSelectionLand> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

//    @Excel(name = "名称")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    private String name;

//    @Excel(name = "批准文号")
    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "批准文号")
    private String documentNumber;

    @Excel(name = "批准机关")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "批准机关")
    private String establishmentApprovalUnit;

    @Excel(name = "批准日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "批准日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

    @Excel(name = "编号")
    @TableField("CODE_")
    @ApiModelProperty(value = "编号")
    private String code;

    @Excel(name = "宗地编号")
    @TableField("PARCEL_NUMBER_")
    @ApiModelProperty(value = "宗地编号")
    private String parcelNumber;

    @Excel(name = "宗地用途")
    @TableField("PARCEL_PURPOSE_")
    @ApiModelProperty(value = "宗地用途")
    private String parcelPurpose;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

//    @Excel(name = "划拨用地使用权人")
    @TableField("CONSTRUCTION_UNIT_")
    @ApiModelProperty(value = "划拨用地使用权人")
    private String constructionUnit;

//    @Excel(name = "建设项目名称")
    @TableField("CONSTRUCTION_PROJECT_NAME_")
    @ApiModelProperty(value = "建设项目名称")
    private String constructionProjectName;

//    @Excel(name = "宗地坐落于(位置)")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "宗地坐落于(位置)")
    private String proposedLocation;

//    @Excel(name = "宗地总面积(平方米)")
    @TableField("PROPOSED_LAND_AREA_")
    @ApiModelProperty(value = "宗地总面积(平方米)")
    private String proposedLandArea;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "PlanningSelectionLand{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", constructionUnit='" + constructionUnit + '\'' +
                ", constructionProjectName='" + constructionProjectName + '\'' +
                ", parcelPurpose='" + parcelPurpose + '\'' +
                ", parcelNumber='" + parcelNumber + '\'' +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", proposedLandArea='" + proposedLandArea + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

