package com.artfess.cqxy.documentLibrary.dao;

import java.util.List;

import com.artfess.cqxy.projectManagement.model.DirectoryManagement;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.documentLibrary.model.FileLibraryType;

/**
 * 文件库-分类表(FileLibraryType)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-04-02 09:21:22
 */
public interface FileLibraryTypeDao extends BaseMapper<FileLibraryType> {

    /**
     * 更新是否有子节点状态
     * @param id id
     * @param status 状态，有/无
     * @return num
     */
    int updateChildNodeStatus(@Param("id") String id,@Param("status") String status);


    /**
     * 根据父节点ID获取其子节点数据
     * @param pCode 父节点ID
     * @return 树状数据
     */
    List<FileLibraryType> getByParentCode(@Param("pCode") String pCode);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<FileLibraryType> queryChildNodeByPage(IPage<FileLibraryType> convert2IPage, @Param(Constants.WRAPPER) Wrapper<FileLibraryType> convert2Wrapper);

}

