package com.artfess.cqxy.designEstimate.dao;

import com.artfess.cqxy.designEstimate.model.Estimate;
import com.artfess.cqxy.designEstimate.model.GeologicalProspecting;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;

/**
 * @Description: 设计概算-地勘
 * @Author: Rong Tao
 * @Date: 2022/10/20 14:25
 */
public interface GeologicalProspectingDao extends BaseMapper<GeologicalProspecting> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    GeologicalProspecting getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<GeologicalProspecting> queryAllByPage(IPage<GeologicalProspecting> convert2IPage, @Param(Constants.WRAPPER) Wrapper<GeologicalProspecting> convert2Wrapper);
}
