package com.artfess.cqxy.completionAcceptance.dao;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.completionAcceptance.model.AcceptanceSettlement;

/**
 * 竣工验收 - 结算表(BizAcceptanceSettlement)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-07 15:15:05
 */
public interface AcceptanceSettlementDao extends BaseMapper<AcceptanceSettlement> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    AcceptanceSettlement getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<AcceptanceSettlement> queryAllByPage(IPage<AcceptanceSettlement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<AcceptanceSettlement> convert2Wrapper);

}

