package com.artfess.cqxy.completionAcceptance.dao;

import java.util.List;

import com.artfess.cqxy.completionAcceptance.model.AcceptanceFinalTransfer;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.completionAcceptance.model.AcceptanceFinalTransfer;

/**
 * 竣工验收 - 移交表(BizAcceptanceFinalTransfer)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-10 15:53:07
 */
public interface AcceptanceFinalTransferDao extends BaseMapper<AcceptanceFinalTransfer> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    AcceptanceFinalTransfer getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<AcceptanceFinalTransfer> queryAllByPage(IPage<AcceptanceFinalTransfer> convert2IPage, @Param(Constants.WRAPPER) Wrapper<AcceptanceFinalTransfer> convert2Wrapper);

}

