package com.artfess.cqxy.bidManagement.dao;

import java.util.List;

import com.artfess.cqxy.bidManagement.model.BiddingPriceLimit;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.bidManagement.model.BiddingPriceLimit;

/**
 * 招投标管理 - 清单限价 - 编制(BiddingPriceLimit)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-04-08 11:08:42
 */
public interface BiddingPriceLimitDao extends BaseMapper<BiddingPriceLimit> {

    /**
     * 通过ID获取数 据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    BiddingPriceLimit getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<BiddingPriceLimit> queryAllByPage(IPage<BiddingPriceLimit> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BiddingPriceLimit> convert2Wrapper);

}

