package com.artfess.workflow.runtime.dao;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.artfess.workflow.runtime.model.BpmPrintRecord;

/**
 * 
 * <pre> 
 * 描述：流程打印文件管理表 DAO接口
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-05-23 19:58:35
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface BpmPrintRecordDao extends BaseMapper<BpmPrintRecord> {
	/**
	 * 根据实例节点等信息获取打印文件的最后版本
	 * @param procInstId
	 * @param nodeId
	 * @param templateId
	 * @return
	 */
	BpmPrintRecord getLastVersion(@Param("procInstId")String procInstId,@Param("nodeId")String nodeId, @Param("templateId")String templateId);
	/**
	 * 清除最后版本标识
	 * @param procInstId
	 * @param nodeId
	 * @param templateId
	 */
	void cleanLastVersion(@Param("procInstId")String procInstId,@Param("nodeId")String nodeId, @Param("templateId")String templateId);
}
