package com.artfess.cqxy.projectManagement.model;


import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * 项目人员中间表(BizProjectPersonnel)表实体类
 *
 * @author 黎沐华
 * @since 2022-02-12 14:41:17
 */
@TableName("BIZ_PROJECT_PERSONNEL")
@ApiModel(value="项目管理-项目人员对象-ProjectPersonnel", description="项目人员中间表")
public class ProjectPersonnel extends BizModel<ProjectPersonnel> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("PERSONNEL_ID_")
    @ApiModelProperty(value = "人员ID（关联人员表ID）")
    private String personnelId;

    public ProjectPersonnel() {}
    public ProjectPersonnel(String projectId, String personnelId) {
        this.projectId = projectId;
        this.personnelId = personnelId;
    }

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ProjectPersonnel{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", personnelId='" + personnelId + '\'' +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getPersonnelId() {
        return personnelId;
    }

    public void setPersonnelId(String personnelId) {
        this.personnelId = personnelId;
    }
}

