package com.artfess.cqxy.constructionPermit.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 施工许可表(ConstructionPermitNew)表实体类
 * @author 黎沐华
 * @since 2022-02-23 10:24:54
 */
@Data
@TableName("biz_construction_permit_new_")
@ApiModel(value="施工许可对象-ConstructionPermitNew", description="施工许可表")
public class ConstructionPermitNew extends BizModel<ConstructionPermitNew> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @Excel(name = "证件编号")
    @TableField("CODE_")
    @ApiModelProperty(value = "证件编号")
    private String code;

    @Excel(name = "工期")
    @TableField("CONTRACT_DURATION_")
    @ApiModelProperty(value = "工期")
    private String contractDuration;

    @Excel(name = "发证机关")
    @TableField("ESTABLISHMENT_APPROVAL_UNIT_")
    @ApiModelProperty(value = "发证机关")
    private String establishmentApprovalUnit;

    @Excel(name = "发证日期",format = "yyyy-MM-dd")
    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "发证日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

//    @Excel(name = "建设单位")
    @TableField("NAME_")
    @ApiModelProperty(value = "建设单位")
    private String name;

//    @Excel(name = "建设单位负责人")
    @TableField("PERSON_")
    @ApiModelProperty(value = "建设单位负责人")
    private String person;

//    @Excel(name = "建设单位负责人联系电话")
    @TableField("PHONE_")
    @ApiModelProperty(value = "建设单位负责人联系电话")
    private String phone;

//    @Excel(name = "勘察单位")
    @TableField("SURVEY_UNIT_")
    @ApiModelProperty(value = "勘察单位")
    private String surveyUnit;

//    @Excel(name = "勘察单位负责人")
    @TableField("SURVEY_UNIT_PERSON_")
    @ApiModelProperty(value = "勘察单位负责人")
    private String surveyUnitPerson;

//    @Excel(name = "勘察单位负责人联系电话")
    @TableField("SURVEY_UNIT_PHONE_")
    @ApiModelProperty(value = "勘察单位负责人联系电话")
    private String surveyUnitPhone;

//    @Excel(name = "设计单位")
    @TableField("DESIGN_UNIT_")
    @ApiModelProperty(value = "设计单位")
    private String designUnit;

//    @Excel(name = "设计单位负责人")
    @TableField("DESIGN_UNIT_PERSON_")
    @ApiModelProperty(value = "设计单位负责人")
    private String designUnitPerson;

//    @Excel(name = "设计单位负责人联系电话")
    @TableField("DESIGN_UNIT_PHONE_")
    @ApiModelProperty(value = "设计单位负责人联系电话")
    private String designUnitPhone;

//    @Excel(name = "施工单位")
    @TableField("CONSTRUCTION_UNIT_")
    @ApiModelProperty(value = "施工单位")
    private String constructionUnit;

//    @Excel(name = "施工单位负责人")
    @TableField("CONSTRUCTION_UNIT_PERSON_")
    @ApiModelProperty(value = "施工单位负责人")
    private String constructionUnitPerson;

//    @Excel(name = "施工单位负责人联系电话")
    @TableField("CONSTRUCTION_UNIT_PHONE_")
    @ApiModelProperty(value = "施工单位负责人联系电话")
    private String constructionUnitPhone;

//    @Excel(name = "监理单位")
    @TableField("SUPERVISOR_UNIT_")
    @ApiModelProperty(value = "监理单位")
    private String supervisorUnit;

//    @Excel(name = "监理单位负责人")
    @TableField("SUPERVISOR_UNIT_PERSON_")
    @ApiModelProperty(value = "监理单位负责人")
    private String supervisorUnitPerson;

//    @Excel(name = "监理单位负责人联系电话")
    @TableField("SUPERVISOR_UNIT_PHONE_")
    @ApiModelProperty(value = "监理单位负责人联系电话")
    private String supervisorUnitPhone;

    @Excel(name = "建设地址")
    @TableField("PROPOSED_LOCATION_")
    @ApiModelProperty(value = "建设地址")
    private String proposedLocation;

    @Excel(name = "建设规模")
    @TableField("PROPOSED_LAND_AREA_")
    @ApiModelProperty(value = "建设规模")
    private String proposedLandArea;

//    @Excel(name = "合同价格（万元）")
    @TableField("CONTRACT_PRICE_")
    @ApiModelProperty(value = "合同价格（万元）")
    private String contractPrice;

    @Excel(name = "备注")
    @TableField("ESTABLISHMENT_REMARKS_")
    @ApiModelProperty(value = "备注")
    private String establishmentRemarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ConstructionPermitNew{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", name='" + name + '\'' +
                ", code='" + code + '\'' +
                ", establishmentApprovalUnit='" + establishmentApprovalUnit + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", proposedLocation='" + proposedLocation + '\'' +
                ", proposedLandArea='" + proposedLandArea + '\'' +
                ", contractPrice='" + contractPrice + '\'' +
                ", surveyUnit='" + surveyUnit + '\'' +
                ", designUnit='" + designUnit + '\'' +
                ", constructionUnit='" + constructionUnit + '\'' +
                ", supervisorUnit='" + supervisorUnit + '\'' +
                ", contractDuration='" + contractDuration + '\'' +
                ", establishmentRemarks='" + establishmentRemarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

}

