package com.artfess.base.feign;

import com.artfess.base.conf.FeignConfig;
import com.artfess.base.feign.impl.WorkflowFeignServiceFactory;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 流程引擎接口访问的代理类
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年8月21日
 */
@FeignClient(name="bpm-workflow",fallbackFactory= WorkflowFeignServiceFactory.class, configuration= FeignConfig.class, primary = false)
public interface WorkflowFeignService {
    /***********************************************流程设计代理类（bpm-model）****************************************************************/
	/**
	 * 获取常用语
	 * @param defKey
	 * @param typeId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/flow/approvalItem/v1/getApprovalByDefKeyAndTypeId",method=RequestMethod.GET, produces = { "application/json; charset=utf-8" })
	public List<String> getApprovalByDefKeyAndTypeId(
			@RequestParam(value="defKey", required = true) String defKey,
			@RequestParam(value="typeId",required = true) String typeId,
			@RequestParam(name="userId",required=true) String userId);

	/**
	 * 执行催办任务
	 */
	@RequestMapping(value="/flow/bpmTaskReminder/v1/executeTaskReminderJob",method=RequestMethod.GET)
	public CommonResult<String> executeTaskReminderJob();

	/**
	 * 检测bo是否已绑定流程
	 */
	@RequestMapping(value="/flow/def/v1/isBoBindFlowCheck",method=RequestMethod.GET)
	public CommonResult<Boolean> isBoBindFlowCheck(@RequestParam(value="boCode", required=true) String boCode,@RequestParam(value="formKey", required=true) String formKey);

	/**
	 * 获取我的常用流程key
	 */
	@RequestMapping(value="/bpmModel/BpmOftenFlow/v1/getMyOftenFlowKey",method=RequestMethod.GET)
	public Set<String> getMyOftenFlowKey();

	@RequestMapping(value = "/flow/def/v1/bpmDefinitionData",method=RequestMethod.GET)
	public List<Map<String, String>> bpmDefinitionData(@RequestParam(value="alias", required=true)String alias);

	@RequestMapping(value = "/flow/def/v1/getBindRelation",method=RequestMethod.GET)
	public Map<String, Object> definitionData(@RequestParam(value="defId", required=true)String defId);

	@RequestMapping(value = "/flow/def/v1/getJson",method=RequestMethod.GET)
	public ObjectNode getProcDefByDefKey(@RequestParam(value="defKey", required=true)String defKey);


	/***********************************************流程运行Restful接口访问的代理类（bpm-runtime）****************************************************************/
	@RequestMapping(value = "/runtime/instance/v1/start", method = RequestMethod.POST)
	public ObjectNode start(@RequestBody ObjectNode startFlowParamObject) throws Exception;

	@RequestMapping(value = "/runtime/instance/v1/getBusLink", method = RequestMethod.POST)
	public List<String> getBusLink(@RequestBody ObjectNode startFlowParamObject) throws Exception;

	@RequestMapping(value = "/runtime/instance/v1/getByBusinesKey", method = RequestMethod.GET)
	public ObjectNode getByBusinesKey(@RequestParam(value="businessKey", required=true)String businessKey,@RequestParam(value="formIdentity")String formIdentity,@RequestParam(value="isNumber", required=true)Boolean isNumber) throws Exception;

	@RequestMapping(value = "/runtime/instance/v1/getDataByDefId", method = RequestMethod.GET)
	public List<ObjectNode> getDataByDefId(@RequestParam(value="defId", required=true) String defId) throws Exception;

	@RequestMapping(value = "/runtime/instance/v1/getDataByInst", method = RequestMethod.GET)
	public List<ObjectNode> getDataByInst(@RequestParam(value="instId", required=true) String instId) throws Exception;

    @RequestMapping(value = "/runtime/instance/v1/isSynchronize", method = RequestMethod.GET)
    public Boolean isSynchronize(@RequestParam(value="instId", required=true) String instId,@RequestParam(value="nodeIds", required=true) String nodeIds,
                                 @RequestParam(value="status", required=true) String status,@RequestParam(value="lastStatus", required=true) String lastStatus,
                                 @RequestParam(value="lastNodeIds", required=true) String lastNodeIds) throws Exception;

    @RequestMapping(value = "/runtime/instance/v1/getFlowFieldList", method = RequestMethod.POST)
	public List<Map<String,Object>> getFlowFieldList(@RequestBody QueryFilter queryFilter) throws Exception;

    @RequestMapping(value="/runtime/instance/v1/getSubDataSqlByFk",method=RequestMethod.POST)
    public CommonResult<String> getSubDataSqlByFk(@RequestBody(required=true) ObjectNode boEnt,
												  @RequestParam(value="fkValue", required=true) Object fkValue,
												  @RequestParam(value="defId", required=false) String defId,
												  @RequestParam(value="nodeId", required=false) String nodeId,
												  @RequestParam(value="parentDefKey", required=false) String parentDefKey) ;

	@RequestMapping(value = "/bpm/bpmAutoStartConf/v1/defAutoStart", method = RequestMethod.GET)
	public ObjectNode defAutoStart() throws Exception;

	//获取节点表单
	@RequestMapping(value="/runtime/instance/v1/printBoAndFormKey",method=RequestMethod.GET)
	public ObjectNode printBoAndFormKey(@RequestParam(value="defId", required=false) String defId,
								 @RequestParam(value="nodeId", required=false) String nodeId,
								 @RequestParam(value="procInstId", required=false) String procInstId) throws Exception;
	
	@RequestMapping(value="/bpm/boDataModifyRecord/v1/handleBoDateModify",method=RequestMethod.POST)
	public CommonResult<String> handleBoDateModify(@RequestBody Map<String, Object> params) throws Exception;
	
	@RequestMapping(value = "/bpm/boDataModifyRecord/v1/getJson", method = RequestMethod.GET)
	public ObjectNode getModifyById(@RequestParam(value="id", required=true) String id) throws Exception;
	
	@RequestMapping(value = "/runtime/task/v1/getTaskListByTenantId", method = RequestMethod.GET)
	public List<ObjectNode> getTaskListByTenantId(@RequestParam(value="tenantId", required=true) String tenantId);
	
	@RequestMapping(value="/runtime/bpmPrintRecord/v1/printLog",method=RequestMethod.POST)
    public CommonResult<String> addPrintLog(@RequestBody(required=true) ObjectNode printLogObject) ;
	
	@RequestMapping(value="/runtime/script/v1/executeScript",method=RequestMethod.POST)
    public CommonResult<String> executeScript(@RequestBody(required=true) String script) ;
	
	@RequestMapping(value = "/runtime/instance/v1//getFormAndBO", method = RequestMethod.POST)
	public ObjectNode getFormAndBO(@RequestBody(required=true) ObjectNode objectNode);


	@RequestMapping(value = "/runtime/instance/v1/getFlowInfo", method = RequestMethod.POST)
	public List getFlowInfo(@RequestBody(required=true) List<String> params);
	

	/**
	 * 保存草稿
	 * @param startFlowParamObject
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value = "/runtime/instance/v1/saveDraft")
	public ObjectNode saveDraft(@RequestBody ObjectNode startFlowParamObject) throws Exception;

	
	/**
	 * 审批流程
	 * @param doNextParamObject
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value="/runtime/task/v1/complete")
	public ObjectNode complete(@RequestBody(required=true) ObjectNode doNextParamObject) throws Exception;
	
	/**
	 * 获取用户的待办事宜
	 * @param queryFilter
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value = "/runtime/task/v1/getTodoList")
	public ObjectNode getTodoList(@RequestBody ObjectNode queryFilter) throws Exception;
	
	/**
	 * 转移任务给（用户、组织、岗位、角色）
	 * @param map
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value="/runtime/task/v1/divertBpmTask")
	public ObjectNode divertBpmTask(@RequestBody Map<String,Object> map) throws Exception;
	
	/**
	 * 任务转办
	 */
	@PostMapping(value = "/runtime/task/v1/delegate")
	public ObjectNode delegate(@RequestBody ObjectNode assignParamObject, @RequestParam(value="leaderId", required=false) String leaderId) throws Exception;
	
	/**
	 * 取消代理或转办
	 */
	@PostMapping(value = "/runtime/task/v1/doCancelTurn")
	public ObjectNode doCancelTurn(@RequestBody ObjectNode assignParamObject) throws Exception;
	
	/**
	 * 处理撤销流转任务
	 * @param withDrawParam
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value = "/runtime/task/v1/doRevokeTrans")
	public ObjectNode doRevokeTrans(@RequestBody ObjectNode withDrawParam) throws Exception;
	
	/**
	 * 任务沟通
	 * @param communicateParamObject
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value = "/runtime/task/v1/communicate")
	public CommonResult<String> communicate(@RequestBody ObjectNode communicateParamObject) throws Exception;
	
	@PostMapping(value = "/runtime/task/v1/taskSignUsers")
	public CommonResult<String> taskSignUsers(@RequestBody ObjectNode signParamObject) throws Exception;
	
	@PostMapping(value = "/runtime/task/v1/setTaskExecutors")
	public CommonResult<String> setTaskExecutors( @RequestBody ObjectNode modifyExecutorsParamObject)throws Exception;
	
	/**
	 * 保存流转信息（增加流转）
	 * @param taskTransParamObject
	 * @param leaderId
	 * @return
	 * @throws Exception
	 */
	@PostMapping(value="/runtime/task/v1/taskToTrans")
	public CommonResult<String> taskToTrans(@RequestBody(required=true) ObjectNode taskTransParamObject, @RequestParam(value="leaderId", required=false) String leaderId) throws Exception;
	
	/**
	 * 普通任务加签（流转做的）
	 * @param taskTransParamObject
	 * @param leaderId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/userTaskToSign",method=RequestMethod.POST,produces = {"application/json; charset=utf-8" })
	public CommonResult<String> userTaskToSign(@RequestBody(required=true) ObjectNode taskTransParamObject,@RequestParam(value="leaderId", required=false) String leaderId) throws Exception;
	
	/**
	 * 
	 * @param taskId
	 * @param defId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/taskImage",method=RequestMethod.GET,produces = {
	"application/json; charset=utf-8" })
	@ApiOperation(value="获取查看任务流程图参数",httpMethod="GET",notes="获取查看任务流程图界面参数")
	public ObjectNode taskImage( @RequestParam(value="taskId",required = true) String taskId, @RequestParam(value="defId",required = false) String defId) throws Exception;
	
	/**
	 * 获取流程实例中指定节点的审批意见
	 * @param defId
	 * @param instId
	 * @param nodeId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/nodeOpinion",method=RequestMethod.GET,produces = {"application/json; charset=utf-8" })
	public Object nodeOpinion( @RequestParam(value="defId",required=true) String defId,@RequestParam(value="instId",required=true) String instId,@RequestParam(value="nodeId",required=true) String nodeId) throws Exception;
	
	/**
	 * @param taskId
	 * @param leaderId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/getButtonsBytaskId",method=RequestMethod.GET,produces = {
	"application/json; charset=utf-8" })
	@ApiOperation(value="根据任务ID获取审批按钮",httpMethod="GET",notes="根据任务ID获取审批按钮")
	public ObjectNode getButtonsBytaskId(@RequestParam(value="taskId",required=true) String taskId, @RequestParam(value="leaderId",required=true) String leaderId) throws Exception;

	/**
	 * 获取任务的详情
	 * @param taskId
	 * @param reqParams
	 * @param leaderId
	 * @return
	 * @throws Exception
	 */
    @RequestMapping(value="/runtime/task/v1/taskDetail",method=RequestMethod.GET,produces = {
            "application/json; charset=utf-8" })
    public ObjectNode taskDetail(@RequestParam(value="taskId",required=true)  String taskId,@RequestParam(value="reqParams",required = false) String reqParams,@RequestParam(value="leaderId",required=false) String leaderId) throws Exception;
	
    /**
     * 获取任务的详情
     * @param taskId
     * @param reqParams
     * @param leaderId
     * @return
     * @throws Exception
     */
	@RequestMapping(value="/runtime/task/v1/taskDetailBo",method=RequestMethod.GET,produces = {"application/json; charset=utf-8" })
	public ObjectNode taskDetailBo(@RequestParam(value="taskId",required=true) String taskId,@RequestParam(value="reqParams",required=true) String reqParams,@RequestParam(value="leaderId",required=false)  String leaderId) throws Exception;
	
	/**
	 * 获取手机任务的详情
	 * @param taskId
	 * @param reqParams
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/taskMobileDetail",method=RequestMethod.GET,produces = {"application/json; charset=utf-8" })
	public ObjectNode taskMobileDetail(@RequestParam(value = "taskId",required=true) String taskId, @RequestParam(value="reqParams",required=true) String reqParams) throws Exception;
	
	/**
	 * 保存 (流程启动后保存草稿)
	 * @param doNextParamObject
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/runtime/task/v1/saveDraft",method=RequestMethod.POST,produces = {"application/json; charset=utf-8" })
	public CommonResult<String> taskSaveDraft(@RequestBody ObjectNode doNextParamObject) throws Exception;

}
