package com.artfess.application.persistence.manager.impl;


import com.artfess.application.persistence.manager.ElaticsearchLogManager;
import com.artfess.es.unit.ElasticSearchApplication;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.*;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

/**
 * @program: edp
 * @Date: 2021/3/16 9:36
 * @Author: llj
 * @Description:
 */
@Service
public class ElaticsearchLogManagerImpl implements ElaticsearchLogManager {
    private static String indexName = "bpm_log";//索引名称
    @Resource
    private ElasticSearchApplication elasticSearchApplication;

    @Override
    public Map<String, Object> queryDataByQueryBuilder(Integer pageNum, Integer pageSize) {
        String name = "executionTime";
        SortOrder desc = SortOrder.DESC;//降序
        return elasticSearchApplication.queryDataByQueryBuilder(indexName, null, name, desc, pageNum, pageSize);

    }

    @Override
    public List<Map<String, Object>> queryApplicationLogById(String id) {
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("bizNo", id);
        return this.elasticSearchApplication.queryDataByQueryBuilder(indexName, termQueryBuilder);

    }

    @Override
    public Map<String, Object> queryErrorByQueryBuilder(String user, String startDate, String endDate, Integer pageNum, Integer pageSize) {
        String name = "executionTime";
        BoolQueryBuilder queryBuilder3 = QueryBuilders.boolQuery();
        queryBuilder3.must(QueryBuilders.matchQuery("logType", "错误日志"));
        if (user != null && !user.equals("")) {
            WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery("operator", "*" + user + "*");
            queryBuilder3.must(wildcardQueryBuilder);
        }
        //多条件查询
        SortOrder desc = SortOrder.DESC;//降序
        if (StringUtils.isNotBlank(startDate) && StringUtils.isNotBlank(endDate)) {
            try {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery("executionTime");
                SimpleDateFormat smf = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                rangeQueryBuilder.gte(smf.parse(startDate).getTime());
                rangeQueryBuilder.lte(smf.parse(endDate).getTime());
                queryBuilder3.must(rangeQueryBuilder);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        Map<String, Object> data = elasticSearchApplication.queryDataByQueryBuilder(indexName, queryBuilder3, name, desc, pageNum, pageSize);
//        Map<String, Object> data1 = elasticSearchApplication.queryForFullText(indexName, searchSourceBuilder, pageNum, pageSize, list, desc, heginheField);

        return data;
    }

    @Override
    public Map<String, Object> queryBusinessByQueryBuilder(String logType,String user, String startDate, String endDate, Integer pageNum, Integer pageSize) throws IOException {
        String name = "executionTime";//排序字段

//        ArrayList<String> list = new ArrayList<>();
//        list.add("createTime");

        BoolQueryBuilder queryBuilder3 = QueryBuilders.boolQuery();
//        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
//        searchSourceBuilder.query(queryBuilder3);
//        QueryBuilder queryBuilder = QueryBuilders.fuzzyQuery("bizKey", "ORDER_16");
        if (StringUtils.isNotBlank(user)) {
            //模糊查询需要在索引文档中添加分词器
            //FuzzyQueryBuilder fuzzyQueryBuilder = QueryBuilders.fuzzyQuery("operator", user);
            //queryBuilder3.must(fuzzyQueryBuilder);
            WildcardQueryBuilder wildcardQueryBuilder = QueryBuilders.wildcardQuery("operator", "*" + user + "*");
            queryBuilder3.must(wildcardQueryBuilder);
        }
        if(StringUtils.isNotBlank(logType)){
            queryBuilder3.must(QueryBuilders.matchQuery("logType", logType));
        }
        //多条件查询
        SortOrder desc = SortOrder.DESC;//降序
        if (StringUtils.isNotBlank(startDate) && StringUtils.isNotBlank(endDate)) {
            try {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery("executionTime");
                SimpleDateFormat smf = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                rangeQueryBuilder.gte(smf.parse(startDate).getTime());
                rangeQueryBuilder.lte(smf.parse(endDate).getTime());
                queryBuilder3.must(rangeQueryBuilder);
            } catch (ParseException e) {
                e.printStackTrace();
            }

        }
        Map<String, Object> data = elasticSearchApplication.queryDataByQueryBuilder(indexName, queryBuilder3, name, desc, pageNum, pageSize);
//        Map<String, Object> data1 = elasticSearchApplication.queryForFullText(indexName, searchSourceBuilder, pageNum, pageSize, list, desc, heginheField);

        return data;

    }
}
