/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.vo;

import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel(value="\u53f0\u8d26-\u9879\u76ee\u4fe1\u606f\u53f0\u8d26\u5bf9\u8c61-ProjectLedgerVo")
public class ProjectLedgerVo {
    @ApiModelProperty(value="\u9879\u76ee\u7c7b\u578b\uff08\u4f7f\u7528\u5b57\u5178\uff09")
    private Integer projectType;
    @ApiModelProperty(value="\u9879\u76ee\u540d\u79f0")
    private String projectName;
    @ApiModelProperty(value="\u9879\u76ee\u72b6\u6001\uff08\u4f7f\u7528\u5b57\u5178\uff1a1\uff1a\u51b3\u7b56\u9636\u6bb5\uff0c2\uff1a\u7acb\u9879\u9636\u6bb5\uff1a3\uff1a\u53ef\u7814\u89c4\u5212\u9636\u6bb5\uff0c4\uff1a\u521d\u6b65\u8bbe\u8ba1\u9636\u6bb5\uff0c5\uff1a\u6982\u7b97\u9636\u6bb5\uff0c6\uff1a\u65bd\u5de5\u56fe\u8bbe\u8ba1\u9636\u6bb5\uff0c7\uff1a\u73af\u8bc4\u9636\u6bb5\uff0c8\uff1a\u6c34\u4fdd\u9636\u6bb5\uff0c9\uff1a\u62db\u6295\u6807\u9636\u6bb5\uff0c10\uff1a\u65bd\u5de5\u8bb8\u53ef\u5ba1\u6279\u9636\u6bb5\uff0c11\uff1a\u65bd\u5de5\u9636\u6bb5\uff0c12\uff1a\u7ae3\u5de5\u9a8c\u6536\u9636\u6bb5\uff0c13\uff1a\u7ed3\u7b97\u9636\u6bb5\uff0c14\uff1a\u51b3\u7b97\u9636\u6bb5\uff0c15\uff1a\u5df2\u5b8c\u6210\uff09")
    private String projectStatus;
    @ApiModelProperty(value="\u9879\u76ee\u8d1f\u8d23\u4eba")
    private String projectManager;
    @ApiModelProperty(value="\u51b3\u7b56\u6587\u4ef6\u7c7b\u578b / \u51b3\u7b56\u4f9d\u636e\uff0c\u53ef\u591a\u9009\uff08\u4f7f\u7528\u5b57\u5178\uff0c1\uff1a\u515a\u59d4\u4f1a\uff0c2\uff1a\u8463\u4e8b\u4f1a\uff0c3\uff1a\u603b\u7ecf\u7406\u529e\u516c\u4f1a\uff0c4\uff1a\u8bf7\u793a\uff0c5\uff1a\u4e2d\u6807\u901a\u77e5\u4e66\uff0c6\uff1a\u5176\u4ed6\uff09")
    private String decisionBasisType;
    @ApiModelProperty(value="\u8d23\u4efb\u5355\u4f4d")
    private String responsibleUnit;
    @ApiModelProperty(value="\u5730\u52d8\u5355\u4f4d")
    private String geologicalProspectingUnit;
    @ApiModelProperty(value="\u8bbe\u8ba1\u5355\u4f4d")
    private String designUnit;
    @ApiModelProperty(value="\u76d1\u7406\u5355\u4f4d")
    private String supervisorUnit;
    @ApiModelProperty(value="\u65bd\u5de5\u5355\u4f4d")
    private String constructUnit;
    @ApiModelProperty(value="\u5408\u540c\u91d1\u989d")
    @BigDecimalFormat
    private BigDecimal contractAmount;
    @ApiModelProperty(value="\u62db\u6807\u65b9\u5f0f/\u53d1\u5305\u65b9\u5f0f\uff0c\uff08\u4f7f\u7528\u5b57\u5178\uff1a1\uff1a\u516c\u5f00\u62db\u6807\uff0c2\uff1a\u76f4\u63a5\u59d4\u6258\uff0c3\uff1a\u8d70\u6d41\u7a0b\uff0c4\u5176\u4ed6\uff09")
    private String biddingChargeType;
    @ApiModelProperty(value="\u5efa\u8bbe\u5730\u5740")
    private String projectAddress;
    @ApiModelProperty(value="\u9879\u76ee\u89c4\u6a21\u53ca\u5185\u5bb9")
    private String projectContent;
    @ApiModelProperty(value="\u5f00\u5de5\u65f6\u95f4")
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date commencementTime;
    @ApiModelProperty(value="\u5b8c\u5de5\u65f6\u95f4")
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date completionTime;
    @ApiModelProperty(value="\u9879\u76ee\u91d1\u989d(\u4e07\u5143)/\u603b\u6295\u8d44")
    private String projectMoney;

    public static ProjectLedgerVo convertVo(ProjectManagement data, ProjectLedgerVo tran, List<DictModel> dType, List<DictModel> chargeType, List<DictModel> pStatus) {
        ProjectLedgerVo temp = new ProjectLedgerVo();
        temp.setProjectType(Integer.valueOf(data.getProjectType()));
        temp.setProjectName(data.getProjectName());
        temp.setProjectStatus(BizUtils.getDicValueByCode(pStatus, data.getProjectStatus()));
        temp.setProjectManager(data.getProjectManager());
        temp.setResponsibleUnit(data.getOwnerUnit());
        temp.setGeologicalProspectingUnit(data.getGeologicalProspectingUnit());
        temp.setDesignUnit(data.getDesignUnit());
        temp.setSupervisorUnit(data.getSupervisorUnit());
        temp.setConstructUnit(data.getConstructUnit());
        temp.setContractAmount(null != tran.getContractAmount() ? tran.getContractAmount() : BigDecimal.ZERO);
        temp.setProjectAddress(null != tran.getProjectAddress() ? tran.getProjectAddress() : "");
        temp.setProjectContent(null != tran.getProjectContent() ? tran.getProjectContent() : "");
        temp.setCommencementTime(data.getCommencementTime());
        temp.setCompletionTime(data.getCompletionTime());
        temp.setProjectMoney(null != data.getProjectMoney() ? data.getProjectMoney().stripTrailingZeros().toPlainString() : "0");
        temp.setDecisionBasisType(BizUtils.getDicValueByCode(chargeType, tran.getDecisionBasisType()));
        temp.setBiddingChargeType(BizUtils.getDicValueByCode(dType, tran.getBiddingChargeType()));
        return temp;
    }

    public String toString() {
        return "ProjectLedgerVo{projectType=" + this.projectType + ", projectName='" + this.projectName + '\'' + ", projectStatus='" + this.projectStatus + '\'' + ", projectManager='" + this.projectManager + '\'' + ", decisionBasisType='" + this.decisionBasisType + '\'' + ", responsibleUnit='" + this.responsibleUnit + '\'' + ", geologicalProspectingUnit='" + this.geologicalProspectingUnit + '\'' + ", designUnit='" + this.designUnit + '\'' + ", supervisorUnit='" + this.supervisorUnit + '\'' + ", constructUnit='" + this.constructUnit + '\'' + ", contractAmount=" + this.contractAmount + ", biddingChargeType=" + this.biddingChargeType + ", projectAddress='" + this.projectAddress + '\'' + ", projectContent='" + this.projectContent + '\'' + ", commencementTime=" + this.commencementTime + ", completionTime=" + this.completionTime + ", projectMoney='" + this.projectMoney + '\'' + '}';
    }

    public Integer getProjectType() {
        return this.projectType;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectStatus() {
        return this.projectStatus;
    }

    public String getProjectManager() {
        return this.projectManager;
    }

    public String getDecisionBasisType() {
        return this.decisionBasisType;
    }

    public String getResponsibleUnit() {
        return this.responsibleUnit;
    }

    public String getGeologicalProspectingUnit() {
        return this.geologicalProspectingUnit;
    }

    public String getDesignUnit() {
        return this.designUnit;
    }

    public String getSupervisorUnit() {
        return this.supervisorUnit;
    }

    public String getConstructUnit() {
        return this.constructUnit;
    }

    public BigDecimal getContractAmount() {
        return this.contractAmount;
    }

    public String getBiddingChargeType() {
        return this.biddingChargeType;
    }

    public String getProjectAddress() {
        return this.projectAddress;
    }

    public String getProjectContent() {
        return this.projectContent;
    }

    public Date getCommencementTime() {
        return this.commencementTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public String getProjectMoney() {
        return this.projectMoney;
    }

    public void setProjectType(Integer projectType) {
        this.projectType = projectType;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }

    public void setDecisionBasisType(String decisionBasisType) {
        this.decisionBasisType = decisionBasisType;
    }

    public void setResponsibleUnit(String responsibleUnit) {
        this.responsibleUnit = responsibleUnit;
    }

    public void setGeologicalProspectingUnit(String geologicalProspectingUnit) {
        this.geologicalProspectingUnit = geologicalProspectingUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }

    public void setSupervisorUnit(String supervisorUnit) {
        this.supervisorUnit = supervisorUnit;
    }

    public void setConstructUnit(String constructUnit) {
        this.constructUnit = constructUnit;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public void setBiddingChargeType(String biddingChargeType) {
        this.biddingChargeType = biddingChargeType;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public void setProjectContent(String projectContent) {
        this.projectContent = projectContent;
    }

    public void setCommencementTime(Date commencementTime) {
        this.commencementTime = commencementTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public void setProjectMoney(String projectMoney) {
        this.projectMoney = projectMoney;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectLedgerVo)) {
            return false;
        }
        ProjectLedgerVo other = (ProjectLedgerVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$projectType = this.getProjectType();
        Integer other$projectType = other.getProjectType();
        if (this$projectType == null ? other$projectType != null : !((Object)this$projectType).equals(other$projectType)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$projectStatus = this.getProjectStatus();
        String other$projectStatus = other.getProjectStatus();
        if (this$projectStatus == null ? other$projectStatus != null : !this$projectStatus.equals(other$projectStatus)) {
            return false;
        }
        String this$projectManager = this.getProjectManager();
        String other$projectManager = other.getProjectManager();
        if (this$projectManager == null ? other$projectManager != null : !this$projectManager.equals(other$projectManager)) {
            return false;
        }
        String this$decisionBasisType = this.getDecisionBasisType();
        String other$decisionBasisType = other.getDecisionBasisType();
        if (this$decisionBasisType == null ? other$decisionBasisType != null : !this$decisionBasisType.equals(other$decisionBasisType)) {
            return false;
        }
        String this$responsibleUnit = this.getResponsibleUnit();
        String other$responsibleUnit = other.getResponsibleUnit();
        if (this$responsibleUnit == null ? other$responsibleUnit != null : !this$responsibleUnit.equals(other$responsibleUnit)) {
            return false;
        }
        String this$geologicalProspectingUnit = this.getGeologicalProspectingUnit();
        String other$geologicalProspectingUnit = other.getGeologicalProspectingUnit();
        if (this$geologicalProspectingUnit == null ? other$geologicalProspectingUnit != null : !this$geologicalProspectingUnit.equals(other$geologicalProspectingUnit)) {
            return false;
        }
        String this$designUnit = this.getDesignUnit();
        String other$designUnit = other.getDesignUnit();
        if (this$designUnit == null ? other$designUnit != null : !this$designUnit.equals(other$designUnit)) {
            return false;
        }
        String this$supervisorUnit = this.getSupervisorUnit();
        String other$supervisorUnit = other.getSupervisorUnit();
        if (this$supervisorUnit == null ? other$supervisorUnit != null : !this$supervisorUnit.equals(other$supervisorUnit)) {
            return false;
        }
        String this$constructUnit = this.getConstructUnit();
        String other$constructUnit = other.getConstructUnit();
        if (this$constructUnit == null ? other$constructUnit != null : !this$constructUnit.equals(other$constructUnit)) {
            return false;
        }
        BigDecimal this$contractAmount = this.getContractAmount();
        BigDecimal other$contractAmount = other.getContractAmount();
        if (this$contractAmount == null ? other$contractAmount != null : !((Object)this$contractAmount).equals(other$contractAmount)) {
            return false;
        }
        String this$biddingChargeType = this.getBiddingChargeType();
        String other$biddingChargeType = other.getBiddingChargeType();
        if (this$biddingChargeType == null ? other$biddingChargeType != null : !this$biddingChargeType.equals(other$biddingChargeType)) {
            return false;
        }
        String this$projectAddress = this.getProjectAddress();
        String other$projectAddress = other.getProjectAddress();
        if (this$projectAddress == null ? other$projectAddress != null : !this$projectAddress.equals(other$projectAddress)) {
            return false;
        }
        String this$projectContent = this.getProjectContent();
        String other$projectContent = other.getProjectContent();
        if (this$projectContent == null ? other$projectContent != null : !this$projectContent.equals(other$projectContent)) {
            return false;
        }
        Date this$commencementTime = this.getCommencementTime();
        Date other$commencementTime = other.getCommencementTime();
        if (this$commencementTime == null ? other$commencementTime != null : !((Object)this$commencementTime).equals(other$commencementTime)) {
            return false;
        }
        Date this$completionTime = this.getCompletionTime();
        Date other$completionTime = other.getCompletionTime();
        if (this$completionTime == null ? other$completionTime != null : !((Object)this$completionTime).equals(other$completionTime)) {
            return false;
        }
        String this$projectMoney = this.getProjectMoney();
        String other$projectMoney = other.getProjectMoney();
        return !(this$projectMoney == null ? other$projectMoney != null : !this$projectMoney.equals(other$projectMoney));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectLedgerVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $projectType = this.getProjectType();
        result = result * 59 + ($projectType == null ? 43 : ((Object)$projectType).hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $projectStatus = this.getProjectStatus();
        result = result * 59 + ($projectStatus == null ? 43 : $projectStatus.hashCode());
        String $projectManager = this.getProjectManager();
        result = result * 59 + ($projectManager == null ? 43 : $projectManager.hashCode());
        String $decisionBasisType = this.getDecisionBasisType();
        result = result * 59 + ($decisionBasisType == null ? 43 : $decisionBasisType.hashCode());
        String $responsibleUnit = this.getResponsibleUnit();
        result = result * 59 + ($responsibleUnit == null ? 43 : $responsibleUnit.hashCode());
        String $geologicalProspectingUnit = this.getGeologicalProspectingUnit();
        result = result * 59 + ($geologicalProspectingUnit == null ? 43 : $geologicalProspectingUnit.hashCode());
        String $designUnit = this.getDesignUnit();
        result = result * 59 + ($designUnit == null ? 43 : $designUnit.hashCode());
        String $supervisorUnit = this.getSupervisorUnit();
        result = result * 59 + ($supervisorUnit == null ? 43 : $supervisorUnit.hashCode());
        String $constructUnit = this.getConstructUnit();
        result = result * 59 + ($constructUnit == null ? 43 : $constructUnit.hashCode());
        BigDecimal $contractAmount = this.getContractAmount();
        result = result * 59 + ($contractAmount == null ? 43 : ((Object)$contractAmount).hashCode());
        String $biddingChargeType = this.getBiddingChargeType();
        result = result * 59 + ($biddingChargeType == null ? 43 : $biddingChargeType.hashCode());
        String $projectAddress = this.getProjectAddress();
        result = result * 59 + ($projectAddress == null ? 43 : $projectAddress.hashCode());
        String $projectContent = this.getProjectContent();
        result = result * 59 + ($projectContent == null ? 43 : $projectContent.hashCode());
        Date $commencementTime = this.getCommencementTime();
        result = result * 59 + ($commencementTime == null ? 43 : ((Object)$commencementTime).hashCode());
        Date $completionTime = this.getCompletionTime();
        result = result * 59 + ($completionTime == null ? 43 : ((Object)$completionTime).hashCode());
        String $projectMoney = this.getProjectMoney();
        result = result * 59 + ($projectMoney == null ? 43 : $projectMoney.hashCode());
        return result;
    }
}

