package com.artfess.security.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.security.dao.SecurityPersonloginlimitDao;
import com.artfess.security.manager.SecurityPersonloginlimitManager;
import com.artfess.security.model.SecurityPersonloginlimit;
import com.artfess.security.vo.PersonloginlimitVo;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 人员+设备登录限制 服务实现类
 *
 * @company 阿特菲斯
 * @author chenshi
 * @email chenshi@artfess.com
 * @since 2021-03-08
 */
@Service
public class SecurityPersonloginlimitManagerImpl extends BaseManagerImpl<SecurityPersonloginlimitDao, SecurityPersonloginlimit> implements SecurityPersonloginlimitManager {

    @Autowired
    UserManager userManager;

    @Resource
    SecurityPersonloginlimitDao securityPersonloginlimitDao;

    @Override
    public IPage<PersonloginlimitVo> queryPersonloginlimitPage(QueryFilter<SecurityPersonloginlimit> queryFilter) throws Exception {
        queryFilter.getParams();
        queryFilter.addFilter("MACHINE_ID_",  queryFilter.getParams().get("machineId").toString(), QueryOP.EQUAL);
        IPage<PersonloginlimitVo> pages = this.baseMapper.queryLimitByMachine(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return pages;
    }

    @Override
    @Transactional
    public CommonResult<String> insertPersonloginlimit(String machineId, String userIds) throws Exception {
        String[] idArray = userIds.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = true;
        for (String id : idArray) {
            // 去重
            QueryWrapper<SecurityPersonloginlimit> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("MACHINE_ID_", machineId).eq("USER_ID_", id);
            Integer count = this.securityPersonloginlimitDao.selectCount(queryWrapper);
            if (count > 0) {
                continue;
            }
            User user = userManager.get(id);
            if(BeanUtils.isNotEmpty(user)){
                SecurityPersonloginlimit securityPersonloginlimit =new SecurityPersonloginlimit();
                securityPersonloginlimit.setMachineId(machineId);
                securityPersonloginlimit.setAccount(user.getAccount());
                securityPersonloginlimit.setUserId(id);
                this.create(securityPersonloginlimit);
            }else{
                isTrue = false;
                msg.append("帐号【"+id+"】不存在，");
            }
        }
        return new CommonResult<String>(isTrue,BeanUtils.isEmpty(msg)?"关联成功！":msg.toString(),"");
    }

    @Override
    @Transactional
    public void deleteByMachineId(String machineId) throws Exception {
        Assert.hasText(machineId, "涉密计算机ID不能为空");
        QueryWrapper<SecurityPersonloginlimit> delWrapper = new QueryWrapper<>();
        delWrapper.eq("MACHINE_ID_", machineId);
        this.baseMapper.delete(delWrapper);
    }
}
