package com.artfess.xqxt.meeting.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 问题表2
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-11-03
 */

@Data
@TableName("biz_meeting_question")
@ApiModel(value="BizMeetingQuestion对象", description="问题表2")
public class BizMeetingQuestion extends BizNoModel<BizMeetingQuestion> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议id")
    @TableField("MEETING_ID_")
    private String meetingId;

    @ApiModelProperty(value = "投票主题id")
    @TableField("TOPIC_ID_")
    private String topicId;

    @ApiModelProperty(value = "问题")
    @TableField("QUESTION_CONTENT_")
    private String questionContent;

    @ApiModelProperty(value = "问题类型1：单选题:2：多选题")
    @TableField("QUESTION_TYPE_")
    private String questionType;

    @ApiModelProperty(value = "是否匿名投票(0：是，1：否)")
    @TableField("ANONYMOUS_")
    private Integer anonymous;

    @ApiModelProperty(value = "是否限制多选数量(0或null时不限制，1表示限制)")
    @TableField("QUESTION_LIMIT_")
    private Integer questionLimit;

    @ApiModelProperty(value = "最多选择数量")
    @TableField("QUESTION_CHOOSE_MORE_")
    private Integer questionChooseMore;

    @ApiModelProperty(value = "最少选择数量")
    @TableField("QUESTION_CHOOSE_LESS_")
    private Integer questionChooseLess;

    @ApiModelProperty(value = "固定选择数量")
    @TableField("QUESTION_CHOOSE_REGULAR_")
    private Integer questionChooseRegular;

    @ApiModelProperty("问题选项列表")
    @TableField(exist = false)
    private List<BizMeetingOption> optionList;

    @ApiModelProperty("当前用户是否投过票")
    @TableField(exist = false)
    private Boolean isVoted;


    @ApiModelProperty("已有多少人投票")
    @TableField(exist = false)
    private Integer votedNum;


    @ApiModelProperty("已有多少人投票/总数")
    @TableField(exist = false)
    private String votedNumTotal;


}
