/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.model.ExcelTemp;
import com.artfess.sysConfig.model.ExcelTempFields;
import com.artfess.sysConfig.persistence.dao.ExcelTempDao;
import com.artfess.sysConfig.persistence.manager.ExcelTempFieldsManager;
import com.artfess.sysConfig.persistence.manager.ExcelTempManager;
import com.artfess.sysConfig.vo.ExcelTempVo;
import com.artfess.sysConfig.vo.TableFieldVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="excelTempManager")
public class ExcelTempManagerImpl
extends BaseManagerImpl<ExcelTempDao, ExcelTemp>
implements ExcelTempManager {
    @Resource
    ExcelTempDao excelTempDao;
    @Resource
    ExcelTempFieldsManager excelTempFieldsManager;
    @Value(value="${plat.database}")
    private String dataBase;
    @Value(value="${plat.db-type}")
    private String dbType;

    @Override
    public ExcelTemp getExcelTempByTempFiles(String tempFile) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TEMP_FILES", (Object)tempFile);
        return (ExcelTemp)((Object)this.getOne((Wrapper)queryWrapper));
    }

    @Override
    public ExcelTemp getExcelTempByBizCode(String bizCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"BIZ_CODE", (Object)bizCode);
        return (ExcelTemp)((Object)this.getOne((Wrapper)queryWrapper));
    }

    @Override
    @Transactional
    public void save(ExcelTempVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getExcelTemp().getId())) {
            ExcelTemp template = this.getTempByCode(vo.getExcelTemp().getBizCode(), vo.getExcelTemp().getType());
            if (template != null) {
                throw new ApplicationException("\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
            }
            this.save((Object)vo.getExcelTemp());
            List<ExcelTempFields> fields = vo.getFields();
            if (fields.size() > 0) {
                for (ExcelTempFields p : fields) {
                    p.setTempId(vo.getExcelTemp().getId());
                }
                this.excelTempFieldsManager.saveOrUpdateBatch(fields, 10);
            }
        } else {
            this.update((Model)vo.getExcelTemp());
            List<ExcelTempFields> fields = vo.getFields();
            if (vo.getFields().size() > 0) {
                for (ExcelTempFields p : fields) {
                    p.setTempId(vo.getExcelTemp().getId());
                }
                this.excelTempFieldsManager.saveOrUpdateBatch(fields, 10);
            }
        }
    }

    @Override
    @Transactional
    public void remove(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TEMP_ID", list);
        this.excelTempFieldsManager.remove((Serializable)queryWrapper);
        this.removeByIds(list);
    }

    @Override
    public ExcelTempVo getExcelTempById(String id) {
        ExcelTempVo vo = new ExcelTempVo();
        vo.setExcelTemp((ExcelTemp)((Object)this.getById((Serializable)((Object)id))));
        vo.setFields(this.excelTempFieldsManager.getExcelTempByeTempId(id));
        return vo;
    }

    @Override
    public ExcelTempVo getExcelTempByCode(String code, Integer type) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        ExcelTemp template = this.getTempByCode(code, type);
        if (template == null) {
            return null;
        }
        ExcelTempVo vo = new ExcelTempVo();
        vo.setFields(this.excelTempFieldsManager.getExcelTempByeTempId(template.getId()));
        vo.setExcelTemp(template);
        return vo;
    }

    public ExcelTemp getTempByCode(String code, Integer type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"biz_code", (Object)code);
        queryWrapper.eq((Object)"type", (Object)type);
        return (ExcelTemp)((Object)this.getOne((Wrapper)queryWrapper));
    }

    @Override
    public List<TableFieldVo> getDataBaseField(String databaseId, String tableSchema, String tableName) {
        if (tableSchema.isEmpty()) {
            tableSchema = this.dataBase;
        }
        if ("postgresql".equals(this.dbType)) {
            return this.excelTempDao.getPostgreSQLField(tableSchema, tableName);
        }
        if ("mysql".equals(this.dbType)) {
            return this.excelTempDao.getMySqlField(tableSchema, tableName);
        }
        return null;
    }
}

