package com.artfess.xqxt.meeting.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author 黎沐华
 * @date 2022/11/14 16:04
 */
@Data
@ApiModel(value="BizMeetingVote导出VO对象", description="会议议题投票表导出数据Vo对象")
public class VoteExpertVo {


    @Excel(name = "会议主题")
    @ApiModelProperty("会议主题")
    private String theme;

    @Excel(name = "主持人")
    @ApiModelProperty("主持人")
    private String host;

    @Excel(name = "投票主题")
    @ApiModelProperty(value = "投票主题")
    private String topicContent;

    @Excel(name = "投票说明")
    @ApiModelProperty(value = "投票说明")
    private String topicRemarks;

    @Excel(name = "问题")
    @ApiModelProperty(value = "问题")
    private String questionContent;

    @Excel(name = "问题类型")
    @ApiModelProperty(value = "问题类型1：单选题:2：多选题")
    private String questionType;

    @Excel(name = "选项")
    @ApiModelProperty(value = "选项")
    private String optionValue;

    @Excel(name = "投票用户")
    @ApiModelProperty(value = "投票用户，处理匿名")
    private String voteUser;

    @Excel(name = "会议开始时间", format = "yyyy-MM-dd HH:mm")
    @ApiModelProperty("会议开始时间")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm")
    private LocalDateTime meetingStartTime;

    @Excel(name = "会议结束时间", format = "MM-dd HH:mm")
    @ApiModelProperty("会议结束时间")
    @JsonFormat(pattern="MM-dd HH:mm")
    private LocalDateTime meetingEndTime;

}
