package com.artfess.xqxt.meeting.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.sun.media.jfxmedia.control.VideoFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 终端表
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-04
 */

@Data
@ApiModel(value = "BizTerminal对象", description = "终端表")
@TableName("biz_terminal")
public class BizTerminal extends BaseModel<BizTerminal> {

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "终端id")
    @TableField("TERMINAL_ID_")
    private String terminalId;

    @ApiModelProperty(value = "终端名称")
    @TableField("TERMINAL_NAME_")
    private String terminalName;

    @ApiModelProperty(value = "终端号码")
    @TableField("TERMINAL_NUMBER_")
    private String terminalNumber;

    @ApiModelProperty(value = "0：不在会议中； 1：在会议中")
    @TableField("IS_IN_CONF_")
    private String isInConf;

    @ApiModelProperty(value = "辅视频状态，0：关闭。1：打 开")
    @TableField("DUAL_VIDEO_STATE_")
    private String dualVideoState;

    @ApiModelProperty(value = "终端密码")
    @TableField("PASSWORD_")
    private String password;

    @ApiModelProperty(value = "0x00：H323 终端 0x01：E1 普通终端 0x02：E1 高清终端 0x03: SIP 终端 0x04：zte_sip 终端 0x05：4E1 双模 0x06: 323+tip 网真终端0x07：sip+tip 网真终端")
    @TableField("TER_TYPE_")
    private String terType;

    @ApiModelProperty(value = "0:呼叫号码 1:呼叫 IP 地址")
    @TableField("CALL_MODE_")
    private String callMode;

    @ApiModelProperty(value = "呼叫 IP 地址")
    @TableField("IP_ADDRESS_")
    private String ipAddress;

    @ApiModelProperty(value = "联系人名称")
    @TableField("CONTACT_NAME_")
    private String contactName;

    @ApiModelProperty(value = "联系电话")
    @TableField("TELEPHONE_NAME_")
    private String telephoneName;

    @ApiModelProperty(value = "邮件地址")
    @TableField("EMAIL_")
    private String email;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO")
    private String memo;

    @ApiModelProperty(value = "连接状态：connected：连接； disconnected:断开")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "视频格式")
    @TableField("VIDEO_FORMAT_")
    private String videoFormat;

    @ApiModelProperty(value = "辅视频格式")
    @TableField("DUAL_VIDEO_FORMAT_")
    private String dualVideoFormat;

    @ApiModelProperty(value = "音频")
    @TableField("AUDIO_TYPE_")
    private String audioType;

    @ApiModelProperty(value = "单位 Kkbps")
    @TableField("RATE_")
    private int rate;

    @ApiModelProperty(value = "是否哑音，true：当前哑音，会场 mac 关闭，false：非哑音，会场 mac 打开")
    @TableField("MUTE_")
    private Boolean mute;

    @ApiModelProperty(value = "是否静音 true：静音 false：非静音")
    @TableField("SILENT_")
    private Boolean silent;


    @ApiModelProperty(value = "是否声音最大端 true：声音最大端 false：非声音最大端")
    @TableField("MAX_VOLUME_")
    private Boolean maxVolume;


    @ApiModelProperty(value = "终端真实麦克状态（物理设备） on：开 false：关 unknown：未知")
    @TableField("MIC_STATE_")
    private String micState;







}
