package com.artfess.xqxt.meeting.manager.impl;

import com.artfess.xqxt.meeting.vo.MeetTimeVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import net.hasor.utils.StringUtils;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.xqxt.meeting.manager.BizTerminalManager;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.MeetingPlaceManager;
import com.artfess.xqxt.meeting.model.BizSiteParamEx;
import com.artfess.xqxt.meeting.dao.BizSiteParamExDao;
import com.artfess.xqxt.meeting.manager.BizSiteParamExManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.xqxt.meeting.model.BizTerminal;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingPlace;
import com.artfess.xqxt.meeting.vo.BizSiteParamExVO;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.net.ntp.TimeStamp;
import org.apache.ibatis.annotations.Param;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *  服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-05
 */
@Service
public class BizSiteParamExManagerImpl extends BaseManagerImpl<BizSiteParamExDao, BizSiteParamEx> implements BizSiteParamExManager {

    @Resource
    private OrgManager orgManager;
    @Resource
    private BizTerminalManager bizTerminalManager;
    @Override
    public List<BizSiteParamExVO> findByGroupId(String gruopId, String type, String name, String startTime, String endTime) throws ParseException {
        List<Org> orgList = orgManager.getByParentId(gruopId);
        List<String> ids = orgList.stream().map(Org::getId).collect(Collectors.toList());
        ids.add(gruopId);
        List<BizSiteParamExVO> listVO=new ArrayList<>();
        QueryWrapper<BizSiteParamEx> queryWrapper=new QueryWrapper<>();

        //根据排序号展示
        queryWrapper.orderByAsc("SEQUENCE");


        queryWrapper.in("group_id",ids);
        if (StringUtils.isNotEmpty(type)){
            queryWrapper.eq("type",type);
        }
        if(StringUtils.isNotEmpty(name)){
            queryWrapper.like("name",name);
        }

        if (StringUtils.isNotEmpty(startTime) && StringUtils.isNotEmpty(endTime)){
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date parseStart = dateFormat.parse(startTime);
            Date parseEnd = dateFormat.parse(endTime);

            List<BizSiteParamEx> list = this.list(queryWrapper);
//当输入的开始时间和结束时间不为空的时候,先查询所有MEETING_STATUS =2和biz_site_param_ex关联的biz_site_param_ex.id和meet中的时间段
            for (BizSiteParamEx bizSiteParamEx : list) {
                List<MeetTimeVO> time = this.baseMapper.findTime();
                List<String> getId=new ArrayList<>();
                //根据所得的id查询，当前会议室正在使用的id，如果id相同当输入时间不在这个时间段里的跳过，在在的则添加进去
                for (MeetTimeVO meetTimeVO : time) {
                    if (bizSiteParamEx.getId().equals(meetTimeVO.getId())){
                        if ((parseStart.compareTo(meetTimeVO.getEndTime())>0&&parseEnd.compareTo(meetTimeVO.getEndTime())>0)||(parseStart.compareTo(meetTimeVO.getStartTime())<0&&parseEnd.compareTo(meetTimeVO.getStartTime())<0)&&meetTimeVO.getStartTime()!=null&&meetTimeVO.getEndTime()!=null){
                            break;
                        }else {
                            getId.add(meetTimeVO.getId());
                        }
                    }
                }
                //判断id不在这个时间段范围内的值
                if (!getId.contains(bizSiteParamEx.getId())){
                    BizSiteParamExVO bizSiteParamExVO=new BizSiteParamExVO();
                    BeanUtils.copyProperties(bizSiteParamEx,bizSiteParamExVO);
                    bizSiteParamExVO.setId(bizSiteParamEx.getId());
                    if (bizSiteParamEx.getType().equals("2")){
                        BizTerminal one = bizTerminalManager.getOne(new QueryWrapper<BizTerminal>().eq("TERMINAL_ID_", bizSiteParamExVO.getTerminalId()));
                        bizSiteParamExVO.setBizTerminal(one);
                    }
                    listVO.add(bizSiteParamExVO);
                }
            }
        }else {
            List<BizSiteParamEx> list = this.list(queryWrapper);
            for (BizSiteParamEx bizSiteParamEx : list) {
                BizSiteParamExVO bizSiteParamExVO=new BizSiteParamExVO();
                BeanUtils.copyProperties(bizSiteParamEx, bizSiteParamExVO);
                bizSiteParamExVO.setId(bizSiteParamEx.getId());
                if (bizSiteParamEx.getType().equals("2")){
                    BizTerminal one = bizTerminalManager.getOne(new QueryWrapper<BizTerminal>().eq("TERMINAL_ID_", bizSiteParamExVO.getTerminalId()));
                    bizSiteParamExVO.setBizTerminal(one);
                }
                listVO.add(bizSiteParamExVO);
            }

        }

        return listVO;
    }

    @Override
    public void updateGroupBySiteId(String id, String groupId) {
        UpdateWrapper<BizSiteParamEx> updateWrapper = new UpdateWrapper();
        updateWrapper.eq("id", id).set("group_id", groupId);
        this.update(updateWrapper);
    }



    @Override
    public Integer getNextSequence(Map<String, Object> criteriaMap) {

        QueryWrapper<BizSiteParamEx> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("COALESCE(max(SEQUENCE),0) sn");
        if(criteriaMap!=null && !criteriaMap.isEmpty()){
            queryWrapper.allEq(criteriaMap);
        }
        List<Map<String,Object>> resultList =baseMapper.selectMaps(queryWrapper);
        if(resultList!=null && resultList.size()>0){
            Map<String,Object> resultMap = resultList.get(0);
            Integer result =Integer.parseInt(resultMap.get("sn").toString());
            return Integer.valueOf(result == null ? 1 : (result = Integer.valueOf(result.intValue() + 1)).intValue());
        }else{
            return 1;
        }
    }


}
