/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.manager.impl;

import cn.hutool.json.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.model.SysExternalUnite;
import com.artfess.integrate.persistence.dao.SysExternalUniteDao;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.manager.UserGroupManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.artfess.xqxt.meeting.dao.MeetingDao;
import com.artfess.xqxt.meeting.dao.MeetingPlaceDao;
import com.artfess.xqxt.meeting.dao.MeetingUserDao;
import com.artfess.xqxt.meeting.dto.MeetingDTO;
import com.artfess.xqxt.meeting.m900.bean.ConfNode;
import com.artfess.xqxt.meeting.m900.bean.ConferenceSimpleInfo;
import com.artfess.xqxt.meeting.m900.bean.ConferenceStatus;
import com.artfess.xqxt.meeting.m900.bean.Participant;
import com.artfess.xqxt.meeting.m900.bean.ParticipantStatusV2;
import com.artfess.xqxt.meeting.m900.response.CreateConferenceResponse;
import com.artfess.xqxt.meeting.m900.response.ProlongConferenceResponse;
import com.artfess.xqxt.meeting.manager.BizMeetingAccessoryManager;
import com.artfess.xqxt.meeting.manager.BizMeetingVoteManager;
import com.artfess.xqxt.meeting.manager.BizSiteParamExManager;
import com.artfess.xqxt.meeting.manager.BizTerminalManager;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.MeetingUserManager;
import com.artfess.xqxt.meeting.manager.ZTEManager;
import com.artfess.xqxt.meeting.model.BizMeetingAccessory;
import com.artfess.xqxt.meeting.model.BizMeetingTopic;
import com.artfess.xqxt.meeting.model.BizSiteParamEx;
import com.artfess.xqxt.meeting.model.BizTerminal;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingPlace;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.artfess.xqxt.meeting.utils.BizUtil;
import com.artfess.xqxt.meeting.utils.BizUtils;
import com.artfess.xqxt.meeting.utils.Sha1;
import com.artfess.xqxt.meeting.utils.SortList;
import com.artfess.xqxt.meeting.vo.BizSiteParamExVO;
import com.artfess.xqxt.meeting.vo.MeetingCountVO;
import com.artfess.xqxt.meeting.vo.MeetingVO;
import com.artfess.xqxt.meeting.vo.Sha1VO;
import com.artfess.xqxt.meeting.vo.SignInAndOutCountVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import net.hasor.db.transaction.interceptor.Transactional;
import net.hasor.utils.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class MeetingManagerImpl
extends BaseManagerImpl<MeetingDao, Meeting>
implements MeetingManager {
    private static final Logger log = LoggerFactory.getLogger(MeetingManagerImpl.class);
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    MeetingUserDao meetingUserDao;
    @Resource
    MeetingDao meetingDao;
    @Resource
    MeetingPlaceDao meetingPlaceDao;
    @Resource
    BaseContext baseContext;
    @Resource
    SysExternalUniteDao sysExternalUniteDao;
    @Resource
    UCFeignService uCFeignService;
    @Resource
    ZTEManager zteManager;
    @Resource
    BizTerminalManager bizTerminalManager;
    @Resource
    BizSiteParamExManager bizSiteParamExManager;
    @Resource
    private MeetingUserManager meetingUserManager;
    @Resource
    private BizMeetingAccessoryManager meetingAccessoryManager;
    @Resource
    private BizMeetingVoteManager bizMeetingVoteManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    private UserGroupManager userGroupManager;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private UserDao userDao;
    @Autowired
    UserGroupManager userGroupService;
    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    public void exportMeeting(String id, HttpServletResponse response) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Meeting meeting = (Meeting)((Object)this.getById((Serializable)((Object)id)));
        XSSFWorkbook workbook = new XSSFWorkbook();
        if (meeting != null) {
            String fileName = meeting.getTheme() + ".xlsx";
            QueryWrapper totalQueryWrapper = new QueryWrapper();
            totalQueryWrapper.eq((Object)"MEETING_ID_", (Object)meeting.getId());
            List users = this.meetingUserManager.list((Wrapper)totalQueryWrapper);
            if (null != users && users.size() > 0) {
                for (MeetingUser meetingUser : users) {
                    String currentDeptId = ContextUtil.getCurrentDeptId((String)meetingUser.getUserId());
                    if (StringUtil.isNotEmpty((String)currentDeptId)) {
                        meetingUser.setDeptId(currentDeptId);
                        meetingUser.setDeptName(ContextUtil.getCurrentDeptName((String)meetingUser.getUserId()));
                        continue;
                    }
                    meetingUser.setDeptId(ContextUtil.getCurrentOrgId((String)meetingUser.getUserId()));
                    meetingUser.setDeptName(ContextUtil.getCurrentOrgName((String)meetingUser.getUserId()));
                }
                SortList sortList = new SortList();
                sortList.Sort(users, "getDeptId", "asc");
            }
            int total = this.meetingUserManager.count((Wrapper)totalQueryWrapper);
            QueryWrapper signInCountQueryWrapper = new QueryWrapper();
            signInCountQueryWrapper.eq((Object)"MEETING_ID_", (Object)meeting.getId());
            signInCountQueryWrapper.eq((Object)"SIGN_IN_STATUS_", (Object)0);
            int signInCount = this.meetingUserManager.count((Wrapper)signInCountQueryWrapper);
            int unSignInCount = total - signInCount;
            XSSFSheet sheet = workbook.createSheet();
            XSSFRow row = sheet.createRow(0);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("\u89c6\u9891\u4f1a\u8bae\u57fa\u672c\u6570\u636e");
            XSSFRow row1 = sheet.createRow(1);
            XSSFCell cell1 = row1.createCell(0);
            cell1.setCellValue("\u4f1a\u8bae\u4e3b\u9898");
            XSSFCell cell2 = row1.createCell(1);
            cell2.setCellValue("\u4f1a\u8bae\u5f00\u59cb\u65f6\u95f4");
            XSSFCell cell3 = row1.createCell(2);
            cell3.setCellValue("\u7d2f\u8ba1\u4f1a\u8bae\u65f6\u957f");
            XSSFCell cell4 = row1.createCell(3);
            cell4.setCellValue("\u4f1a\u8bae\u521b\u5efa\u8005");
            XSSFCell cell5 = row1.createCell(4);
            cell5.setCellValue("\u4f1a\u8bae\u9080\u8bf7\u6210\u5458\u603b\u6570");
            XSSFCell cell6 = row1.createCell(5);
            cell6.setCellValue("\u5df2\u5165\u4f1a");
            XSSFCell cell7 = row1.createCell(6);
            cell7.setCellValue("\u672a\u5165\u4f1a");
            XSSFCell cell8 = row1.createCell(7);
            cell8.setCellValue("\u53c2\u4f1a\u6bd4\u4f8b");
            XSSFRow row2 = sheet.createRow(2);
            XSSFCell row2cell1 = row2.createCell(0);
            row2cell1.setCellValue(meeting.getTheme());
            XSSFCell row2cell2 = row2.createCell(1);
            row2cell2.setCellValue(df.format(meeting.getStartTime()));
            XSSFCell row2cell3 = row2.createCell(2);
            if (meeting.getEndTime() != null) {
                row2cell3.setCellValue(MeetingManagerImpl.getDate(meeting.getStartTime(), meeting.getEndTime()));
            } else {
                row2cell3.setCellValue(MeetingManagerImpl.getDate(meeting.getStartTime(), LocalDateTime.now()));
            }
            XSSFCell row2cell4 = row2.createCell(3);
            row2cell4.setCellValue(meeting.getCreateName());
            XSSFCell row2cell5 = row2.createCell(4);
            row2cell5.setCellValue((double)total);
            XSSFCell row2cell6 = row2.createCell(5);
            row2cell6.setCellValue((double)signInCount);
            XSSFCell row2cell7 = row2.createCell(6);
            row2cell7.setCellValue((double)unSignInCount);
            XSSFCell row2cell8 = row2.createCell(7);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            if (total == 0) {
                row2cell8.setCellValue("0.0%");
            } else {
                row2cell8.setCellValue(numberFormat.format((double)signInCount / (double)total * 100.0) + "%");
            }
            XSSFRow row4 = sheet.createRow(4);
            XSSFCell row4Cell = row4.createCell(0);
            row4Cell.setCellValue("\u53c2\u4f1a\u6570\u636e");
            XSSFRow row5 = sheet.createRow(5);
            XSSFCell row5Cell1 = row5.createCell(0);
            row5Cell1.setCellValue("\u59d3\u540d");
            XSSFCell row5Cell11 = row5.createCell(1);
            row5Cell11.setCellValue("\u79d1\u5ba4");
            XSSFCell row5Cell2 = row5.createCell(2);
            row5Cell2.setCellValue("\u53cd\u9988\u72b6\u6001");
            XSSFCell row5Cell3 = row5.createCell(3);
            row5Cell3.setCellValue("\u53cd\u9988\u7ed3\u679c");
            XSSFCell row5Cell4 = row5.createCell(4);
            row5Cell4.setCellValue("\u53cd\u9988\u65f6\u95f4");
            XSSFCell row5Cell5 = row5.createCell(5);
            row5Cell5.setCellValue("\u4f1a\u8bae\u7b7e\u5230\u72b6\u6001");
            XSSFCell row5Cell6 = row5.createCell(6);
            row5Cell6.setCellValue("\u7b7e\u5230\u65f6\u95f4");
            XSSFCell row5Cell7 = row5.createCell(7);
            row5Cell7.setCellValue("\u7b7e\u9000\u72b6\u6001");
            XSSFCell row5Cell8 = row5.createCell(8);
            row5Cell8.setCellValue("\u7b7e\u9000\u65f6\u95f4");
            XSSFCell row5Cell9 = row5.createCell(9);
            row5Cell9.setCellValue("\u7d2f\u8ba1\u53c2\u4f1a\u65f6\u957f");
            XSSFCell row5Cell10 = row5.createCell(10);
            row5Cell10.setCellValue("\u672a\u5165\u4f1a\u539f\u56e0");
            int num = 6;
            for (MeetingUser meetingUser : users) {
                XSSFRow userRow = sheet.createRow(num);
                ++num;
                XSSFCell userCell1 = userRow.createCell(0);
                userCell1.setCellValue(meetingUser.getUserName());
                XSSFCell depCell = userRow.createCell(1);
                depCell.setCellValue(meetingUser.getDeptName());
                XSSFCell userCell2 = userRow.createCell(2);
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)meetingUser.getFeedBackStatus()) && "1".equals(meetingUser.getFeedBackStatus())) {
                    userCell2.setCellValue("\u672a\u53cd\u9988");
                } else {
                    userCell2.setCellValue("\u5df2\u53cd\u9988");
                }
                XSSFCell userCell3 = userRow.createCell(3);
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)meetingUser.getFeedBack())) {
                    String feedBack;
                    switch (meetingUser.getFeedBack()) {
                        case "1": {
                            feedBack = "\u51c6\u65f6\u53c2\u52a0\u4f1a\u8bae";
                            break;
                        }
                        case "2": {
                            feedBack = "\u63a8\u8fdf\u53c2\u52a0\u4f1a\u8bae";
                            break;
                        }
                        case "3": {
                            feedBack = "\u4e0d\u80fd\u53c2\u52a0\u4f1a\u8bae";
                            break;
                        }
                        case "4": {
                            feedBack = "\u59d4\u6258\u4ed6\u4eba\u53c2\u4f1a";
                            break;
                        }
                        default: {
                            feedBack = "";
                        }
                    }
                    userCell3.setCellValue(feedBack);
                } else {
                    userCell3.setCellValue("");
                }
                XSSFCell userCell4 = userRow.createCell(4);
                if (meetingUser.getFeedBackDate() != null) {
                    userCell4.setCellValue(df.format(meetingUser.getFeedBackDate()));
                }
                XSSFCell userCell5 = userRow.createCell(5);
                if (meetingUser.getSignInStatus() == 1) {
                    userCell5.setCellValue("\u672a\u7b7e\u5230");
                } else {
                    userCell5.setCellValue("\u5df2\u7b7e\u5230");
                }
                XSSFCell userCell6 = userRow.createCell(6);
                if (meetingUser.getFirstMembershipDate() != null) {
                    userCell6.setCellValue(df.format(meetingUser.getFirstMembershipDate()));
                }
                XSSFCell userCell7 = userRow.createCell(7);
                if (meetingUser.getSignOutStatus() == 1) {
                    userCell7.setCellValue("\u672a\u7b7e\u9000");
                } else {
                    userCell7.setCellValue("\u5df2\u7b7e\u9000");
                }
                XSSFCell userCell8 = userRow.createCell(8);
                if (meetingUser.getLastExitDate() != null) {
                    userCell8.setCellValue(df.format(meetingUser.getLastExitDate()));
                }
                XSSFCell userCell9 = userRow.createCell(9);
                if (meetingUser.getFirstMembershipDate() == null && meetingUser.getLastExitDate() == null) {
                    userCell9.setCellValue("00:00:00");
                }
                if (meetingUser.getFirstMembershipDate() != null) {
                    LocalDateTime endTime = meetingUser.getLastExitDate() == null ? LocalDateTime.now() : meetingUser.getLastExitDate();
                    userCell9.setCellValue(MeetingManagerImpl.getDate(meetingUser.getFirstMembershipDate(), endTime));
                }
                XSSFCell userCell10 = userRow.createCell(10);
                userCell10.setCellValue(meetingUser.getNotJoiningReasons());
            }
        }
        try {
            ExcelUtil.downloadExcel((Workbook)workbook, (String)(meeting.getTheme() + ".xlsx"), (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff01");
        }
    }

    public static String getDate(LocalDateTime startTime, LocalDateTime endTime) {
        long nowSecond = startTime.toEpochSecond(ZoneOffset.ofHours(0));
        long endSecond = endTime.toEpochSecond(ZoneOffset.ofHours(0));
        long absSeconds = Math.abs(nowSecond - endSecond);
        long s = absSeconds % 60L;
        String second = String.valueOf(s);
        long m = absSeconds / 60L % 60L;
        String minute = String.valueOf(m);
        long h = absSeconds / 60L / 60L;
        String hour = String.valueOf(h);
        second = second.length() == 1 ? "0" + second : second;
        minute = minute.length() == 1 ? "0" + minute : minute;
        hour = hour.length() == 1 ? "0" + hour : hour;
        return hour + ":" + minute + ":" + second;
    }

    @Override
    public List<MeetingUser> signInUserList(String meetingId, Integer type) {
        List list;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        if (type != 3) {
            queryWrapper.eq((Object)"SIGN_IN_STATUS_", (Object)type);
        }
        if (null != (list = this.meetingUserManager.list((Wrapper)queryWrapper)) && list.size() > 0) {
            for (MeetingUser meetingUser : list) {
                if (!StringUtil.isNotEmpty((String)meetingUser.getUserId())) continue;
                if (StringUtil.isNotEmpty((String)ContextUtil.getCurrentDeptId((String)meetingUser.getUserId()))) {
                    meetingUser.setDeptId(ContextUtil.getCurrentDeptId((String)meetingUser.getUserId()));
                    meetingUser.setDeptName(ContextUtil.getCurrentDeptName((String)meetingUser.getUserId()));
                    continue;
                }
                meetingUser.setDeptId(ContextUtil.getCurrentOrgId((String)meetingUser.getUserId()));
                meetingUser.setDeptName(ContextUtil.getCurrentOrgName((String)meetingUser.getUserId()));
            }
            SortList sortList = new SortList();
            sortList.Sort(list, "getDeptId", "asc");
        }
        return list;
    }

    @Override
    public List<MeetingUser> signOutUserList(String meetingId, Integer type) {
        List list;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        if (type != 3) {
            queryWrapper.eq((Object)"SIGN_OUT_STATUS_", (Object)type);
        }
        if (null != (list = this.meetingUserManager.list((Wrapper)queryWrapper)) && list.size() > 0) {
            for (MeetingUser meetingUser : list) {
                if (!StringUtil.isNotEmpty((String)meetingUser.getUserId())) continue;
                if (StringUtil.isNotEmpty((String)ContextUtil.getCurrentDeptId((String)meetingUser.getUserId()))) {
                    meetingUser.setDeptId(ContextUtil.getCurrentDeptId((String)meetingUser.getUserId()));
                    meetingUser.setDeptName(ContextUtil.getCurrentDeptName((String)meetingUser.getUserId()));
                    continue;
                }
                meetingUser.setDeptId(ContextUtil.getCurrentOrgId((String)meetingUser.getUserId()));
                meetingUser.setDeptName(ContextUtil.getCurrentOrgName((String)meetingUser.getUserId()));
            }
            SortList sortList = new SortList();
            sortList.Sort(list, "getDeptId", "asc");
        }
        return list;
    }

    @Override
    public SignInAndOutCountVo signInAndOutCount(String meetingId) {
        SignInAndOutCountVo signInAndOutCountVo = new SignInAndOutCountVo();
        QueryWrapper totalQueryWrapper = new QueryWrapper();
        totalQueryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        int total = this.meetingUserManager.count((Wrapper)totalQueryWrapper);
        QueryWrapper signInCountQueryWrapper = new QueryWrapper();
        signInCountQueryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        signInCountQueryWrapper.eq((Object)"SIGN_IN_STATUS_", (Object)0);
        int signInCount = this.meetingUserManager.count((Wrapper)signInCountQueryWrapper);
        int unSignInCount = total - signInCount;
        QueryWrapper signOuntCountQueryWrapper = new QueryWrapper();
        signOuntCountQueryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        signOuntCountQueryWrapper.eq((Object)"SIGN_OUT_STATUS_", (Object)0);
        int signOuntCount = this.meetingUserManager.count((Wrapper)signOuntCountQueryWrapper);
        int unSignOunt = total - signOuntCount;
        signInAndOutCountVo.setTotal(total);
        signInAndOutCountVo.setSignInCount(signInCount);
        signInAndOutCountVo.setUnSignInCount(unSignInCount);
        signInAndOutCountVo.setSignOunt(signOuntCount);
        signInAndOutCountVo.setUnSignOunt(unSignOunt);
        return signInAndOutCountVo;
    }

    @Override
    public MeetingUser getMeetingUserByMeetingIdAndUserId(String meetingId, String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        queryWrapper.eq((Object)"USER_ID_", (Object)userId);
        List list = this.meetingUserManager.list((Wrapper)queryWrapper);
        if (null == list || list.size() == 0) {
            return null;
        }
        for (MeetingUser meetingUser : list) {
            if (!StringUtil.isNotEmpty((String)meetingUser.getUserId())) continue;
            if (StringUtil.isNotEmpty((String)ContextUtil.getCurrentDeptId((String)meetingUser.getUserId()))) {
                meetingUser.setDeptId(ContextUtil.getCurrentDeptId((String)meetingUser.getUserId()));
                meetingUser.setDeptName(ContextUtil.getCurrentDeptName((String)meetingUser.getUserId()));
                continue;
            }
            meetingUser.setDeptId(ContextUtil.getCurrentOrgId((String)meetingUser.getUserId()));
            meetingUser.setDeptName(ContextUtil.getCurrentOrgName((String)meetingUser.getUserId()));
        }
        SortList sortList = new SortList();
        sortList.Sort(list, "getDeptId", "asc");
        return (MeetingUser)((Object)list.get(0));
    }

    @Override
    public List<BizSiteParamExVO> getSiteListByMeetingId(String meetingId) {
        List<MeetingPlace> placeNameList = this.meetingDao.findPlaceName(meetingId);
        if (null != placeNameList) {
            ArrayList<BizSiteParamExVO> siteParamExList = new ArrayList<BizSiteParamExVO>(placeNameList.size());
            int i = 0;
            for (MeetingPlace meetingPlace : placeNameList) {
                BizSiteParamExVO vo = new BizSiteParamExVO();
                BeanUtils.copyProperties((Object)((Object)meetingPlace), (Object)vo);
                vo.setName(meetingPlace.getPlaceName());
                vo.setAlias(meetingPlace.getPlaceName());
                vo.setTerminalId(meetingPlace.getTerminalId());
                BizTerminal terminal = new BizTerminal();
                BeanUtils.copyProperties((Object)((Object)meetingPlace), (Object)((Object)terminal));
                terminal.setId(meetingPlace.getTerminalId());
                terminal.setTerminalName(meetingPlace.getPlaceName());
                terminal.setTerminalId(meetingPlace.getTerminalId());
                terminal.setIpAddress(meetingPlace.getIpAddress());
                vo.setTerType("\u666e\u901a\u7ec8\u7aef");
                if (i % 2 == 0) {
                    terminal.setStatus("connected");
                    vo.setStatus("connected");
                    vo.setMute(true);
                    vo.setMaxVolume(true);
                    vo.setSilent(true);
                } else {
                    terminal.setStatus("disconnected");
                    vo.setStatus("disconnected");
                    vo.setMute(false);
                    vo.setMaxVolume(false);
                    vo.setSilent(false);
                }
                vo.setBizTerminal(terminal);
                siteParamExList.add(vo);
                ++i;
            }
            return siteParamExList;
        }
        return null;
    }

    @Override
    @Transactional
    public Integer updateMeetingUser(MeetingUser meetingUser) {
        return this.meetingUserDao.updateById((Object)meetingUser);
    }

    @Override
    public Integer signIn(String meetingId, String userId) {
        Meeting meeting = (Meeting)((Object)this.meetingDao.selectById((Serializable)((Object)meetingId)));
        if (null != meeting) {
            LocalDateTime startTime = meeting.getStartTime();
            LocalDateTime endTime = meeting.getEndTime();
            if (null != startTime) {
                LocalDateTime now = LocalDateTime.now();
                Duration duration = Duration.between(now, startTime);
                long minutes = duration.toMinutes();
                if (minutes > 30L) {
                    throw new BaseException("\u7b7e\u5230\u5931\u8d25\uff0c\u4f1a\u8bae\u5f00\u59cb\u524d30\u5206\u949f\u624d\u5141\u8bb8\u7b7e\u5230\uff01");
                }
                if (null != endTime && now.isAfter(endTime)) {
                    throw new BaseException("\u7b7e\u5230\u5931\u8d25\uff0c\u4f1a\u8bae\u5df2\u7ed3\u675f\uff01");
                }
                if (minutes < -6L) {
                    throw new BaseException("\u7b7e\u5230\u5931\u8d25\uff0c\u4f1a\u8bae\u5f00\u59cb\u540e\u7981\u6b62\u7b7e\u5230\uff01");
                }
            }
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"MEETING_ID_", (Object)meetingId)).eq((Object)"USER_ID_", (Object)userId);
        ((UpdateWrapper)updateWrapper.set((Object)"SIGN_IN_STATUS_", (Object)0)).set((Object)"FIRST_MEMBERSHIP_DATE_", (Object)LocalDateTime.now());
        this.meetingUserManager.update((Wrapper)updateWrapper);
        return 1;
    }

    @Override
    public Integer disSignIn(String meetingId, String userId) {
        return this.meetingUserDao.updateInStatus(1, meetingId, userId);
    }

    @Override
    public Integer signOut(String meetingId, String userId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"MEETING_ID_", (Object)meetingId)).eq((Object)"USER_ID_", (Object)userId);
        ((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"SIGN_OUT_STATUS_", (Object)0)).set((Object)"LAST_EXIT_DATE_", (Object)LocalDateTime.now())).set((Object)"SIGN_IN_TYPE_", (Object)1);
        this.meetingUserManager.update((Wrapper)updateWrapper);
        return 1;
    }

    @Override
    public Integer disSignOut(String meetingId, String userId) {
        return this.meetingUserDao.updateOutStatus(1, 1, meetingId, userId);
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            MeetingManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    @Override
    public PageList<MeetingVO> getHistory(Integer type, QueryFilter<Meeting> queryFilter) {
        if (type == 1) {
            String orgId = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
            QueryWrapper rgQueryWrapper = new QueryWrapper();
            rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
            List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
            ArrayList<Org> rtnList = new ArrayList<Org>();
            List<Org> orgList = MeetingManagerImpl.getOrgChild(allList, orgId, rtnList);
            List orgIds = orgList.stream().map(Org::getId).collect(Collectors.toList());
            if (orgIds != null && orgIds.size() > 0) {
                queryFilter.addFilter("CREATE_COMPANY_ID_", orgIds, QueryOP.IN);
            }
        }
        IPage<MeetingVO> list = this.meetingDao.selectByUserId((IPage<Meeting>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Meeting>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        for (MeetingVO meeting : list.getRecords()) {
            List<MeetingUser> users = this.findUserName(meeting.getId());
            List groups = users.stream().filter(e -> null != e.getUserGroup() && !"".equals(e.getUserGroup())).map(MeetingUser::getUserGroup).collect(Collectors.toList());
            if (null != groups && groups.size() > 0) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"CODE_", groups);
                List userGroups = this.userGroupManager.list((Wrapper)queryWrapper);
                meeting.setUserGroups(userGroups);
            }
            meeting.setUsers(users);
            meeting.setPlaces(this.findPlaceName(meeting.getId()));
        }
        list.setTotal((long)list.getRecords().size());
        return new PageList(list);
    }

    @Override
    public MeetingCountVO getMeetingCount() {
        MeetingCountVO vo = new MeetingCountVO();
        QueryFilter queryFilter = QueryFilter.build();
        PageBean pageBean = new PageBean();
        pageBean.setPage(1);
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        queryFilter.setPageBean(pageBean);
        boolean flag = false;
        List nodes = this.uCFeignService.getRoleListByAccount(this.baseContext.getCurrentUserAccout());
        for (ObjectNode objectNode : nodes) {
            if (!"sysRole".equals(objectNode.get("code").asText())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            String userId = this.baseContext.getCurrentUserId();
            List<String> userIds = this.meetingUserDao.queryMeetingIdByUserId(userId);
            if (null != userIds && userIds.size() > 0) {
                queryFilter.addFilter("CREATE_BY_", (Object)this.baseContext.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "userFilter");
                queryFilter.addFilter("ID_", userIds, QueryOP.IN, FieldRelation.OR, "userFilter");
            } else {
                queryFilter.addFilter("CREATE_BY_", (Object)this.baseContext.getCurrentUserId(), QueryOP.EQUAL);
            }
        }
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<MeetingVO> list = this.meetingDao.selectByUserId((IPage<Meeting>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Meeting>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List meetingVOS = list.getRecords();
        Integer status1 = meetingVOS.stream().filter(meetingVO -> Objects.equals(meetingVO.getMeetingStatus(), 1)).collect(Collectors.toList()).size();
        Integer status2 = meetingVOS.stream().filter(meetingVO -> Objects.equals(meetingVO.getMeetingStatus(), 2)).collect(Collectors.toList()).size();
        Integer status3 = meetingVOS.stream().filter(meetingVO -> Objects.equals(meetingVO.getMeetingStatus(), 3)).collect(Collectors.toList()).size();
        vo.setFutureCount(String.valueOf(status1));
        vo.setRunCount(String.valueOf(status2));
        vo.setFinishCount(String.valueOf(status3));
        return vo;
    }

    @Override
    public PageList<MeetingVO> findByUserId(QueryFilter<Meeting> queryFilter) {
        boolean flag = false;
        List nodes = this.uCFeignService.getRoleListByAccount(this.baseContext.getCurrentUserAccout());
        for (ObjectNode objectNode : nodes) {
            if (!"sysRole".equals(objectNode.get("code").asText())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            String userId = this.baseContext.getCurrentUserId();
            List<String> userIds = this.meetingUserDao.queryMeetingIdByUserId(userId);
            if (null != userIds && userIds.size() > 0) {
                queryFilter.addFilter("CREATE_BY_", (Object)this.baseContext.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "userFilter");
                queryFilter.addFilter("ID_", userIds, QueryOP.IN, FieldRelation.OR, "userFilter");
            } else {
                queryFilter.addFilter("CREATE_BY_", (Object)this.baseContext.getCurrentUserId(), QueryOP.EQUAL);
            }
        }
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        List sorter = queryFilter.getSorter();
        if (null == sorter || sorter.isEmpty()) {
            ArrayList<FieldSort> sorter1 = new ArrayList<FieldSort>();
            FieldSort sort1 = new FieldSort("START_TIME_", Direction.DESC);
            sorter1.add(sort1);
            queryFilter.setSorter(sorter1);
        }
        IPage<MeetingVO> list = this.meetingDao.selectByUserId((IPage<Meeting>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Meeting>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        for (MeetingVO meeting : list.getRecords()) {
            List<MeetingUser> users = this.findUserName(meeting.getId());
            List groups = users.stream().filter(e -> null != e.getUserGroup() && !"".equals(e.getUserGroup())).map(MeetingUser::getUserGroup).collect(Collectors.toList());
            if (null != groups && groups.size() > 0) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"CODE_", groups);
                List userGroups = this.userGroupManager.list((Wrapper)queryWrapper);
                meeting.setUserGroups(userGroups);
            }
            meeting.setUsers(users);
            meeting.setPlaces(this.findPlaceName(meeting.getId()));
            LocalDateTime endTime = meeting.getEndTime();
            Integer meetingStatus = meeting.getMeetingStatus();
            if (null == endTime || !LocalDateTime.now().isAfter(endTime) || meetingStatus == 3 || meetingStatus == 4) continue;
            meeting.setMeetingStatus(3);
        }
        return new PageList(list);
    }

    @Override
    public MeetingVO findById(String meetingId) throws Exception {
        User currentUser = ContextUtil.getCurrentUser();
        String userId = currentUser.getId();
        Meeting meeting = (Meeting)((Object)this.meetingDao.selectById((Serializable)((Object)meetingId)));
        if (meeting == null) {
            throw new BaseException("\u4f1a\u8bae\u4e0d\u5b58\u5728\u6216\u8005\u4f1a\u8bae\u5df2\u7ecf\u88ab\u5220\u9664\uff01");
        }
        MeetingVO vo = new MeetingVO();
        Integer meetingType = meeting.getMeetingType();
        BeanUtils.copyProperties((Object)((Object)meeting), (Object)((Object)vo));
        List<MeetingUser> users = this.findUserName(meeting.getId());
        List groups = users.stream().filter(e -> null != e.getUserGroup() && !"".equals(e.getUserGroup())).map(MeetingUser::getUserGroup).collect(Collectors.toList());
        if (null != groups && groups.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"CODE_", groups);
            List userGroups = this.userGroupManager.list((Wrapper)queryWrapper);
            vo.setUserGroups(userGroups);
        }
        vo.setUsers(users);
        vo.setPlaces(this.findPlaceName(meeting.getId()));
        vo.setId(meetingId);
        if (meetingType == 2) {
            this.zteManager.getConferenceStatus(vo);
        }
        QueryWrapper meetingUserQueryWrapper = new QueryWrapper();
        ((QueryWrapper)meetingUserQueryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId)).eq((Object)"USER_ID_", (Object)userId);
        List meetingUserList = this.meetingUserManager.list((Wrapper)meetingUserQueryWrapper);
        if (null != meetingUserList && meetingUserList.size() > 0) {
            MeetingUser meetingUser = (MeetingUser)((Object)meetingUserList.get(0));
            vo.setFeedBack(meetingUser.getFeedBack());
            vo.setFeedBackStatus(meetingUser.getFeedBackStatus());
            vo.setEstimatedArrivalDate(meetingUser.getEstimatedArrivalDate());
            vo.setEstimatedArrivalTime(meetingUser.getEstimatedArrivalTime());
            vo.setNotJoiningReasons(meetingUser.getNotJoiningReasons());
            QueryWrapper accessoryQueryWrapper = new QueryWrapper();
            accessoryQueryWrapper.in((Object)"SOURCE_ID_", new Object[]{meetingUser.getId()});
            meetingUser.setMeetingAccessoryList(this.meetingAccessoryManager.list((Wrapper)accessoryQueryWrapper));
        }
        return vo;
    }

    @Override
    @Transactional
    public void synConferenceInfo() {
        List<ConferenceStatus> conferenceInfoList = this.zteManager.getConferenceInfoList();
        if (null != conferenceInfoList && conferenceInfoList.size() > 0) {
            ArrayList meetingList = new ArrayList(conferenceInfoList.size());
            for (ConferenceStatus conferenceStatus : conferenceInfoList) {
                Meeting meeting = new Meeting();
                BeanUtils.copyProperties((Object)conferenceStatus, (Object)((Object)meeting));
                Calendar calendar = conferenceStatus.getStartTime();
                LocalDateTime startTime = LocalDateTime.ofInstant(calendar.toInstant(), ZoneId.systemDefault());
                meeting.setId(conferenceStatus.getConferenceIdentifier());
                meeting.setStartTime(startTime);
                int duration = conferenceStatus.getDuration();
                LocalDateTime endTime = startTime.plusMinutes(duration);
                meeting.setMeetingStatus(2);
                meeting.setEndTime(endTime);
                meeting.setTheme(conferenceStatus.getConferenceName());
                meeting.setContent(conferenceStatus.getConferenceName());
                meeting.setConferenceNumber(conferenceStatus.getConferenceNumber());
                meeting.setPassword(conferenceStatus.getConferencePassword());
                meeting.setIfRecord(conferenceStatus.isIfRecord());
                meeting.setRecordState(conferenceStatus.getRecordState());
                meeting.setLockState(conferenceStatus.isLockState());
                meeting.setConfCtrlMode(conferenceStatus.getConfCtrlMode());
                meeting.setBoardcaster(conferenceStatus.getBoardcaster());
                meeting.setDualBoardcaster(conferenceStatus.getDualBoardcaster());
                meeting.setChairman(conferenceStatus.getChairman());
                meeting.setIfUpMode(conferenceStatus.getIfUpMode());
                meeting.setMultiPicCtrlMode(conferenceStatus.getMultiPicCtrlMode());
                meeting.setMaxPicNum(conferenceStatus.getMaxPicNum());
                meeting.setCurPicNum(conferenceStatus.getCurPicNum());
                Meeting meeting1 = (Meeting)this.get((Serializable)((Object)meeting.getId()));
                meeting.setMeetingType(2);
                if (null != meeting1 && StringUtil.isNotEmpty((String)meeting1.getId())) {
                    BeanUtils.copyProperties((Object)((Object)meeting), (Object)((Object)meeting1));
                    meeting.setCreateBy(meeting1.getCreateBy());
                    meeting.setCreateName(meeting1.getCreateName());
                    meeting.setCreateCompanyId(meeting1.getCreateCompanyId());
                    meeting.setCreateCompanyName(meeting1.getCreateCompanyName());
                    meeting.setCreateOrgId(meeting1.getCreateOrgId());
                    meeting.setCreateOrgName(meeting1.getCreateOrgName());
                    meeting.setMeetingStatus(2);
                    this.update((Model)meeting1);
                } else {
                    meeting.setIsSend(1);
                    meeting.setRemindTime("2,3,4");
                    meeting.setCreateBy("1");
                    meeting.setCreateName("\u7ba1\u7406\u5458[\u7cfb\u7edf]");
                    this.save((Object)meeting);
                }
                List<ConfNode> confNodeList = this.zteManager.getConfNodeList(conferenceStatus.getConferenceIdentifier(), -1, -1);
                for (ConfNode confNode : confNodeList) {
                    int countPlace = this.meetingDao.countMeetingPlaceByMeetingIdAndTerminalId(conferenceStatus.getConferenceIdentifier(), confNode.getTerId());
                    if (countPlace != 0) continue;
                    QueryWrapper exQueryWrapper = new QueryWrapper();
                    exQueryWrapper.eq((Object)"TERMINAL_ID_", (Object)confNode.getTerId());
                    List bizSiteParamExes = this.bizSiteParamExManager.list((Wrapper)exQueryWrapper);
                    if (null == bizSiteParamExes || bizSiteParamExes.size() <= 0) continue;
                    BizSiteParamEx bizSiteParamEx = (BizSiteParamEx)((Object)bizSiteParamExes.get(0));
                    MeetingPlace meetingPlace = new MeetingPlace();
                    meetingPlace.setMeetingId(meeting.getId());
                    meetingPlace.setPlaceId(bizSiteParamEx.getId());
                    meetingPlace.setPlaceName(bizSiteParamEx.getName());
                    this.meetingPlaceDao.insert((Object)meetingPlace);
                }
            }
        }
    }

    @Override
    @Transactional
    public void synConferenceReserved() {
        List<ConferenceSimpleInfo> conferenceInfoList = this.zteManager.getConferenceReservedList();
        if (null != conferenceInfoList && conferenceInfoList.size() > 0) {
            ArrayList meetingList = new ArrayList(conferenceInfoList.size());
            for (ConferenceSimpleInfo conferenceStatus : conferenceInfoList) {
                Meeting meeting = new Meeting();
                BeanUtils.copyProperties((Object)conferenceStatus, (Object)((Object)meeting));
                Calendar calendar = conferenceStatus.getStartTime();
                LocalDateTime startTime = LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
                meeting.setId(conferenceStatus.getConferenceIdentifier());
                meeting.setStartTime(startTime);
                int duration = conferenceStatus.getDuration();
                LocalDateTime endTime = startTime.plusMinutes(duration);
                LocalDateTime nowTime = LocalDateTime.now();
                Duration nowDuration = Duration.between(nowTime, startTime);
                long nowMillis = nowDuration.toMillis();
                if (nowTime.isAfter(startTime) || nowTime.isEqual(meeting.getStartTime()) || nowMillis < 30000L) {
                    meeting.setMeetingStatus(2);
                } else {
                    meeting.setMeetingStatus(1);
                }
                meeting.setEndTime(endTime);
                meeting.setTheme(conferenceStatus.getConferenceName());
                meeting.setContent(conferenceStatus.getConferenceName());
                meeting.setConferenceNumber(conferenceStatus.getConferenceNumber());
                Meeting meeting1 = (Meeting)this.get((Serializable)((Object)meeting.getId()));
                meeting.setMeetingType(2);
                if (null != meeting1 && StringUtil.isNotEmpty((String)meeting1.getId())) {
                    meeting.setCreateBy(meeting1.getCreateBy());
                    meeting.setCreateName(meeting1.getCreateName());
                    meeting.setCreateCompanyId(meeting1.getCreateCompanyId());
                    meeting.setCreateCompanyName(meeting1.getCreateCompanyName());
                    meeting.setCreateOrgId(meeting1.getCreateOrgId());
                    meeting.setCreateOrgName(meeting1.getCreateOrgName());
                    BeanUtils.copyProperties((Object)((Object)meeting), (Object)((Object)meeting1));
                    this.update((Model)meeting1);
                } else {
                    meeting.setIsSend(1);
                    meeting.setRemindTime("2,3,4");
                    meeting.setCreateBy("1");
                    meeting.setCreateName("\u7ba1\u7406\u5458[\u7cfb\u7edf]");
                    this.save((Object)meeting);
                }
                List<ConfNode> confNodeList = this.zteManager.getConfNodeList(conferenceStatus.getConferenceIdentifier(), -1, -1);
                for (ConfNode confNode : confNodeList) {
                    int countPlace = this.meetingDao.countMeetingPlaceByMeetingIdAndTerminalId(conferenceStatus.getConferenceIdentifier(), confNode.getTerId());
                    if (countPlace != 0) continue;
                    QueryWrapper exQueryWrapper = new QueryWrapper();
                    exQueryWrapper.eq((Object)"TERMINAL_ID_", (Object)confNode.getTerId());
                    List bizSiteParamExes = this.bizSiteParamExManager.list((Wrapper)exQueryWrapper);
                    if (null == bizSiteParamExes || bizSiteParamExes.size() <= 0) continue;
                    BizSiteParamEx bizSiteParamEx = (BizSiteParamEx)((Object)bizSiteParamExes.get(0));
                    MeetingPlace meetingPlace = new MeetingPlace();
                    meetingPlace.setMeetingId(meeting.getId());
                    meetingPlace.setPlaceId(bizSiteParamEx.getId());
                    meetingPlace.setPlaceName(bizSiteParamEx.getName());
                    this.meetingPlaceDao.insert((Object)meetingPlace);
                }
            }
        }
    }

    @Override
    @Transactional
    public String insertMeetingVo(MeetingDTO dto) {
        try {
            dto.setConferenceNumber(this.sysIdentityManager.nextId("hybh"));
            if (dto.getMeetingType() == 2) {
                CreateConferenceResponse result = this.zteManager.sendMeeting(dto);
                if (null != result && null != result.getResult() && "200".equals(result.getResult())) {
                    dto.setId(result.getConferenceIdentifier());
                } else {
                    return result.getResult();
                }
            }
            String userName = this.baseContext.getCurrentUserName();
            if (StringUtils.isEmpty((String)dto.getTheme())) {
                dto.setTheme(userName + "\u7684\u65e0\u4e3b\u9898\u4f1a\u8bae");
            }
            Meeting meeting = new Meeting();
            BeanUtils.copyProperties((Object)dto, (Object)((Object)meeting));
            LocalDateTime nowTime = LocalDateTime.now();
            LocalDateTime startTime = meeting.getStartTime();
            Duration duration = Duration.between(nowTime, startTime);
            long minutes = duration.toMinutes();
            if (nowTime.isAfter(startTime) || nowTime.isEqual(startTime) || minutes == 0L) {
                meeting.setMeetingStatus(2);
            } else {
                meeting.setMeetingStatus(1);
            }
            meeting.setCreateBy(this.baseContext.getCurrentUserId());
            meeting.setCreateName(userName);
            meeting.setRotationStatus(1);
            int result = this.meetingDao.insert((Object)meeting);
            if (result <= 0) {
                return result + "";
            }
            List<MeetingUser> users = dto.getUsers();
            ArrayList<MeetingUser> users1 = new ArrayList<MeetingUser>();
            if (null != users && users.size() > 0) {
                for (MeetingUser user : users) {
                    if (null == user.getUserName() || "".equals(user.getUserName())) continue;
                    user.setMeetingId(meeting.getId());
                    user.setSignInStatus(1);
                    user.setSignOutStatus(1);
                    user.setSignInType(2);
                    users1.add(user);
                }
                this.meetingUserManager.saveBatch(users1);
            }
            for (MeetingPlace place : dto.getPlaces()) {
                place.setMeetingId(meeting.getId());
                this.meetingPlaceDao.insert((Object)place);
            }
            if (dto.getTopics().size() > 0) {
                for (BizMeetingTopic topic : dto.getTopics()) {
                    topic.setMeetingId(meeting.getId());
                    this.bizMeetingVoteManager.createVote(topic);
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getFiles())) {
                List<String> list = Arrays.asList(dto.getFiles().split(","));
                for (String fileId : list) {
                    BizMeetingAccessory accessory = (BizMeetingAccessory)((Object)this.meetingAccessoryManager.getById((Serializable)((Object)fileId)));
                    accessory.setSourceId(meeting.getId());
                    this.meetingAccessoryManager.updateById((Object)accessory);
                }
            }
            this.sendMsg(meeting, 1);
            this.sendMsg(meeting, 4);
            return result + "";
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return "";
        }
    }

    @Override
    @Transactional
    public int updateMeetingVo(MeetingDTO dto) {
        Meeting meeting = new Meeting();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)meeting));
        Long startTime = meeting.getStartTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        Long nowTime = new Date().getTime();
        if (nowTime >= startTime) {
            meeting.setMeetingStatus(2);
        } else {
            meeting.setMeetingStatus(1);
        }
        int result = this.meetingDao.updateById((Object)meeting);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("MEETING_ID_", meeting.getId());
        this.meetingUserDao.deleteByMap(map);
        this.meetingPlaceDao.deleteByMap(map);
        List<MeetingUser> users = dto.getUsers();
        ArrayList<MeetingUser> users1 = new ArrayList<MeetingUser>();
        if (null != users && users.size() > 0) {
            for (MeetingUser user : users) {
                if (null == user.getUserName() || "".equals(user.getUserName())) continue;
                user.setMeetingId(meeting.getId());
                user.setSignInStatus(1);
                user.setSignOutStatus(1);
                user.setSignInType(2);
                users1.add(user);
            }
            this.meetingUserManager.saveBatch(users1);
        }
        for (MeetingPlace place : dto.getPlaces()) {
            place.setMeetingId(meeting.getId());
            this.meetingPlaceDao.insert((Object)place);
        }
        this.sendMsg(meeting, 3);
        return result;
    }

    @Override
    @Transactional
    public String delayMeeting(String meetingId, int meetingType, int minutes) {
        ProlongConferenceResponse result;
        if (!(meetingType != 2 || null != (result = this.zteManager.prolongConference(meetingId, minutes)) && null != result.getResult() && "200".equals(result.getResult()))) {
            return result.getResult();
        }
        Meeting meeting = (Meeting)((Object)this.meetingDao.selectById((Serializable)((Object)meetingId)));
        LocalDateTime endTime = meeting.getEndTime();
        meeting.setEndTime(endTime.plusMinutes(minutes));
        this.update((Model)meeting);
        return "1";
    }

    List<MeetingUser> findUserName(String meetingId) {
        if (StringUtils.isEmpty((String)meetingId)) {
            return null;
        }
        return this.meetingDao.findUserName(meetingId);
    }

    List<MeetingPlace> findPlaceName(String meetingId) {
        if (StringUtils.isEmpty((String)meetingId)) {
            return null;
        }
        return this.meetingDao.findPlaceName(meetingId);
    }

    List<MeetingPlace> findPlaceNameByDeptID(String meetingId, String deptId) {
        if (StringUtils.isEmpty((String)meetingId)) {
            return null;
        }
        return this.meetingDao.findPlaceNameByDeptID(meetingId, deptId);
    }

    @Override
    public void sendMsg(Meeting meeting, Integer type) {
        List<MeetingUser> meetingUserList = this.meetingDao.findWxUserId(meeting.getId());
        if (null != meetingUserList && meetingUserList.size() > 0) {
            List userId = meetingUserList.stream().map(e -> e.getAccount()).collect(Collectors.toList());
            if (userId.size() <= 0) {
                return;
            }
            List<MeetingPlace> places = this.findPlaceName(meeting.getId());
            List<String> name = places.stream().map(d -> d.getPlaceName()).collect(Collectors.toList());
            if (1 == type) {
                this.toduSend(meeting, type, StringUtils.join((Object[])userId.toArray(), (String)"|"), name);
            } else {
                for (MeetingUser user : meetingUserList) {
                    String feedBack = user.getFeedBack();
                    if ("3".equalsIgnoreCase(feedBack) || "4".equalsIgnoreCase(feedBack)) continue;
                    String account = user.getAccount();
                    String currentDeptId = ContextUtil.getCurrentDeptIdByAccount((String)account);
                    if (StringUtils.isNotBlank((String)currentDeptId)) {
                        List<MeetingPlace> placesByDeptId = this.findPlaceNameByDeptID(meeting.getId(), currentDeptId);
                        if (null != placesByDeptId && placesByDeptId.size() > 0) {
                            List<String> placesByDeptIdList = placesByDeptId.stream().map(d -> d.getPlaceName()).collect(Collectors.toList());
                            this.toduSend(meeting, type, account, placesByDeptIdList);
                            continue;
                        }
                        this.toduSend(meeting, type, account, name);
                        continue;
                    }
                    this.toduSend(meeting, type, account, name);
                }
            }
        }
    }

    public void toduSend(Meeting meeting, Integer type, String userId, List<String> name) {
        List hylx = this.sysDictionaryManager.queryDictListItemsByCode("hylx");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd HH:mm");
        SysExternalUnite entity = this.sysExternalUniteDao.getOneByType("weChatWork");
        if (com.artfess.base.util.BeanUtils.isEmpty((Object)entity)) {
            throw new RuntimeException("\u67e5\u65e0\u6b64\u96c6\u6210\u4fe1\u606f");
        }
        if (com.artfess.base.util.BeanUtils.isEmpty((Object)((Object)meeting))) {
            return;
        }
        String meetingType = "\u73b0\u573a\u4f1a\u8bae";
        meetingType = BizUtils.getDicValueByCode((List<DictModel>)hylx, meeting.getMeetingType());
        String meetingRoom = meeting.getMeetingType() == 1 ? org.apache.commons.lang3.StringUtils.join(name, (String)",") : "\u672c\u79d1\u5ba4\u89c6\u9891\u4f1a\u8bae\u5ba4";
        JSONObject jsonStr = new JSONObject();
        switch (type) {
            case 1: {
                jsonStr.put("title", (Object)"\u4f1a\u8bae\u9884\u7ea6\u6210\u529f");
                String description = "<div class=\"gray\">\u4f1a\u8bae\u7c7b\u578b\uff1a" + meetingType + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u4e3b\u9898\uff1a" + meeting.getTheme() + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u65f6\u95f4\uff1a" + formatter.format(meeting.getStartTime()) + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5730\u70b9\uff1a" + meetingRoom + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5185\u5bb9\uff1a" + meeting.getContent() + "</div>" + "<div class=\"gray\">\u5907\u6ce8\uff1a" + (StringUtils.isNotBlank((String)meeting.getRemark()) ? meeting.getRemark() : "") + "</div>";
                jsonStr.put("description", (Object)description);
                jsonStr.put("url", (Object)("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + BizUtil.APPID + "&redirect_uri=" + BizUtil.SYSTEM_URL + "/pages/mobile/fvue/qywxOauth%3FmeetingId%3D" + meeting.getId() + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + BizUtil.AGENTID + "#wechat_redirect"));
                jsonStr.put("btntxt", (Object)"\u67e5\u770b\u8be6\u60c5");
                break;
            }
            case 2: {
                jsonStr.put("title", (Object)"\u4f1a\u8bae\u53d6\u6d88\u901a\u77e5");
                String des = "<div class=\"highlight\">\u5173\u4e8e\u3010" + meeting.getTheme() + "\u3011\u7684\u4f1a\u8bae\u5df2\u53d6\u6d88</div>" + "<div class=\"gray\">\u4f1a\u8bae\u7c7b\u578b\uff1a" + meetingType + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u4e3b\u9898\uff1a" + meeting.getTheme() + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u65f6\u95f4\uff1a" + formatter.format(meeting.getStartTime()) + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5730\u70b9\uff1a" + meetingRoom + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5185\u5bb9\uff1a" + meeting.getContent() + "</div>" + "<div class=\"gray\">\u5907\u6ce8\uff1a" + (StringUtils.isNotBlank((String)meeting.getRemark()) ? meeting.getRemark() : "") + "</div>";
                jsonStr.put("description", (Object)des);
                jsonStr.put("url", (Object)("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + BizUtil.APPID + "&redirect_uri=" + BizUtil.SYSTEM_URL + "/pages/mobile/fvue/qywxOauth%3FmeetingId%3D" + meeting.getId() + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + BizUtil.AGENTID + "#wechat_redirect"));
                jsonStr.put("btntxt", (Object)"\u67e5\u770b\u8be6\u60c5");
                break;
            }
            case 3: {
                jsonStr.put("title", (Object)"\u4f1a\u8bae\u53d8\u66f4\u901a\u77e5");
                String desc = "<div class=\"gray\">\u4f1a\u8bae\u7c7b\u578b\uff1a" + meetingType + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u4e3b\u9898\uff1a" + meeting.getTheme() + "</div>" + "<div class=\"gray\">\u53d8\u66f4\u540e\u65f6\u95f4\uff1a" + formatter.format(meeting.getStartTime()) + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5730\u70b9\uff1a" + meetingRoom + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5185\u5bb9\uff1a" + meeting.getContent() + "</div>" + "<div class=\"gray\">\u5907\u6ce8\uff1a" + (StringUtils.isNotBlank((String)meeting.getRemark()) ? meeting.getRemark() : "") + "</div>";
                jsonStr.put("description", (Object)desc);
                jsonStr.put("url", (Object)("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + BizUtil.APPID + "&redirect_uri=" + BizUtil.SYSTEM_URL + "/pages/mobile/fvue/qywxOauth%3FmeetingId%3D" + meeting.getId() + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + BizUtil.AGENTID + "#wechat_redirect"));
                jsonStr.put("btntxt", (Object)"\u67e5\u770b\u8be6\u60c5");
                break;
            }
            default: {
                jsonStr.put("title", (Object)"\u4f1a\u8bae\u901a\u77e5");
                String description1 = "<div class=\"gray\">\u4f1a\u8bae\u7c7b\u578b\uff1a" + meetingType + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u4e3b\u9898\uff1a" + meeting.getTheme() + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u65f6\u95f4\uff1a" + formatter.format(meeting.getStartTime()) + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5730\u70b9\uff1a" + meetingRoom + " </div>" + "<div class=\"gray\">\u4f1a\u8bae\u5185\u5bb9\uff1a" + meeting.getContent() + "</div>" + "<div class=\"highlight\">    \u6ce8\u610f\uff1a\u8bf7\u4e8e\u4f1a\u8bae\u5f00\u59cb\u524d10\u5206\u949f\u8fdb\u5165\u4f1a\u8bae\u5ba4\u626b\u7801\u7b7e\u5230\uff0c\u6536\u5230\u4f1a\u8bae\u901a\u77e5\u540e\u8bf7\u53ca\u65f6\u53cd\u9988\u662f\u5426\u51c6\u65f6\u53c2\u4f1a\u3002\u261b\u53ef\u70b9\u51fb\u6b64\u5904\u8fdb\u884c\u53cd\u9988\u261a </div>";
                jsonStr.put("description", (Object)description1);
                jsonStr.put("url", (Object)("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + BizUtil.APPID + "&redirect_uri=" + BizUtil.SYSTEM_URL + "/pages/mobile/fvue/qywxOauth%3FmeetingId%3D" + meeting.getId() + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + BizUtil.AGENTID + "#wechat_redirect"));
                jsonStr.put("btntxt", (Object)"\u67e5\u770b\u8be6\u60c5\u261c");
            }
        }
        try {
            String touser = userId;
            JSONObject params = new JSONObject();
            if (1 == type) {
                CommonResult result;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)meeting.getCreateBy()) && com.artfess.base.util.BeanUtils.isNotEmpty((Object)(result = this.uCFeignService.getUserById(meeting.getCreateBy())))) {
                    JsonNode userNode = (JsonNode)result.getValue();
                    String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
                    params.put("touser", (Object)account);
                }
            } else {
                params.put("touser", (Object)touser);
            }
            params.put("msgtype", (Object)"textcard");
            params.put("agentid", (Object)entity.getAgentId());
            params.put("textcard", (Object)jsonStr);
            String str = params.toString();
            String url = WeChatWorkConsts.getSendMsgUrl();
            String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)params.toString(), (String)"POST");
            JsonNode result = JsonUtil.toJsonNode((String)resultJson);
            String errcode = result.get("errcode").asText();
            log.debug(errcode);
            if ("0".equals(errcode)) {
                log.debug(touser + "\u63a8\u9001\u6d88\u606f\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u5668\u5f02\u5e38\uff0capp\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff1a" + ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    @Override
    public void toEntrustSend(Meeting meeting, String userName, String entrustId, String entrustName) {
        List hylx = this.sysDictionaryManager.queryDictListItemsByCode("hylx");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd HH:mm");
        SysExternalUnite entity = this.sysExternalUniteDao.getOneByType("weChatWork");
        if (com.artfess.base.util.BeanUtils.isEmpty((Object)entity)) {
            throw new RuntimeException("\u67e5\u65e0\u6b64\u96c6\u6210\u4fe1\u606f");
        }
        if (com.artfess.base.util.BeanUtils.isEmpty((Object)((Object)meeting))) {
            return;
        }
        String meetingType = "\u73b0\u573a\u4f1a\u8bae";
        meetingType = BizUtils.getDicValueByCode((List<DictModel>)hylx, meeting.getMeetingType());
        String meetingRoom = meeting.getMeetingType() == 1 ? org.apache.commons.lang3.StringUtils.join((Object[])new String[]{entrustName, ","}) : "\u672c\u79d1\u5ba4\u89c6\u9891\u4f1a\u8bae\u5ba4";
        JSONObject jsonStr = new JSONObject();
        jsonStr.put("title", (Object)"\u4f1a\u8bae\u9884\u7ea6\u6210\u529f");
        String description = "<div class=\"gray\">\u4f1a\u8bae\u7c7b\u578b\uff1a" + meetingType + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u4e3b\u9898\uff1a" + meeting.getTheme() + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u65f6\u95f4\uff1a" + formatter.format(meeting.getStartTime()) + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5730\u70b9\uff1a" + meetingRoom + "</div>" + "<div class=\"gray\">\u4f1a\u8bae\u5185\u5bb9\uff1a" + meeting.getContent() + "</div>" + "<div class=\"gray\">\u5907\u6ce8\uff1a\u7531" + userName + "\u59d4\u6258\u53c2\u52a0" + "</div>";
        jsonStr.put("description", (Object)description);
        jsonStr.put("url", (Object)("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + BizUtil.APPID + "&redirect_uri=" + BizUtil.SYSTEM_URL + "/pages/mobile/fvue/qywxOauth%3FmeetingId%3D" + meeting.getId() + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + BizUtil.AGENTID + "#wechat_redirect"));
        jsonStr.put("btntxt", (Object)"\u67e5\u770b\u8be6\u60c5");
        try {
            JSONObject params = new JSONObject();
            params.put("touser", (Object)entrustId);
            params.put("msgtype", (Object)"textcard");
            params.put("agentid", (Object)entity.getAgentId());
            params.put("textcard", (Object)jsonStr);
            String url = WeChatWorkConsts.getSendMsgUrl();
            String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)params.toString(), (String)"POST");
            JsonNode result = JsonUtil.toJsonNode((String)resultJson);
            String errcode = result.get("errcode").asText();
            log.debug(errcode);
            if ("0".equals(errcode)) {
                log.debug(entrustId + "\u63a8\u9001\u6d88\u606f\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u5668\u5f02\u5e38\uff0capp\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff1a" + ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
    }

    @Override
    @org.springframework.transaction.annotation.Transactional
    public String updateStatus(String id, Integer status) {
        Meeting meeting = (Meeting)((Object)this.meetingDao.selectById((Serializable)((Object)id)));
        if (null == meeting) {
            return "0";
        }
        Integer meetingType = meeting.getMeetingType();
        if (2 == meetingType) {
            String zteResult;
            if (3 == status && !"1".equals(zteResult = this.zteManager.endMeeting(id))) {
                return zteResult;
            }
            if (4 == status && !"1".equals(zteResult = this.zteManager.cancelConferenceReserved(id))) {
                return zteResult;
            }
        }
        if (4 == status) {
            this.sendMsg(meeting, 2);
        }
        this.meetingDao.updateStatus(id, status);
        return "1";
    }

    @Override
    public String updateStatusOver(Meeting meeting, Integer status) {
        if (null == meeting) {
            return "0";
        }
        Integer meetingType = meeting.getMeetingType();
        if (2 == meetingType) {
            String zteResult;
            if (3 == status && !"1".equals(zteResult = this.zteManager.endMeeting(meeting.getId()))) {
                System.out.println(String.format("\u7ed3\u675f\u4f1a\u8bae\u7ed3\u679c\uff1a%s", zteResult));
            }
            if (4 == status && !"1".equals(zteResult = this.zteManager.cancelConferenceReserved(meeting.getId()))) {
                return zteResult;
            }
        }
        if (4 == status) {
            this.sendMsg(meeting, 2);
        }
        if (3 == status) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"MEETING_ID_", (Object)meeting.getId());
            queryWrapper.eq((Object)"SIGN_IN_STATUS_", (Object)0);
            List list = this.meetingUserManager.list((Wrapper)queryWrapper);
            if (null != list && list.size() > 0) {
                for (MeetingUser user : list) {
                    user.setSignOutStatus(0);
                    user.setSignInType(2);
                    user.setLastExitDate(LocalDateTime.now());
                }
                this.meetingUserManager.saveOrUpdateBatch(list);
            }
        }
        this.meetingDao.updateStatus(meeting.getId(), status);
        return "1";
    }

    @Override
    @org.springframework.transaction.annotation.Transactional
    public String endMeeting(String id) {
        String zteResult;
        Meeting meeting = (Meeting)((Object)this.meetingDao.selectById((Serializable)((Object)id)));
        if (2 == meeting.getMeetingType() && !"1".equals(zteResult = this.zteManager.endMeeting(id))) {
            return zteResult;
        }
        meeting.setMeetingStatus(3);
        meeting.setEndTime(LocalDateTime.now());
        this.meetingDao.updateById((Object)meeting);
        return "1";
    }

    @Override
    public String quiet(String id, String placeId) {
        return this.zteManager.quiet(id, placeId, true);
    }

    @Override
    public String cancelQuiet(String id, String placeId) {
        return this.zteManager.cancelQuiet(id, placeId, true);
    }

    @Override
    public String connect(String id, String placeIds) {
        String[] placeIdsArr = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)placeIds)) {
            placeIdsArr = placeIds.split(",");
        }
        if (null != placeIdsArr && placeIdsArr.length > 0) {
            for (String placeId : placeIdsArr) {
                String[] param = new String[]{placeId};
                String result = this.zteManager.connect(id, param, false);
                if ("1".equals(result)) continue;
                return result;
            }
        }
        return "1";
    }

    @Override
    public String disconnect(String id, String placeIds) {
        String[] placeIdsArr = placeIds.split(",");
        List<String> places = Arrays.asList(placeIdsArr);
        return this.zteManager.disconnect(id, placeIdsArr);
    }

    @Override
    public ParticipantStatusV2[] participantStatusV2(String id) {
        ParticipantStatusV2[] statusV2s = this.zteManager.participantStatusV2(id);
        return statusV2s;
    }

    @Override
    public String inviteParticipant(String id, String placeIds) {
        List<String> places = Arrays.asList(placeIds.split(","));
        String result = "0";
        for (int i = 0; i < places.size(); ++i) {
            QueryWrapper bizSiteQueryWrapper = new QueryWrapper();
            bizSiteQueryWrapper.eq((Object)"TERMINAL_ID_", (Object)places.get(i));
            List bizSiteParamExList = this.bizSiteParamExManager.list((Wrapper)bizSiteQueryWrapper);
            if (null != bizSiteParamExList && bizSiteParamExList.size() > 0) {
                BizSiteParamEx bizSiteParamEx = (BizSiteParamEx)((Object)bizSiteParamExList.get(0));
                Participant participant = new Participant();
                BeanUtils.copyProperties((Object)((Object)bizSiteParamEx), (Object)participant);
                result = this.zteManager.inviteParticipant(id, participant);
            }
            QueryWrapper terminalQueryWrapper = new QueryWrapper();
            terminalQueryWrapper.eq((Object)"TERMINAL_ID_", (Object)places.get(i));
            List bizTerminalList = this.bizTerminalManager.list((Wrapper)terminalQueryWrapper);
            if (null == bizTerminalList || bizTerminalList.size() <= 0) continue;
            BizTerminal bizTerminal = (BizTerminal)((Object)bizTerminalList.get(0));
            Participant participant = new Participant();
            BeanUtils.copyProperties((Object)((Object)bizTerminal), (Object)participant);
            participant.setTerminalIdentifier(places.get(i));
            result = this.zteManager.inviteParticipant(id, participant);
        }
        return result;
    }

    @Override
    public Sha1VO getSha1(String url) {
        try {
            String ticket = null;
            if (ObjectUtils.isEmpty((Object)this.redisUtil.get("ticket"))) {
                String ticketUrl = WeChatWorkConsts.getTicketUrl();
                String resultJson = HttpUtil.sendHttpsRequest((String)ticketUrl, null, (String)"GET");
                JsonNode result = JsonUtil.toJsonNode((String)resultJson);
                String errcode = result.get("errcode").asText();
                if ("0".equals(errcode)) {
                    ticket = result.get("ticket").asText();
                    this.redisUtil.set("ticket", (Object)ticket, 3000L);
                }
            } else {
                ticket = this.redisUtil.get("ticket").toString();
            }
            String noncestr = MeetingManagerImpl.getRandomString(16);
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            String str = "jsapi_ticket=" + ticket + "&noncestr=" + noncestr + "&timestamp=" + timestamp + "&url=" + url;
            String sha1 = Sha1.encode(str);
            Sha1VO vo = new Sha1VO();
            vo.setSignature(sha1);
            vo.setTimestamp(timestamp);
            vo.setNonceStr(noncestr);
            System.out.println("*****************" + ticket);
            return vo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Sha1VO();
        }
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }
}

