/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.xqxt.meeting.dao.BizSiteParamExDao;
import com.artfess.xqxt.meeting.manager.BizSiteParamExManager;
import com.artfess.xqxt.meeting.manager.BizTerminalManager;
import com.artfess.xqxt.meeting.model.BizSiteParamEx;
import com.artfess.xqxt.meeting.model.BizTerminal;
import com.artfess.xqxt.meeting.vo.BizSiteParamExVO;
import com.artfess.xqxt.meeting.vo.MeetTimeVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.hasor.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BizSiteParamExManagerImpl
extends BaseManagerImpl<BizSiteParamExDao, BizSiteParamEx>
implements BizSiteParamExManager {
    @Resource
    private OrgManager orgManager;
    @Resource
    private BizTerminalManager bizTerminalManager;

    @Override
    public List<BizSiteParamExVO> findByGroupId(String gruopId, String type, String name, String startTime, String endTime) throws ParseException {
        List orgList = this.orgManager.getByParentId(gruopId);
        List ids = orgList.stream().map(Org::getId).collect(Collectors.toList());
        ids.add(gruopId);
        ArrayList<BizSiteParamExVO> listVO = new ArrayList<BizSiteParamExVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"group_id", ids);
        if (StringUtils.isNotEmpty((String)type)) {
            queryWrapper.eq((Object)"type", (Object)type);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            queryWrapper.like((Object)"name", (Object)name);
        }
        if (StringUtils.isNotEmpty((String)startTime) && StringUtils.isNotEmpty((String)endTime)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date parseStart = dateFormat.parse(startTime);
            Date parseEnd = dateFormat.parse(endTime);
            List list = this.list((Wrapper)queryWrapper);
            for (BizSiteParamEx bizSiteParamEx : list) {
                List<MeetTimeVO> time = ((BizSiteParamExDao)this.baseMapper).findTime();
                ArrayList<String> getId = new ArrayList<String>();
                for (MeetTimeVO meetTimeVO : time) {
                    if (!bizSiteParamEx.getId().equals(meetTimeVO.getId())) continue;
                    if (parseStart.compareTo(meetTimeVO.getEndTime()) > 0 && parseEnd.compareTo(meetTimeVO.getEndTime()) > 0 || parseStart.compareTo(meetTimeVO.getStartTime()) < 0 && parseEnd.compareTo(meetTimeVO.getStartTime()) < 0 && meetTimeVO.getStartTime() != null && meetTimeVO.getEndTime() != null) break;
                    getId.add(meetTimeVO.getId());
                }
                if (getId.contains(bizSiteParamEx.getId())) continue;
                BizSiteParamExVO bizSiteParamExVO = new BizSiteParamExVO();
                BeanUtils.copyProperties((Object)((Object)bizSiteParamEx), (Object)bizSiteParamExVO);
                bizSiteParamExVO.setId(bizSiteParamEx.getId());
                if (bizSiteParamEx.getType().equals("2")) {
                    BizTerminal one = (BizTerminal)((Object)this.bizTerminalManager.getOne((Wrapper)new QueryWrapper().eq((Object)"TERMINAL_ID_", (Object)bizSiteParamExVO.getTerminalId())));
                    bizSiteParamExVO.setBizTerminal(one);
                }
                listVO.add(bizSiteParamExVO);
            }
        } else {
            List list = this.list((Wrapper)queryWrapper);
            for (BizSiteParamEx bizSiteParamEx : list) {
                BizSiteParamExVO bizSiteParamExVO = new BizSiteParamExVO();
                BeanUtils.copyProperties((Object)((Object)bizSiteParamEx), (Object)bizSiteParamExVO);
                bizSiteParamExVO.setId(bizSiteParamEx.getId());
                if (bizSiteParamEx.getType().equals("2")) {
                    BizTerminal one = (BizTerminal)((Object)this.bizTerminalManager.getOne((Wrapper)new QueryWrapper().eq((Object)"TERMINAL_ID_", (Object)bizSiteParamExVO.getTerminalId())));
                    bizSiteParamExVO.setBizTerminal(one);
                }
                listVO.add(bizSiteParamExVO);
            }
        }
        return listVO;
    }

    @Override
    public void updateGroupBySiteId(String id, String groupId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"group_id", (Object)groupId);
        this.update((Wrapper)updateWrapper);
    }
}

