import { VueConstructor } from 'vue';
import config from './config';
import loadAmap from './load-amap';
import loadPlugins from './load-plugins';
import withAmap from './with-amap';
import Amap from './amap';
import Marker from './marker';
import LabelsLayer from './labels-layer';
import LabelMarker from './label-marker';
import Text from './text';
import Circle from './circle';
import CircleMarker from './circle-marker';
import Polygon from './polygon';
import Polyline from './polyline';
import BezierCurve from './bezier-curve';
import Rectangle from './rectangle';
import Ellipse from './ellipse';
import InfoWindow from './info-window';
import TileLayer from './tile-layer';
import SatelliteLayer from './satellite-layer';
import FlexibleLayer from './flexible-layer';
import RoadNetLayer from './road-net-layer';
import TrafficLayer from './traffic-layer';
import MapType from './map-type';
import ControlBar from './control-bar';
import HawkEye from './hawk-eye';
import Scale from './scale';
import ToolBar from './tool-bar';
import MarkerCluster from './marker-cluster';
import MouseTool from './mouse-tool';
import ImageLayer from './image-layer';
import CanvasLayer from './canvas-layer';
import CustomLayer from './custom-layer';
import DistrictLayerWorld from './district-layer-world';
import DistrictLayerCountry from './district-layer-country';
import DistrictLayerProvince from './district-layer-province';
declare const _default: {
    install(Vue: VueConstructor<import("vue").default>): void;
    config: {
        _prefix: string;
        _disableMapCache: boolean;
        verbose: boolean;
        timing: boolean;
        version: string;
        key: string;
        plugins: never[];
    };
    loadAmap: typeof loadAmap;
    loadPlugins: typeof loadPlugins;
    withAmap: import("vue/types/vue").ExtendedVue<import("vue").default, unknown, unknown, {
        $map: AMap.Map_2;
    }, Record<never, any>>;
    Amap: import("vue/types/vue").ExtendedVue<import("vue").default, {
        ready: boolean;
    }, {
        _clear(): void;
        _getContainer(visible: boolean): import("./types/amap-vue").ElementWithAMap;
    }, {
        $context: import("./types/amap-vue").MapContext;
        $map: AMap.Map_2;
    }, {
        cacheKey: string;
        center: number[];
        zoom: number;
        rotation: number;
        pitch: number;
        viewMode: string;
        features: string[];
        zooms: unknown[];
        dragEnable: boolean;
        zoomEnable: boolean;
        jogEnable: boolean;
        pitchEnable: boolean;
        rotateEnable: boolean;
        animateEnable: boolean;
        keyboardEnable: boolean;
        doubleClickZoom: boolean;
        scrollWheel: boolean;
        touchZoom: boolean;
        touchZoomCenter: boolean;
        showLabel: boolean;
        defaultCursor: string;
        isHotspot: boolean;
        mapStyle: string;
        wallColor: string;
        roofColor: string;
        skyColor: string;
        showBuildingBlock: boolean;
        showIndoorMap: boolean;
        mask: number[][] | number[][][];
    }>;
    Marker: import("vue/types/vue").ExtendedVue<{
        position: number[];
        title: string;
        offset: number[];
        anchor: "center" | "top-left" | "top-center" | "top-right" | "middle-left" | "middle-right" | "bottom-left" | "bottom-center" | "bottom-right";
        angle: number;
        topWhenClick: boolean;
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    }, unknown, unknown, unknown, {
        content: string;
        icon: string | AMap.Icon;
        label: import("./utils/types").LabelOption;
    }>;
    LabelsLayer: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, {
        ready: boolean;
    }, unknown, unknown, {
        visible: boolean;
        zIndex: number;
        opacity: number;
        collision: boolean;
        allowCollision: boolean;
    }>;
    LabelMarker: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, {
        $layerContext: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $layer: AMap.LabelsLayer;
    }, {
        name: string;
        position: number[];
        rank: number;
        icon: AMap.LabelMarkerIconOptions;
        text: AMap.LabelMarkerTextOptions;
    }>;
    Text: import("vue/types/vue").ExtendedVue<{
        position: number[];
        title: string;
        offset: number[];
        anchor: "center" | "top-left" | "top-center" | "top-right" | "middle-left" | "middle-right" | "bottom-left" | "bottom-center" | "bottom-right";
        angle: number;
        topWhenClick: boolean;
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    }, unknown, unknown, unknown, {
        text: string | import("./utils/types").LabelOption;
        domStyle: any;
    }>;
    Circle: import("vue/types/vue").ExtendedVue<{
        center: number[];
        radius: number;
    } & {
        fillColor: string;
        fillOpacity: number;
    } & {
        strokeColor: string;
        strokeOpacity: number;
        strokeWeight: number;
        strokeStyle: "solid" | "dashed";
        strokeDasharray: number[];
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        $editor: AMapEditor;
    } & {
        $editable: import("./types/editable").EditableOptions<AMapComponent, AMapEditor>;
    } & {
        editable: boolean;
    }, unknown, unknown, unknown, Record<never, any>>;
    CircleMarker: import("vue/types/vue").ExtendedVue<{
        center: number[];
        radius: number;
    } & {
        fillColor: string;
        fillOpacity: number;
    } & {
        strokeColor: string;
        strokeOpacity: number;
        strokeWeight: number;
        strokeStyle: "solid" | "dashed";
        strokeDasharray: number[];
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    }, unknown, unknown, unknown, Record<never, any>>;
    Polygon: import("vue/types/vue").ExtendedVue<{
        fillColor: string;
        fillOpacity: number;
    } & {
        strokeColor: string;
        strokeOpacity: number;
        strokeWeight: number;
        strokeStyle: "solid" | "dashed";
        strokeDasharray: number[];
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        path: PathLike;
    } & {
        $editor: AMapEditor;
    } & {
        $editable: import("./types/editable").EditableOptions<AMapComponent, AMapEditor>;
    } & {
        editable: boolean;
    }, unknown, unknown, unknown, Record<never, any>>;
    Polyline: import("vue/types/vue").ExtendedVue<{
        path: PathLike;
    } & {
        strokeColor: string;
        strokeOpacity: number;
        strokeWeight: number;
        strokeStyle: "solid" | "dashed";
        strokeDasharray: number[];
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        $editor: AMapEditor;
    } & {
        $editable: import("./types/editable").EditableOptions<AMapComponent, AMapEditor>;
    } & {
        editable: boolean;
    } & {
        lineJoin: "miter" | "round" | "bevel";
        lineCap: "round" | "butt" | "square";
        showDir: boolean;
        dirColor: string;
        dirImg: HTMLImageElement | HTMLCanvasElement;
        isOutline: boolean;
        outlineColor: string;
        borderWeight: number;
        geodesic: boolean;
    }, unknown, unknown, unknown, Record<never, any>>;
    BezierCurve: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $editor: AMapEditor;
    } & {
        $editable: import("./types/editable").EditableOptions<AMapComponent, AMapEditor>;
    } & {
        editable: boolean;
    } & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        lineJoin: "miter" | "round" | "bevel";
        lineCap: "round" | "butt" | "square";
        showDir: boolean;
        dirColor: string;
        dirImg: HTMLImageElement | HTMLCanvasElement;
        isOutline: boolean;
        outlineColor: string;
        borderWeight: number;
        geodesic: boolean;
    } & {
        strokeColor: string;
        strokeOpacity: number;
        strokeWeight: number;
        strokeStyle: "solid" | "dashed";
        strokeDasharray: number[];
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & {
        visible: boolean;
    } & {
        zIndex: number;
    }, unknown, unknown, unknown, {
        path: PathLike;
    }>;
    Rectangle: import("vue/types/vue").ExtendedVue<{
        fillColor: string;
        fillOpacity: number;
    } & {
        strokeColor: string;
        strokeOpacity: number;
        strokeWeight: number;
        strokeStyle: "solid" | "dashed";
        strokeDasharray: number[];
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        $editor: AMapEditor;
    } & {
        $editable: import("./types/editable").EditableOptions<AMapComponent, AMapEditor>;
    } & {
        editable: boolean;
    }, unknown, unknown, unknown, {
        bounds: number[][];
    }>;
    Ellipse: import("vue/types/vue").ExtendedVue<{
        fillColor: string;
        fillOpacity: number;
    } & {
        strokeColor: string;
        strokeOpacity: number;
        strokeWeight: number;
        strokeStyle: "solid" | "dashed";
        strokeDasharray: number[];
    } & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        $editor: AMapEditor;
    } & {
        $editable: import("./types/editable").EditableOptions<AMapComponent, AMapEditor>;
    } & {
        editable: boolean;
    }, unknown, unknown, unknown, {
        center: number[];
        radius: number[];
    }>;
    InfoWindow: import("vue/types/vue").ExtendedVue<{
        visible: boolean;
    } & import("vue").default & {
        cursor: string;
        bubble: boolean;
        clickable: boolean;
        draggable: boolean;
        extData: any;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & {
        zIndex: number;
    }, unknown, {
        open(): void;
        close(): void;
        onOpen(): void;
        onClose(): void;
        _updateContent(): void;
    }, unknown, {
        isCustom: boolean;
        autoMove: boolean;
        avoid: number[];
        closeWhenClickMap: boolean;
        content: string;
        size: number[];
        anchor: "center" | "top-left" | "top-center" | "top-right" | "middle-left" | "middle-right" | "bottom-left" | "bottom-center" | "bottom-right";
        offset: number[];
        position: number[];
    }>;
    TileLayer: import("vue/types/vue").ExtendedVue<{
        tileSize: number;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, {
        tileUrl: string;
        dataZooms: number[];
    }>;
    SatelliteLayer: import("vue/types/vue").ExtendedVue<{
        tileSize: number;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, Record<never, any>>;
    FlexibleLayer: import("vue/types/vue").ExtendedVue<{
        tileSize: number;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, {
        createTile: Function;
        cacheSize: number;
    }>;
    RoadNetLayer: import("vue/types/vue").ExtendedVue<{
        tileSize: number;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, Record<never, any>>;
    TrafficLayer: import("vue/types/vue").ExtendedVue<{
        tileSize: number;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, {
        autoRefresh: boolean;
        interval: number;
    }>;
    MapType: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    }, unknown, unknown, unknown, {
        defaultType: number;
        showTraffic: boolean;
        showRoad: boolean;
    }>;
    ControlBar: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        offset: number[];
    } & {
        position: import("./mixins/control").ControlPositionType;
    }, unknown, unknown, unknown, {
        showControlButton: boolean;
    }>;
    HawkEye: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        offset: number[];
    } & {
        position: import("./mixins/control").ControlPositionType;
    }, unknown, unknown, unknown, {
        visible: boolean;
        isOpen: boolean;
        autoMove: boolean;
        showRectangle: boolean;
        showButton: boolean;
        mapStyle: string;
        layers: unknown[];
        width: string;
        height: string;
        borderStyle: string;
        borderColor: string;
        borderRadius: string;
        borderWidth: string;
        buttonSize: string;
    }>;
    Scale: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        offset: number[];
    } & {
        position: import("./mixins/control").ControlPositionType;
    }, unknown, unknown, unknown, Record<never, any>>;
    ToolBar: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        offset: number[];
    } & {
        position: import("./mixins/control").ControlPositionType;
    }, unknown, unknown, unknown, Record<never, any>>;
    MarkerCluster: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default, {
        $mcc: import("./marker-cluster").MarkerClusterContext;
    }, {
        _onDataChange(): Promise<void>;
        _renderMarkerContent(context: any, renderer: import("vue").default, propData: any): void;
        _setMarkerOptions(context: any, getter: any, data: any): void;
        _renderMarker(context: any): void;
        _renderCluster(context: any): void;
    }, unknown, {
        data: any[];
        gridSize: number;
        maxZoom: number;
        averageCenter: boolean;
        clusterByZoomChange: boolean;
        styles: import("./marker-cluster").MarkerClusterStyle[];
        markerOptions: Function;
        clusterOptions: Function;
    }>;
    MouseTool: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default, {
        drawingMode: "marker" | "polyline" | "polygon" | "rectangle" | "circle" | "rule" | "measureArea" | "rectZoomIn" | "rectZoomOut" | "none";
    }, {
        close(clear: boolean): void;
        draw(): void;
        _onDraw(e: any): void;
    }, {
        $mousetool: any;
    }, {
        mode: "marker" | "polyline" | "polygon" | "rectangle" | "circle" | "rule" | "measureArea" | "rectZoomIn" | "rectZoomOut" | "none";
        clearWhenClose: boolean;
        options: any;
    }>;
    ImageLayer: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, {
        bounds: number[][];
        url: string;
    }>;
    CanvasLayer: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, {
        bounds: number[][];
    }>;
    CustomLayer: import("vue/types/vue").ExtendedVue<Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, {
        render: Function;
    }>;
    DistrictLayerWorld: import("vue/types/vue").ExtendedVue<{
        styles: AMap.DistrictLayerStyle;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    }, unknown, unknown, unknown, Record<never, any>>;
    DistrictLayerCountry: import("vue/types/vue").ExtendedVue<{
        styles: AMap.DistrictLayerStyle;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    } & {
        depth: number;
    }, unknown, unknown, unknown, {
        soc: string;
    }>;
    DistrictLayerProvince: import("vue/types/vue").ExtendedVue<{
        styles: AMap.DistrictLayerStyle;
    } & Record<never, any> & {
        $context: import("./types/amap-vue").ComponentContext<AMapComponent>;
        $container: import("./types/amap-vue").MapContext;
        $target: AMapComponent;
        $map: AMap.Map_2;
        $meta: import("./types/amap-vue").AMapMeta<AMapComponent>;
    } & import("vue").default & {
        visible: boolean;
    } & {
        zIndex: number;
    } & {
        zooms: number[] | [number, number];
    } & {
        opacity: number;
    } & {
        depth: number;
    }, unknown, unknown, unknown, {
        adcode: string | number | string[] | number[];
    }>;
};
export default _default;
export { config, loadAmap, loadPlugins, withAmap, Amap, Marker, LabelsLayer, LabelMarker, Text, Circle, CircleMarker, Polygon, Polyline, BezierCurve, Rectangle, Ellipse, InfoWindow, TileLayer, SatelliteLayer, FlexibleLayer, RoadNetLayer, TrafficLayer, MapType, ControlBar, HawkEye, Scale, ToolBar, MarkerCluster, MouseTool, ImageLayer, CanvasLayer, CustomLayer, DistrictLayerWorld, DistrictLayerCountry, DistrictLayerProvince, };
