/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.util.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.artfess.easyExcel.annotaion.ExcelSelected;
import com.artfess.easyExcel.handler.SelectedSheetWriteHandler;
import com.artfess.easyExcel.util.excel.ExcelSelectedResolve;
import com.artfess.easyExcel.util.excel.ExcelUtil;
import com.artfess.easyExcel.util.limiter.SlidingWindow;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.UnaryOperator;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(XExcelUtil.class);
    public static final Integer EXCEL_SHEET_ROW_MAX_SIZE = 1000001;
    private static final long DEF_PAGE_SIZE = 1000L;
    private static final int DEF_PARALLEL_NUM = Math.min(Runtime.getRuntime().availableProcessors(), 3);
    private HttpServletResponse httpServletResponse;
    private boolean parallel;
    private long pageSize = 1000L;
    private int parallelNum = DEF_PARALLEL_NUM;
    private String fileName;

    private XExcelUtil() {
    }

    public static XExcelUtil download(HttpServletResponse response, String fileNamePrefix) throws UnsupportedEncodingException {
        XExcelUtil excelUtil = new XExcelUtil();
        excelUtil.httpServletResponse = response;
        SimpleDateFormat date_sdf = new SimpleDateFormat();
        String format = date_sdf.format(new Date());
        excelUtil.fileName = fileNamePrefix + "_" + format + ".xlsx";
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String downloadFileName = URLEncoder.encode(excelUtil.fileName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + downloadFileName);
        return excelUtil;
    }

    public XExcelUtil parallel() {
        this.parallel = true;
        return this;
    }

    public XExcelUtil parallel(int parallelNum) {
        this.parallel = true;
        this.parallelNum = parallelNum;
        return this;
    }

    public XExcelUtil pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public <T> void pageExcelWriter(Class<T> head, UnaryOperator<IPage<T>> pageFunction) {
        if (this.parallel) {
            XExcelUtil.pageExcelWriterParallel((OutputStream)this.httpServletResponse.getOutputStream(), this.fileName, head, this.parallelNum, this.pageSize, pageFunction);
        } else {
            XExcelUtil.pageExcelWriter((OutputStream)this.httpServletResponse.getOutputStream(), this.fileName, head, this.pageSize, pageFunction);
        }
    }

    private static <T> void pageExcelWriter(OutputStream outputStream, String fileName, Class<T> head, long pageSize, UnaryOperator<IPage<T>> pageFunction) {
        long start = System.currentTimeMillis();
        Map<Integer, ExcelSelectedResolve> selectedMap = XExcelUtil.resolveSelectedAnnotation(head);
        log.debug("fileName:{}, excel writer start", (Object)fileName);
        try (ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream, head).build();){
            IPage page = null;
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0, (String)"Sheet0").registerWriteHandler((WriteHandler)new SelectedSheetWriteHandler(selectedMap))).registerWriteHandler((WriteHandler)ExcelUtil.buildCellStyle())).head(ExcelUtil.getExcelImportHead(head))).build();
            do {
                long pageSearchStartTime = System.currentTimeMillis();
                page = (IPage)pageFunction.apply((IPage<Page>)(page == null ? new Page(1L, pageSize) : new Page(page.getCurrent() + 1L, page.getSize(), page.getTotal(), false)));
                long pageExcelWriteStartTime = System.currentTimeMillis();
                writeSheet.setSheetNo(Integer.valueOf((int)(page.getCurrent() * page.getSize() / (long)EXCEL_SHEET_ROW_MAX_SIZE.intValue())));
                excelWriter.write((Collection)page.getRecords(), writeSheet);
                log.debug("fileName:{}, total:{}, pageSize:{}, totalPage:{}, pageNo:{}, sheetNo:{}, pageSearchTime:{}ms, pageExcelWriterTime:{}ms", new Object[]{fileName, page.getTotal(), page.getSize(), page.getPages(), page.getCurrent(), writeSheet.getSheetNo(), pageExcelWriteStartTime - pageSearchStartTime, System.currentTimeMillis() - pageExcelWriteStartTime});
            } while (page.getCurrent() < page.getPages());
        }
        log.debug("fileName:{}, excel writer done, totalTime:{}ms", (Object)fileName, (Object)(System.currentTimeMillis() - start));
    }

    private static <T> void pageExcelWriterParallel(OutputStream outputStream, String fileName, Class<T> head, int parallelNum, long pageSize, UnaryOperator<IPage<T>> pageFunction) throws ExecutionException, InterruptedException {
        long start = System.currentTimeMillis();
        Map<Integer, ExcelSelectedResolve> selectedMap = XExcelUtil.resolveSelectedAnnotation(head);
        log.debug("fileName:{}, excel writer start", (Object)fileName);
        try (ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream, head).build();){
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0, (String)"Sheet0").registerWriteHandler((WriteHandler)new SelectedSheetWriteHandler(selectedMap))).registerWriteHandler((WriteHandler)ExcelUtil.buildCellStyle())).head(ExcelUtil.getExcelImportHead(head))).build();
            IPage basePage = ((IPage)pageFunction.apply((IPage<Page>)new Page(1L, 0L))).setSize(pageSize);
            log.debug("fileName:{}, total:{}, pageSize:{}, totalPage:{}", new Object[]{fileName, basePage.getTotal(), basePage.getSize(), basePage.getPages()});
            SlidingWindow.create(IPage.class, parallelNum, basePage.getPages()).sendWindow(pageNo -> {
                long pageSearchStartTime = System.currentTimeMillis();
                IPage page = (IPage)pageFunction.apply((IPage<Page>)new Page(pageNo, basePage.getSize(), basePage.getTotal(), false));
                log.debug("fileName:{}, [\u8bfb]pageNo:{}, total:{}, pageSize:{}, totalPage:{}, pageSearchTime:{}ms", new Object[]{fileName, page.getCurrent(), page.getTotal(), page.getSize(), page.getPages(), System.currentTimeMillis() - pageSearchStartTime});
                return page;
            }).receiveWindow(page -> {
                long pageWriteStartTime = System.currentTimeMillis();
                writeSheet.setSheetNo(Integer.valueOf((int)(page.getCurrent() * page.getSize() / (long)EXCEL_SHEET_ROW_MAX_SIZE.intValue())));
                writeSheet.setSheetName("Sheet" + writeSheet.getSheetNo());
                excelWriter.write((Collection)page.getRecords(), writeSheet);
                log.debug("fileName:{}, [\u5199]pageNo:{}, total:{}, pageSize:{}, totalPage:{}, sheetNo:{}, pageWriteTime:{}ms", new Object[]{fileName, page.getCurrent(), page.getTotal(), page.getSize(), page.getPages(), writeSheet.getSheetNo(), System.currentTimeMillis() - pageWriteStartTime});
            }).start();
        }
        log.debug("fileName:{}, excel writer done, totalTime:{}ms", (Object)fileName, (Object)(System.currentTimeMillis() - start));
    }

    private static <T> Map<Integer, ExcelSelectedResolve> resolveSelectedAnnotation(Class<T> head) {
        HashMap<Integer, ExcelSelectedResolve> selectedMap = new HashMap<Integer, ExcelSelectedResolve>();
        Field[] fields = head.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            ExcelSelectedResolve excelSelectedResolve;
            String[] source;
            Field field = fields[i];
            ExcelSelected selected = field.getAnnotation(ExcelSelected.class);
            ExcelProperty property = field.getAnnotation(ExcelProperty.class);
            if (selected == null || (source = (excelSelectedResolve = new ExcelSelectedResolve()).resolveSelectedSource(selected)) == null || source.length <= 0) continue;
            excelSelectedResolve.setSource(source);
            excelSelectedResolve.setFirstRow(selected.firstRow());
            excelSelectedResolve.setLastRow(selected.lastRow());
            if (property != null && property.index() >= 0) {
                selectedMap.put(property.index(), excelSelectedResolve);
                continue;
            }
            selectedMap.put(i, excelSelectedResolve);
        }
        return selectedMap;
    }
}

