/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.dao.RoleDao;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserRole;
import com.artfess.uc.params.role.RoleVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.OrgUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RoleManagerImpl
extends BaseManagerImpl<RoleDao, Role>
implements RoleManager {
    @Autowired
    UserRoleManager userRoleManager;
    @Autowired
    UserManager userService;
    @Autowired
    OrgManager orgService;
    @Autowired
    UserRoleManager userRoleService;
    @Autowired
    SystemConfigFeignService portalFeignService;

    @Override
    public Role getByAlias(String code) {
        return ((RoleDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<Role> getListByUserId(String userId) {
        return ((RoleDao)this.baseMapper).getListByUserId(userId);
    }

    @Override
    public List<Role> getListByAccount(String account) {
        return ((RoleDao)this.baseMapper).getListByAccount(account);
    }

    @Transactional
    public void remove(String roleId) {
        super.remove((Serializable)((Object)roleId));
        this.userRoleManager.removeByRoleId(roleId, LocalDateTime.now());
        this.delUserMenuCache();
    }

    private void delUserMenuCache() {
        RoleManagerImpl bean = (RoleManagerImpl)AppUtil.getBean(this.getClass());
        bean.removeUserMenuCache();
    }

    @CacheEvict(value={"bpm:sys:userMenu:new"}, allEntries=true)
    protected void removeUserMenuCache() {
    }

    private void delUserMenuCacheByUserId(String userId) {
        RoleManagerImpl bean = (RoleManagerImpl)AppUtil.getBean(this.getClass());
        bean.removeUserMenuCacheByUserIde(userId);
    }

    @CacheEvict(value={"bpm:sys:userMenu:new"}, key="#userId")
    protected void removeUserMenuCacheByUserIde(String userId) {
    }

    @Override
    @Transactional
    public CommonResult<String> addRole(RoleVo roleVo) throws Exception {
        if (StringUtil.isEmpty((String)roleVo.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)roleVo.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (((RoleDao)this.baseMapper).getCountByCode(roleVo.getCode()) > 0) {
            return new CommonResult(false, "\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010" + roleVo.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        Role role = RoleVo.parse(roleVo);
        role.setUpdateTime(LocalDateTime.now());
        role.setId(UniqueIdUtil.getSuid());
        this.create((Model)role);
        return new CommonResult(true, "\u6dfb\u52a0\u89d2\u8272\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteRole(String codes) throws Exception {
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        boolean isTrue = false;
        for (String code : codeArray) {
            Role role = this.getByAlias(code);
            if (BeanUtils.isNotEmpty((Object)role)) {
                if (OrgUtil.checkUserGruopIsUserRel("role", role.getId())) {
                    str.append("\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u89d2\u8272\u4e3a\u6c47\u62a5\u8282\u70b9\u4e0d\u80fd\u5220\u9664\uff0c");
                    continue;
                }
                this.remove(role.getId());
                isTrue = true;
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        this.delUserMenuCache();
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> deleteRoleByIds(String ids) throws Exception {
        String[] idArray = ids.split(",");
        StringBuilder str = new StringBuilder();
        boolean isTrue = false;
        HashSet<String> roleAlias = new HashSet<String>();
        for (String id : idArray) {
            Role role = (Role)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)role)) {
                this.remove(role.getId());
                this.clearRoleCahceMenu(role.getCode());
                isTrue = true;
                roleAlias.add(role.getCode());
                continue;
            }
            str.append(id);
            str.append("\uff0c");
        }
        this.portalFeignService.removeByRoleAlias(StringUtil.join(roleAlias));
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> updateRole(RoleVo roleVo) throws Exception {
        if (StringUtil.isEmpty((String)roleVo.getCode())) {
            throw new RequiredException("\u66f4\u65b0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        Role role = ((RoleDao)this.baseMapper).getByCode(roleVo.getCode());
        if (BeanUtils.isEmpty((Object)role)) {
            return new CommonResult(false, "\u66f4\u65b0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010" + roleVo.getCode() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)roleVo.getName())) {
            role.setName(roleVo.getName());
        }
        if (roleVo.getDescription() != null) {
            role.setDescription(roleVo.getDescription());
        }
        if (roleVo.getRoleType() != null) {
            role.setRoleType(roleVo.getRoleType());
        }
        if (roleVo.getEnabled() != null) {
            if (roleVo.getEnabled() != role.getEnabled()) {
                this.clearRoleCahceMenu(role.getCode());
            }
            role.setEnabled(roleVo.getEnabled());
        }
        this.update((Model)role);
        return new CommonResult(true, "\u66f4\u65b0\u89d2\u8272\u6210\u529f\uff01", (Object)"");
    }

    @Transactional
    private void clearRoleCahceMenu(String roleCode) throws Exception {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("r.CODE_", (Object)roleCode, QueryOP.EQUAL, FieldRelation.AND, "group_code");
        Page list = (Page)this.userService.getRoleUserQuery(filter);
        for (User userRole : list.getRecords()) {
            this.delUserMenuCacheByUserId(userRole.getUserId());
        }
    }

    @Override
    public Role getRole(String code) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return role;
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserRole(String code, String accounts) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        String[] accountArray = accounts.split(",");
        StringBuilder values = new StringBuilder();
        boolean isFirst = true;
        int size = 0;
        String msg = "\u5206\u914d\u7528\u6237\u6210\u529f\uff01";
        for (String account : accountArray) {
            User user = this.userService.getByAccount(account);
            if (BeanUtils.isNotEmpty((Object)user)) {
                this.addUserRole(user.getUserId(), role.getId());
                ++size;
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                values.append("\uff0c");
            }
            values.append(account);
        }
        if (size == 0) {
            msg = "\u672a\u5206\u914d\u4efb\u4f55\u7528\u6237\uff01";
        } else if (size > 0 && size < accountArray.length) {
            msg = "\u90e8\u5206\u5206\u914d\u6210\u529f\uff01";
        }
        return new CommonResult(true, msg, (Object)(StringUtil.isNotEmpty((String)values.toString()) ? "\u8d26\u53f7\uff1a\u3010" + values.toString() + "\u3011\u4e0d\u5b58\u5728\uff01" : ""));
    }

    @Override
    @Transactional
    public CommonResult<String> addUserRoleByOrg(String code, String orgCodes) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        String[] orgCodesArray = orgCodes.split(",");
        StringBuilder values = new StringBuilder();
        boolean isFirst = true;
        int size = 0;
        String msg = "\u5206\u914d\u7528\u6237\u6210\u529f\uff01";
        for (String orgCode : orgCodesArray) {
            Org org = this.orgService.getByCode(orgCode);
            if (BeanUtils.isNotEmpty((Object)org)) {
                List<User> users = this.userService.getUserListByOrgId(org.getId());
                for (User user : users) {
                    this.addUserRole(user.getUserId(), role.getId());
                }
                ++size;
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                values.append("\uff0c");
            }
            values.append(orgCode);
        }
        if (size == 0) {
            msg = "\u672a\u5206\u914d\u4efb\u4f55\u7528\u6237\uff01";
        } else if (size > 0 && size < orgCodesArray.length) {
            msg = "\u90e8\u5206\u5206\u914d\u6210\u529f\uff01";
        }
        return new CommonResult(true, msg, (Object)(StringUtil.isNotEmpty((String)values.toString()) ? "\u7ec4\u7ec7\u7f16\u7801\uff1a\u3010" + values.toString() + "\u3011\u4e0d\u5b58\u5728\uff01" : ""));
    }

    @Override
    @Transactional
    public CommonResult<String> removeUserRole(String code, String accounts) throws Exception {
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        String[] accountArray = accounts.split(",");
        int size = 0;
        String msg = "\u79fb\u9664\u7528\u6237\u6210\u529f\uff01";
        for (String account : accountArray) {
            UserRole userRole;
            User user = this.userService.getByAccount(account);
            if (!BeanUtils.isNotEmpty((Object)user) || !BeanUtils.isNotEmpty((Object)(userRole = this.userRoleManager.getByRoleIdUserId(role.getId(), user.getId())))) continue;
            this.userRoleManager.remove((Serializable)((Object)userRole.getId()));
            ++size;
            this.delUserMenuCacheByUserId(userRole.getUserId());
        }
        if (size == 0) {
            msg = "\u672a\u79fb\u9664\u4efb\u4f55\u7528\u6237\uff01";
        } else if (size > 0 && size < accountArray.length) {
            msg = "\u90e8\u5206\u79fb\u9664\u6210\u529f\uff01";
        }
        return new CommonResult(true, msg, (Object)"");
    }

    @Override
    public List<Role> getRolesByUser(String account) throws Exception {
        return ((RoleDao)this.baseMapper).getListByAccount(account);
    }

    @Override
    public List<UserVo> getUsersByRoleCode(String codes) throws Exception {
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        String[] codeArray = codes.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        boolean isFirst = true;
        for (String code : codeArray) {
            List<User> users = this.userService.getUserListByRoleCode(code);
            if (BeanUtils.isNotEmpty(users)) {
                list.addAll(users);
                isTrue = true;
                continue;
            }
            if (!isFirst) {
                msg.append(",");
            } else {
                isFirst = false;
            }
            msg.append(code);
        }
        if (!isTrue) {
            throw new RequiredException("\u6839\u636e\u89d2\u8272\u7f16\u7801\u3010" + msg + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
        }
        OrgUtil.removeDuplicate(list);
        return OrgUtil.convertToUserVoList(list);
    }

    @Transactional
    private void addUserRole(String userId, String roleId) {
        if (this.userRoleService.getByRoleIdUserId(roleId, userId) != null) {
            return;
        }
        UserRole userRole = new UserRole();
        userRole.setId(UniqueIdUtil.getSuid());
        userRole.setUserId(userId);
        userRole.setRoleId(roleId);
        this.userRoleService.create((Model)userRole);
        this.delUserMenuCacheByUserId(userRole.getUserId());
    }

    @Override
    public List<Role> getOrgRoleList(Map<String, Object> params) {
        return ((RoleDao)this.baseMapper).getOrgRoleList(params);
    }

    @Override
    @Transactional
    public CommonResult<String> forbiddenRoles(String codes) throws Exception {
        String str = this.forbOrActiveRole(codes, 0);
        String msg = StringUtil.isEmpty((String)str) ? "\u7981\u7528\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u7981\u7528\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(true, msg, (Object)str);
    }

    @Override
    @Transactional
    public CommonResult<String> activateRoles(String codes) throws Exception {
        String str = this.forbOrActiveRole(codes, 1);
        String msg = StringUtil.isEmpty((String)str) ? "\u6fc0\u6d3b\u89d2\u8272\u6210\u529f\uff01" : "\u90e8\u5206\u6fc0\u6d3b\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\uff1a" + str + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(true, msg, (Object)str);
    }

    @Transactional
    private String forbOrActiveRole(String codes, Integer enabled) throws SQLException {
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        for (String code : codeArray) {
            Role role = this.getByAlias(code);
            if (BeanUtils.isNotEmpty((Object)role)) {
                role.setEnabled(enabled);
                this.update((Model)role);
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        return str.toString();
    }

    @Override
    public List<Role> getRoleByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.queryNoPage(queryFilter);
    }

    @Override
    @Transactional
    public Integer removeUserRolePhysical() throws Exception {
        return this.userRoleManager.removePhysical();
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        Role role = ((RoleDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)role)) ? "\u8be5\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    public List<Role> getOrgRoleListNotCode(String code) {
        return ((RoleDao)this.baseMapper).getOrgRoleListNotCode(code);
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserRoles(String codes, String account) {
        String[] codeArr;
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3010" + codes + "\u3011\u5fc5\u586b\uff01");
        }
        for (String code : codeArr = codes.split(",")) {
            Role role = ((RoleDao)this.baseMapper).getByCode(code);
            if (BeanUtils.isEmpty((Object)role)) {
                return new CommonResult(false, "\u89d2\u8272\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            StringBuilder values = new StringBuilder();
            boolean isFirst = true;
            User user = null;
            try {
                user = this.userService.getByAccount(account);
            }
            catch (Exception e) {
                return new CommonResult(false, "\u8d26\u53f7\u3010" + account + "\u3011\u65e0\u6548\uff01");
            }
            if (BeanUtils.isNotEmpty((Object)user)) {
                this.addUserRole(user.getUserId(), role.getId());
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else {
                values.append("\uff0c");
            }
            values.append(account);
        }
        return new CommonResult(true, "\u5206\u914d\u89d2\u8272\u6210\u529f");
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((RoleDao)this.baseMapper).removePhysical();
    }

    @Override
    public void importData(MultipartFile file) throws Exception {
        List list = ExcelUtil.readExcel(RoleVo.class, (MultipartFile)file);
        if (BeanUtils.isNotEmpty((Object)list)) {
            if (!this.validateAllRole(list)) {
                String message = "\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e\u3002";
                throw new BaseException(message);
            }
            for (RoleVo roleVo : list) {
                Role role = ((RoleDao)this.baseMapper).getByCode(roleVo.getCode());
                if (!BeanUtils.isEmpty((Object)role)) continue;
                Role nrole = RoleVo.parse(roleVo);
                nrole.setId(UniqueIdUtil.getSuid());
                this.create((Model)nrole);
            }
        }
    }

    private boolean validateAllRole(List<RoleVo> list) {
        for (RoleVo roleVo : list) {
            if (StringUtil.isEmpty((String)roleVo.getName()) || StringUtil.isEmpty((String)roleVo.getCode()) || BeanUtils.isEmpty((Object)roleVo.getRoleType()) || BeanUtils.isEmpty((Object)roleVo.getEnabled())) {
                return false;
            }
            if (!roleVo.getName().matches("^[\\s\\S]{1,30}$") || !roleVo.getCode().matches("^[0-9a-z]{1,30}$")) {
                return false;
            }
            if (roleVo.getRoleType() != 1 && roleVo.getRoleType() != 2) {
                return false;
            }
            if (roleVo.getEnabled() == 0 || roleVo.getEnabled() == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public CommonResult<String> addRoleFromExterUni(Role roleVo) throws Exception {
        if (StringUtil.isEmpty((String)roleVo.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)roleVo.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (((RoleDao)this.baseMapper).getCountByCode(roleVo.getCode()) > 0) {
            return new CommonResult(false, "\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u3010" + roleVo.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        Role role = new Role();
        if (BeanUtils.isEmpty((Object)roleVo.getId())) {
            role.setId(UniqueIdUtil.getSuid());
        } else {
            if (BeanUtils.isNotEmpty((Object)this.get((Serializable)((Object)roleVo.getId())))) {
                throw new RequiredException("\u6dfb\u52a0\u89d2\u8272\u5931\u8d25\uff0c\u89d2\u8272id\u3010" + roleVo.getId() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01");
            }
            role.setId(roleVo.getId());
        }
        role.setName(roleVo.getName());
        role.setCode(roleVo.getCode());
        role.setDescription(roleVo.getDescription());
        role.setEnabled(BeanUtils.isEmpty((Object)roleVo.getEnabled()) ? 1 : roleVo.getEnabled());
        role.setUpdateTime(LocalDateTime.now());
        this.create((Model)role);
        return new CommonResult(true, "\u6dfb\u52a0\u89d2\u8272\u6210\u529f\uff01", (Object)"");
    }
}

