/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.job;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.job.model.BaseJob;
import com.artfess.rescue.video.dto.CamerasRequest;
import com.artfess.rescue.video.manager.BizVideoAreaInfoManager;
import com.artfess.rescue.video.manager.BizVideoMonitorPointInfoManager;
import com.artfess.rescue.video.model.BizVideoAreaInfo;
import com.artfess.rescue.video.util.ArtemisRequest;
import com.artfess.rescue.video.util.HkArtemisRequest;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoMonitorPointInfoSynchronizationJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(VideoMonitorPointInfoSynchronizationJob.class);
    @Resource
    private BizVideoAreaInfoManager videoAreaInfoManager;
    @Resource
    private ArtemisRequest artemisRequest;
    @Resource
    private HkArtemisRequest hkArtemisRequest;
    @Resource
    private BizVideoMonitorPointInfoManager videoMonitorPointInfoManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    public void executeJob(JobExecutionContext context) throws Exception {
        LocalDateTime start = LocalDateTime.now();
        log.info("================= \u6444\u50cf\u5934\u70b9\u4f4d\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb start =================");
        List all = this.videoAreaInfoManager.getAll();
        ArrayList futures = new ArrayList();
        for (BizVideoAreaInfo bizVideoAreaInfo : all) {
            int pageNoHk = 1;
            int pageNoRl = 1;
            boolean hasMoreHk = true;
            boolean hasMoreRl = true;
            while (hasMoreHk || hasMoreRl) {
                Future<?> future;
                if (hasMoreHk) {
                    String hkCamerasResponse = this.fetchHkCamerasData(bizVideoAreaInfo.getIndexCode(), pageNoHk);
                    JSONObject hkRegionsJson = JSONObject.parseObject((String)hkCamerasResponse);
                    if (hkRegionsJson != null && "0".equals(Objects.toString(hkRegionsJson.getString("code"), ""))) {
                        JSONObject hkDataJson = hkRegionsJson.getJSONObject("data");
                        Integer totalHk = hkDataJson.getInteger("total");
                        if (totalHk == null || totalHk == 0 || hkDataJson.getJSONArray("list").isEmpty()) {
                            hasMoreHk = false;
                        } else {
                            JSONArray hkList = hkDataJson.getJSONArray("list");
                            future = this.executorService.submit(() -> this.videoMonitorPointInfoManager.saveSynchronizationInfo(hkList, 2));
                            futures.add(future);
                            int totalPagesHk = (totalHk + 199) / 200;
                            hasMoreHk = pageNoHk < totalPagesHk;
                            ++pageNoHk;
                        }
                    } else {
                        log.warn("HK API request failed for region: {}. Response: {}", (Object)bizVideoAreaInfo.getIndexCode(), (Object)hkCamerasResponse);
                        hasMoreHk = false;
                    }
                }
                if (!hasMoreRl) continue;
                String camerasResponse = this.fetchCamerasData(bizVideoAreaInfo.getIndexCode(), pageNoRl);
                JSONObject regionsJson = JSONObject.parseObject((String)camerasResponse);
                if (regionsJson != null && "0".equals(Objects.toString(regionsJson.getString("code"), ""))) {
                    JSONObject dataJson = regionsJson.getJSONObject("data");
                    Integer totalRl = dataJson.getInteger("total");
                    if (totalRl == null || totalRl == 0 || dataJson.getJSONArray("list").isEmpty()) {
                        hasMoreRl = false;
                        continue;
                    }
                    JSONArray list = dataJson.getJSONArray("list");
                    future = this.executorService.submit(() -> this.videoMonitorPointInfoManager.saveSynchronizationInfo(list, 1));
                    futures.add(future);
                    int totalPagesRl = (totalRl + 199) / 200;
                    hasMoreRl = pageNoRl < totalPagesRl;
                    ++pageNoRl;
                    continue;
                }
                log.warn("RL API request failed for region: {}. Response: {}", (Object)bizVideoAreaInfo.getIndexCode(), (Object)camerasResponse);
                hasMoreRl = false;
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Error in async execution", (Throwable)e);
            }
        }
        LocalDateTime end = LocalDateTime.now();
        long l = Duration.between(start, end).toMinutes();
        log.info("================= \u6444\u50cf\u5934\u70b9\u4f4d\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb end =================");
        log.info("\u6444\u50cf\u5934\u70b9\u4f4d\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u8017\u65f6\uff1a{} \u5206\u949f", (Object)l);
    }

    private String fetchCamerasData(String regionIndexCode, int pageNo) {
        CamerasRequest camerasRequest = CamerasRequest.builder().pageNo(pageNo).pageSize(200).treeCode("0").regionIndexCode(regionIndexCode).build();
        try {
            return this.artemisRequest.cameras(camerasRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String fetchHkCamerasData(String regionIndexCode, int pageNo) {
        CamerasRequest camerasRequest = CamerasRequest.builder().pageNo(pageNo).pageSize(200).treeCode("0").regionIndexCode(regionIndexCode).build();
        try {
            return this.hkArtemisRequest.cameras(camerasRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

