/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.conf.NettyConfig;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.base.manager.BizCarTaskLogManager;
import com.artfess.rescue.base.model.BizCarTaskLog;
import com.artfess.rescue.event.dto.InspectionInfoDto;
import com.artfess.rescue.file.manager.BizRescueFileCommonManager;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import com.artfess.rescue.patrol.dao.BizInspectionResultDao;
import com.artfess.rescue.patrol.dao.BizInspectionResultDetailDao;
import com.artfess.rescue.patrol.dao.BizInspectionTaskDao;
import com.artfess.rescue.patrol.manager.BizInspectionResultDetailManager;
import com.artfess.rescue.patrol.manager.BizInspectionResultManager;
import com.artfess.rescue.patrol.model.BizInspectionResult;
import com.artfess.rescue.patrol.model.BizInspectionResultDetail;
import com.artfess.rescue.patrol.model.BizInspectionTask;
import com.artfess.rescue.patrol.vo.ResultLedgerVO;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizInspectionResultDetailManagerImpl
extends BaseManagerImpl<BizInspectionResultDetailDao, BizInspectionResultDetail>
implements BizInspectionResultDetailManager {
    @Resource
    BizInspectionTaskDao taskDao;
    @Resource
    BizInspectionResultDao resultDao;
    @Resource
    BizRescueFileCommonManager fileCommonManager;
    @Resource
    BizInspectionResultManager inspectionResultManager;
    @Resource
    BizCarTaskLogManager logManager;
    @Resource
    FileManager fileManager;

    @Override
    public List<BizInspectionResultDetail> findByResultId(String resultId) {
        List<BizInspectionResultDetail> details = ((BizInspectionResultDetailDao)this.baseMapper).findByResultId(resultId);
        if (details != null && !details.isEmpty()) {
            List<String> idList = details.stream().map(BizInspectionResultDetail::getId).collect(Collectors.toList());
            Map<String, List<BizRescueFileCommon>> fileMap = this.fileCommonManager.getFilePreviewLikeCommonIds(idList).stream().collect(Collectors.groupingBy(BizRescueFileCommon::getCommonId));
            details.forEach(d -> {
                List files = (List)fileMap.get(d.getId());
                if (files != null) {
                    d.setFiles(files);
                }
            });
        }
        return details;
    }

    @Override
    public PageList<BizInspectionResultDetail> findByPage(QueryFilter<BizInspectionResultDetail> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizInspectionResultDetail> result = ((BizInspectionResultDetailDao)this.baseMapper).findByPage((IPage<BizInspectionResultDetail>)this.convert2IPage(pageBean), (QueryWrapper<BizInspectionResultDetail>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizInspectionResultDetail findById(String id) {
        BizInspectionResultDetail resultDetail = ((BizInspectionResultDetailDao)this.baseMapper).findById(id);
        if (null != resultDetail) {
            resultDetail.setFiles(this.fileCommonManager.getFileByCommonId(id));
        }
        return resultDetail;
    }

    @Override
    public List<BizInspectionResultDetail> findByList(String taskId) {
        List<BizInspectionResultDetail> details = ((BizInspectionResultDetailDao)this.baseMapper).findByList(taskId);
        if (details == null) {
            return new ArrayList<BizInspectionResultDetail>();
        }
        List<String> idList = details.stream().map(BizInspectionResultDetail::getId).collect(Collectors.toList());
        if (!idList.isEmpty()) {
            Map<String, List<BizRescueFileCommon>> map = this.fileCommonManager.getFilePreviewLikeCommonIds(idList).stream().collect(Collectors.groupingBy(BizRescueFileCommon::getCommonId));
            details.forEach(d -> d.setFiles((List)map.get(d.getId())));
        }
        return details;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean accept(InspectionInfoDto t) {
        int update;
        BizInspectionResult existingResult;
        String id = t.getId();
        BizInspectionResult result = t.getResult();
        BizInspectionTask task = (BizInspectionTask)((Object)this.taskDao.selectById((Serializable)((Object)id)));
        if (task == null) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4efb\u52a1\u4fe1\u606f");
        }
        BizCarTaskLog carTaskLog = new BizCarTaskLog();
        carTaskLog.setIsUse(1);
        carTaskLog.setTaskId(id);
        carTaskLog.setCarCode(result.getCarCode());
        carTaskLog.setStartMileage(result.getStartMileage());
        carTaskLog.setCarAppearance(result.getCarAppearance());
        carTaskLog.setCarFfe(result.getCarFfe());
        carTaskLog.setCarEngine(result.getCarEngine());
        carTaskLog.setCarLight(result.getCarLight());
        carTaskLog.setCarOp(result.getCarOp());
        this.logManager.save((Object)carTaskLog);
        List<BizRescueFileCommon> files = t.getFiles();
        if (files != null && !files.isEmpty()) {
            List fileIds = files.stream().map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, carTaskLog.getId());
        }
        if ((existingResult = this.resultDao.findByTaskId(id)) == null) {
            result.setPlanId(task.getPlanId());
            result.setTaskId(task.getId());
            result.setType(task.getPlanType());
            result.setWorkclass(task.getWorkclass());
            result.setInspectType(task.getInspectType());
            result.setRoadId(task.getRoadId());
            result.setRoadName(task.getRoadName());
            result.setRoadCode(task.getRoadCode());
            result.setStartPatrolId(task.getStartPatrolId());
            result.setStartPatrolName(task.getStartPatrolName());
            result.setEndPatrolId(task.getEndPatrolId());
            result.setEndPatrolName(task.getEndPatrolName());
            result.setTeamId(task.getTeamId());
            result.setStartTime(LocalDateTime.now());
            result.setLinkStartTime(LocalDateTime.now());
            int resultSave = this.resultDao.insert((Object)result);
            if (resultSave == 0) {
                throw new ApplicationException("\u65b0\u589e\u5931\u8d25");
            }
        }
        JSONObject team = ContextUtil.getCurrentTeam();
        String userId = "";
        if (team != null) {
            userId = team.getString("userId");
        }
        if ((update = this.taskDao.updateByStatus(id, 2, userId)) == 0) {
            throw new ApplicationException("\u63a5\u5355\u72b6\u6001\u4fee\u6539\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean end(InspectionInfoDto t) {
        String id = t.getId();
        BizInspectionResult result = t.getResult();
        BigDecimal endMileage = result.getEndMileage();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BizCarTaskLog::getTaskId, (Object)id)).eq(BizCarTaskLog::getIsUse, (Object)1)).orderByDesc(BizCarTaskLog::getCreateTime)).last("LIMIT 1");
        BizCarTaskLog taskLog = (BizCarTaskLog)((Object)this.logManager.getOne((Wrapper)wrapper));
        taskLog.setEndMileage(endMileage);
        boolean update = this.logManager.updateById((Object)taskLog);
        if (!update) {
            throw new ApplicationException("\u4fee\u6539\u72b6\u6001\u5931\u8d25");
        }
        List<BizRescueFileCommon> files = t.getFiles();
        if (files != null && !files.isEmpty()) {
            List fileIds = files.stream().map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, taskLog.getId());
        }
        this.resultDao.updateEndMileage(id);
        this.taskDao.updateByStatus(id, 4, null);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizInspectionResultDetail entity) {
        IUser user = ContextUtil.getCurrentUser();
        if (user != null) {
            entity.setHandleUser(user.getUserId());
            entity.setHandleUserName(user.getFullname());
        }
        entity.setHandleTime(LocalDateTime.now());
        entity.setTeamId(ContextUtil.getCurrentTeamId());
        entity.setInspectUserId(ContextUtil.getCurrentUserId());
        entity.setInspectUserName(ContextUtil.getCurrentUserName());
        entity.setInspectTime(LocalDateTime.now());
        boolean save = this.save((Object)entity);
        if (!save) {
            throw new ApplicationException("\u5de1\u68c0\u7ed3\u679c\u751f\u6210\u5931\u8d25");
        }
        int update = this.taskDao.updateByStatus(entity.getTaskId(), 3, null);
        if (update == 0) {
            throw new ApplicationException("\u4fee\u6539\u72b6\u6001\u5931\u8d25");
        }
        List<BizRescueFileCommon> files = entity.getFiles();
        if (files != null && !files.isEmpty()) {
            List fileIds = files.stream().map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        }
        try {
            if (entity.getInspectStatus() != null && entity.getHandleType() != null && entity.getInspectStatus().equals("0") && entity.getHandleType().equals("2")) {
                JSONObject message = new JSONObject();
                message.put("messageType", (Object)"alarm");
                message.put("data", (Object)entity);
                message.put("orgId", (Object)ContextUtil.getCurrentOrgId());
                NettyConfig.getChannelGroup().writeAndFlush((Object)new TextWebSocketFrame(message.toJSONString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizInspectionResult::getId, (Object)entity.getResultId());
        BizInspectionResult inspectionResult = (BizInspectionResult)((Object)this.inspectionResultManager.getOne((Wrapper)wrapper));
        if (!Objects.isNull((Object)inspectionResult)) {
            inspectionResult.setReportingPoint(inspectionResult.getReportingPoint() + 1);
            if ("0".equals(entity.getInspectStatus())) {
                inspectionResult.setOutlierPoint(inspectionResult.getOutlierPoint() + 1);
            }
            long seconds = ChronoUnit.SECONDS.between(inspectionResult.getLinkStartTime(), LocalDateTime.now());
            inspectionResult.setTimeSpent(inspectionResult.getTimeSpent() + seconds);
            inspectionResult.setLinkStartTime(LocalDateTime.now());
            this.inspectionResultManager.updateById((Object)inspectionResult);
        }
        return true;
    }

    @Override
    public PageList<BizInspectionResultDetail> issuePatrolList(QueryFilter<BizInspectionResultDetail> queryFilter) {
        IPage<BizInspectionResultDetail> iPage = ((BizInspectionResultDetailDao)this.baseMapper).issuePatrolList((IPage<BizInspectionResultDetail>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizInspectionResultDetail>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public List<ResultLedgerVO> getResultDetails(List<String> taskIds) {
        return ((BizInspectionResultDetailDao)this.baseMapper).getResultDetails(taskIds);
    }
}

