/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.external.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.manager.BizOrgReflectionManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizOrgReflection;
import com.artfess.rescue.common.util.PointUtil;
import com.artfess.rescue.event.enums.EventTypeEnum;
import com.artfess.rescue.event.manager.BizEventInfoManager;
import com.artfess.rescue.event.manager.BizEventProgressManager;
import com.artfess.rescue.event.manager.BizTrafficCongestionManager;
import com.artfess.rescue.event.manager.BizTrafficControlManager;
import com.artfess.rescue.event.model.BizEventInfo;
import com.artfess.rescue.event.model.BizEventProgress;
import com.artfess.rescue.event.model.BizTrafficCongestion;
import com.artfess.rescue.event.model.BizTrafficControl;
import com.artfess.rescue.external.enums.DirectionEnum;
import com.artfess.rescue.external.enums.EventDirectionEnum;
import com.artfess.rescue.external.enums.EventPlaceEnum;
import com.artfess.rescue.external.enums.EventSourceEnum;
import com.artfess.rescue.external.enums.EventStatusEnum;
import com.artfess.rescue.external.enums.LwEventTypeEnum;
import com.artfess.rescue.external.enums.TrafficEventTypeEnum;
import com.artfess.rescue.external.manager.BizDataReceiveManager;
import com.artfess.rescue.external.manager.ReceiveEventManager;
import com.artfess.rescue.external.model.BizDataReceive;
import com.artfess.rescue.external.model.JamEvent;
import com.artfess.rescue.external.model.ResubmitEvent;
import com.artfess.rescue.external.model.TrafficControl;
import com.artfess.rescue.external.model.TrafficEvent;
import com.artfess.rescue.external.utils.ConvertUtils;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.gson.Gson;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReceiveEventManagerImpl
implements ReceiveEventManager {
    private static final Logger log = LoggerFactory.getLogger(ReceiveEventManagerImpl.class);
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private BizEventInfoManager bizEventInfoManager;
    @Resource
    private BizEventProgressManager bizEventProgressManager;
    @Resource
    private BizTrafficControlManager bizTrafficControlManager;
    @Resource
    private BizTrafficCongestionManager bizTrafficCongestionManager;
    @Resource
    private BizOrgReflectionManager bizOrgReflectionManager;
    @Resource
    private BizDataReceiveManager bizDataReceiveManager;
    @Resource
    private BizBaseRoadManager bizBaseRoadManager;
    @Resource
    private PointUtil pointUtil;
    private static final String ROAD_CACHE_KET = "road:map:cache:";

    @Override
    public CommonResult<String> receiveEvent(String data, String ptType) {
        int type = TrafficEventTypeEnum.getGroupByOptType(ptType);
        BizDataReceive dataReceive = new BizDataReceive();
        dataReceive.setContent(data);
        dataReceive.setSourceSystem(TrafficEventTypeEnum.getGroupName(type));
        dataReceive.setBusinessType(ptType);
        dataReceive.setReceiveTime(LocalDateTime.now());
        switch (type) {
            case 1: {
                return this.trafficEventDisposal(data, dataReceive);
            }
            case 2: {
                return this.resubmitEventDisposal(data, dataReceive);
            }
            case 3: {
                return this.jamEventDisposal(data, dataReceive);
            }
            case 4: {
                return this.trafficControlDisposal(data, dataReceive);
            }
        }
        return new CommonResult(false, "\u7c7b\u578b:" + ptType + "\u4e0d\u5c5e\u4e8e\u7ea6\u5b9a\u7684\u8303\u56f4\uff0c\u64cd\u4f5c\u5931\u8d25\uff01", (Object)data);
    }

    @Override
    public void retryReceive(BizDataReceive dataReceive) {
        String data = dataReceive.getContent();
        String ptType = dataReceive.getBusinessType();
        int type = TrafficEventTypeEnum.getGroupByOptType(ptType);
        switch (type) {
            case 1: {
                this.trafficEventDisposal(data, dataReceive);
            }
            case 2: {
                this.resubmitEventDisposal(data, dataReceive);
            }
            case 3: {
                this.jamEventDisposal(data, dataReceive);
            }
            case 4: {
                this.trafficControlDisposal(data, dataReceive);
            }
        }
        new CommonResult(false, "\u7c7b\u578b:" + ptType + "\u4e0d\u5c5e\u4e8e\u7ea6\u5b9a\u7684\u8303\u56f4\uff0c\u64cd\u4f5c\u5931\u8d25\uff01", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonResult<String> trafficEventDisposal(String data, BizDataReceive dataReceive) {
        try {
            TrafficEvent trafficEvent = (TrafficEvent)JSON.parseObject((String)data, TrafficEvent.class);
            BizEventInfo bizEventInfo = this.convertToBizEventInfo(trafficEvent);
            if (bizEventInfo != null) {
                boolean result = this.bizEventInfoManager.saveOrUpdate((Object)bizEventInfo);
                if (!result) {
                    CommonResult commonResult = new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01", (Object)data);
                    return commonResult;
                }
                dataReceive.setProcessStatus(1);
            } else {
                dataReceive.setProcessStatus(0);
                dataReceive.setErrorMessage(trafficEvent.getRoadName() + "\u8def\u6bb5\u4e0d\u5b58\u5728\uff01");
            }
        }
        catch (Exception e) {
            dataReceive.setProcessStatus(2);
            dataReceive.setErrorMessage(e.getMessage());
            log.error("\u63a5\u6536\u4e09\u7c7b\u4e8b\u4ef6\u5904\u7f6e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        finally {
            this.bizDataReceiveManager.saveOrUpdate((Object)dataReceive);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonResult<String> resubmitEventDisposal(String data, BizDataReceive dataReceive) {
        try {
            ResubmitEvent resubmitEvent = (ResubmitEvent)JSON.parseObject((String)data, ResubmitEvent.class);
            BizEventInfo bizEventInfo = (BizEventInfo)((Object)this.bizEventInfoManager.getById((Serializable)((Object)resubmitEvent.getEventId())));
            if (Objects.isNull((Object)bizEventInfo)) {
                dataReceive.setProcessStatus(0);
                dataReceive.setErrorMessage("\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u524d\u7f6e\u7684\u4e8b\u4ef6\u4fe1\u606f\uff01");
                CommonResult commonResult = new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u524d\u7f6e\u7684\u4e8b\u4ef6\u4fe1\u606f\uff01", (Object)data);
                return commonResult;
            }
            BizEventProgress bizEventProgress = this.convertToBizEventProgress(resubmitEvent, bizEventInfo);
            boolean result = this.bizEventProgressManager.saveOrUpdate((Object)bizEventProgress);
            if (!result) {
                dataReceive.setProcessStatus(0);
                dataReceive.setErrorMessage("\u64cd\u4f5c\u5931\u8d25\uff01\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01");
                CommonResult commonResult = new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01", (Object)data);
                return commonResult;
            }
            dataReceive.setProcessStatus(1);
        }
        catch (Exception e) {
            dataReceive.setProcessStatus(2);
            dataReceive.setErrorMessage(e.getMessage());
            log.error("\u63a5\u6536\u7eed\u62a5\u4fe1\u606f\u5904\u7f6e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        finally {
            this.bizDataReceiveManager.saveOrUpdate((Object)dataReceive);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonResult<String> jamEventDisposal(String data, BizDataReceive dataReceive) {
        try {
            JSONArray jsonArray = JSON.parseArray((String)data);
            for (Object obj : jsonArray) {
                if (!(obj instanceof JSONObject)) continue;
                JamEvent jamEvent = (JamEvent)((JSONObject)obj).toJavaObject(JamEvent.class);
                BizEventInfo bizEventInfo = (BizEventInfo)((Object)this.bizEventInfoManager.getById((Serializable)((Object)jamEvent.getEventId())));
                if (Objects.isNull((Object)bizEventInfo)) {
                    dataReceive.setProcessStatus(0);
                    dataReceive.setErrorMessage("\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u524d\u7f6e\u7684\u4e8b\u4ef6\u4fe1\u606f\uff01");
                    CommonResult commonResult = new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u524d\u7f6e\u7684\u4e8b\u4ef6\u4fe1\u606f\uff01", (Object)data);
                    return commonResult;
                }
                BizTrafficCongestion bizTrafficCongestion = this.convertToBizTrafficCongestion(jamEvent, bizEventInfo);
                boolean result = this.bizTrafficCongestionManager.saveOrUpdate((Object)bizTrafficCongestion);
                if (!result) {
                    dataReceive.setProcessStatus(0);
                    dataReceive.setErrorMessage("\u64cd\u4f5c\u5931\u8d25\uff01\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01");
                    CommonResult commonResult = new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01", (Object)data);
                    return commonResult;
                }
                dataReceive.setProcessStatus(1);
            }
        }
        catch (Exception e) {
            dataReceive.setProcessStatus(2);
            dataReceive.setErrorMessage(e.getMessage());
            log.error("\u63a5\u4e8b\u4ef6\u62e5\u5835\u5904\u7f6e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        finally {
            this.bizDataReceiveManager.saveOrUpdate((Object)dataReceive);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonResult<String> trafficControlDisposal(String data, BizDataReceive dataReceive) {
        try {
            JSONArray jsonArray = JSON.parseArray((String)data);
            for (Object obj : jsonArray) {
                if (!(obj instanceof JSONObject)) continue;
                TrafficControl trafficControl = (TrafficControl)((JSONObject)obj).toJavaObject(TrafficControl.class);
                BizEventInfo bizEventInfo = (BizEventInfo)((Object)this.bizEventInfoManager.getById((Serializable)((Object)trafficControl.getEventId())));
                if (Objects.isNull((Object)bizEventInfo)) {
                    dataReceive.setProcessStatus(0);
                    dataReceive.setErrorMessage("\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u524d\u7f6e\u7684\u4e8b\u4ef6\u4fe1\u606f\uff01");
                    CommonResult commonResult = new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u627e\u5230\u524d\u7f6e\u7684\u65f6\u95f4\u4fe1\u606f\uff01", (Object)data);
                    return commonResult;
                }
                BizTrafficControl bizEventProgress = this.convertToBizTrafficControl(trafficControl, bizEventInfo);
                boolean result = this.bizTrafficControlManager.saveOrUpdate((Object)bizEventProgress);
                if (!result) {
                    dataReceive.setProcessStatus(0);
                    dataReceive.setErrorMessage("\u64cd\u4f5c\u5931\u8d25\uff01\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01");
                    CommonResult commonResult = new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25\uff01\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01", (Object)data);
                    return commonResult;
                }
                dataReceive.setProcessStatus(1);
            }
        }
        catch (Exception e) {
            dataReceive.setProcessStatus(2);
            dataReceive.setErrorMessage(e.getMessage());
            log.error("\u63a5\u6536\u4ea4\u901a\u7ba1\u5236\u5904\u7f6e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        finally {
            this.bizDataReceiveManager.saveOrUpdate((Object)dataReceive);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)data);
    }

    public BizEventInfo convertToBizEventInfo(TrafficEvent trafficEvent) {
        String result;
        BizBaseRoad baseRoad = this.cacheRoadMap(trafficEvent.getRoadId());
        if (Objects.isNull((Object)baseRoad)) {
            return null;
        }
        BizEventInfo bizEventInfo = (BizEventInfo)((Object)this.bizEventInfoManager.getById((Serializable)((Object)trafficEvent.getId())));
        if (Objects.isNull((Object)bizEventInfo)) {
            bizEventInfo = new BizEventInfo();
            bizEventInfo.setId(trafficEvent.getId());
            String eventNo = this.sysIdentityManager.nextId("sjdjh");
            bizEventInfo.setEventNo(eventNo);
        }
        bizEventInfo.setEventName(trafficEvent.getTitle());
        bizEventInfo.setEventTel(trafficEvent.getScenePhone());
        bizEventInfo.setEventTime(ConvertUtils.timestampToLocalDateTime(trafficEvent.getHappenTime()));
        bizEventInfo.setReceiveTime(ConvertUtils.timestampToLocalDateTime(trafficEvent.getReleaseTime()));
        bizEventInfo.setUploadTime(ConvertUtils.timestampToLocalDateTime(trafficEvent.getUploadTime()));
        bizEventInfo.setConfirmTime(ConvertUtils.timestampToLocalDateTime(trafficEvent.getUploadTime()));
        bizEventInfo.setLwEventType(LwEventTypeEnum.getCodeByEventTypeId(trafficEvent.getEventTypeId()));
        String lwEventType = bizEventInfo.getLwEventType();
        if (StringUtils.isNotEmpty((CharSequence)lwEventType) && StringUtils.isNotEmpty((CharSequence)(result = EventTypeEnum.getResultByValue(bizEventInfo.getLwEventType())))) {
            bizEventInfo.setEventType(result);
        }
        bizEventInfo.setEventPlace(EventPlaceEnum.getEventPlaceByLocationType(trafficEvent.getLocationType()));
        bizEventInfo.setPlaceDetail(trafficEvent.getAddressDesc());
        bizEventInfo.setPlaceRemarks(trafficEvent.getRemark());
        bizEventInfo.setEventSrc(EventSourceEnum.getXcCodeByDesc(trafficEvent.getSource()));
        bizEventInfo.setRoadId(baseRoad.getId());
        bizEventInfo.setRoadName(baseRoad.getName());
        bizEventInfo.setRoadCode(baseRoad.getCode());
        bizEventInfo.setDisposition(trafficEvent.getDisposalMeasures());
        bizEventInfo.setDirection(EventDirectionEnum.getDirectionByRoadDirection(trafficEvent.getRoadDirection()));
        bizEventInfo.setPegSVal(this.convertToPeg(trafficEvent.getStartStakeNumber()));
        bizEventInfo.setPegEVal(this.convertToPeg(trafficEvent.getEndStakeNumber()));
        bizEventInfo.setLng(trafficEvent.getLongitude());
        bizEventInfo.setLat(trafficEvent.getLatitude());
        bizEventInfo.setStartPatrolName(trafficEvent.getStartRoad());
        bizEventInfo.setEndPatrolName(trafficEvent.getEndRoad());
        bizEventInfo.setEventLevel(trafficEvent.getEventLevel() != null ? Integer.valueOf(trafficEvent.getEventLevel() == 5 ? 0 : trafficEvent.getEventLevel()) : null);
        bizEventInfo.setHurtUserNum(trafficEvent.getPedestrianInjuredNum());
        bizEventInfo.setDeadUserNum(trafficEvent.getPedestrianDeathNum());
        bizEventInfo.setBrokenCarNum(ReceiveEventManagerImpl.parseCarCount(trafficEvent.getInvolvedCar()));
        bizEventInfo.setBlockLength(trafficEvent.getCongestionMileage() != null ? Double.valueOf(trafficEvent.getCongestionMileage()) : null);
        bizEventInfo.setCauseCar(trafficEvent.getInvolvedCarType());
        bizEventInfo.setMemo(trafficEvent.getCreateDescription());
        bizEventInfo.setCreateName(trafficEvent.getUploadUserName());
        bizEventInfo.setCreateCompanyName(trafficEvent.getUploadUserOrg());
        bizEventInfo.setEventStatus(EventStatusEnum.getStatusByEventStatus(trafficEvent.getEventStatus()));
        return bizEventInfo;
    }

    private String convertToPeg(String pegVal) {
        if (StringUtils.isNotEmpty((CharSequence)pegVal)) {
            String replace = pegVal.replace(".", "+");
            return "K" + replace;
        }
        return null;
    }

    private BizEventProgress convertToBizEventProgress(ResubmitEvent resubmitEvent, BizEventInfo bizEventInfo) {
        BizEventProgress bizEventProgress = new BizEventProgress();
        bizEventProgress.setId(resubmitEvent.getId());
        bizEventProgress.setEventId(bizEventInfo.getId());
        bizEventProgress.setEventDetail(resubmitEvent.getEventId());
        bizEventProgress.setEventDetail(resubmitEvent.getContent());
        bizEventProgress.setUploadTime(resubmitEvent.getUploadTime() != null ? LocalDateTime.ofInstant(resubmitEvent.getUploadTime().toInstant(), ZoneId.systemDefault()) : null);
        bizEventProgress.setUploadUserName(resubmitEvent.getUploadUserName());
        bizEventProgress.setCreateCompanyName(resubmitEvent.getUploadUserOrg());
        bizEventProgress.setEventName(bizEventInfo.getEventName());
        bizEventProgress.setRoadId(bizEventInfo.getRoadId());
        bizEventProgress.setLng(bizEventInfo.getLng() != null ? Double.valueOf(bizEventInfo.getLng()) : null);
        bizEventProgress.setLat(bizEventInfo.getLat() != null ? Double.valueOf(bizEventInfo.getLat()) : null);
        bizEventProgress.setPegVal(bizEventInfo.getPegSVal());
        bizEventProgress.setDirection(bizEventInfo.getDirection());
        bizEventProgress.setReportType("2");
        return bizEventProgress;
    }

    private BizTrafficCongestion convertToBizTrafficCongestion(JamEvent jamEvent, BizEventInfo bizEventInfo) {
        BizTrafficCongestion bizTrafficCongestion = new BizTrafficCongestion();
        bizTrafficCongestion.setId(jamEvent.getId());
        bizTrafficCongestion.setEventId(bizEventInfo.getId());
        bizTrafficCongestion.setPegSVal(jamEvent.getStartStakeNum());
        bizTrafficCongestion.setPegEVal(jamEvent.getEndStakeNum());
        bizTrafficCongestion.setStartTime(ConvertUtils.timestampToLocalDateTime(jamEvent.getStartTime()));
        bizTrafficCongestion.setControlTime(ConvertUtils.timestampToLocalDateTime(jamEvent.getExpectedEndTime()));
        bizTrafficCongestion.setEndTime(ConvertUtils.timestampToLocalDateTime(jamEvent.getEndTime()));
        bizTrafficCongestion.setRemarks(jamEvent.getRemark());
        bizTrafficCongestion.setCause(jamEvent.getJamCauses());
        bizTrafficCongestion.setMeasure(jamEvent.getJamMeasures());
        bizTrafficCongestion.setStatus("relieve".equals(jamEvent.getStatus()) ? 1 : 2);
        BizBaseRoad baseRoad = this.cacheRoadMap(bizEventInfo.getRoadId());
        if (baseRoad != null) {
            bizTrafficCongestion.setRoadId(baseRoad.getId());
            bizTrafficCongestion.setRoadName(baseRoad.getName());
            bizTrafficCongestion.setRoadCode(baseRoad.getCode());
        }
        bizTrafficCongestion.setDirection(bizEventInfo.getDirection());
        return bizTrafficCongestion;
    }

    private BizTrafficControl convertToBizTrafficControl(TrafficControl trafficControl, BizEventInfo bizEventInfo) {
        BizTrafficControl bizTrafficControl = new BizTrafficControl();
        bizTrafficControl.setId(trafficControl.getId());
        bizTrafficControl.setEventId(bizEventInfo.getId());
        bizTrafficControl.setEventPlace(EventPlaceEnum.getEventPlaceByLocationType(trafficControl.getLocationType()));
        bizTrafficControl.setPlaceName(trafficControl.getLocale());
        bizTrafficControl.setPlaceDetail(DirectionEnum.getXcCodeByName(trafficControl.getDirection()));
        bizTrafficControl.setMeasureType(this.getMeasureType(trafficControl.getControlMeasures()));
        bizTrafficControl.setMeasureContent(trafficControl.getControlMeasures());
        bizTrafficControl.setStartTime(ConvertUtils.convertToLocalDateTime(trafficControl.getStartTime()));
        bizTrafficControl.setControlTime(ConvertUtils.convertToLocalDateTime(trafficControl.getExpectedEndTime()));
        bizTrafficControl.setEndTime(ConvertUtils.convertToLocalDateTime(trafficControl.getEndTime()));
        if (StringUtil.isNotEmpty((String)trafficControl.getControlStatus())) {
            bizTrafficControl.setStatus("ctrl".equals(trafficControl.getControlStatus()) ? 1 : 2);
        }
        bizTrafficControl.setRoadId(bizEventInfo.getRoadId());
        bizTrafficControl.setRoadName(bizEventInfo.getRoadName());
        bizTrafficControl.setRoadCode(bizEventInfo.getRoadCode());
        bizTrafficControl.setDirection(DirectionEnum.getXcCodeByName(bizEventInfo.getDirection()));
        this.setLngAndLat(bizTrafficControl, Double.parseDouble(trafficControl.getStartStakeNumber()));
        return bizTrafficControl;
    }

    private void setLngAndLat(BizTrafficControl control, double pegVal) {
        Gson gson;
        Map locationMap;
        String str;
        String roadCode = control.getRoadCode();
        String direction = control.getDirection();
        if (BeanUtils.isNotEmpty((Object)pegVal) && StringUtils.isNotBlank((CharSequence)(str = this.pointUtil.mappingPoint("02", roadCode, pegVal, direction = "2".equalsIgnoreCase(direction) ? direction : "1"))) && (locationMap = (Map)(gson = new Gson()).fromJson(str, Map.class)) != null) {
            try {
                Double lng = (Double)locationMap.get("lon");
                Double lat = (Double)locationMap.get("lat");
                if (lng != null && lat != null) {
                    control.setLng(String.valueOf(lng));
                    control.setLat(String.valueOf(lat));
                }
            }
            catch (Exception e) {
                System.err.println("\u89e3\u6790\u7ecf\u7eac\u5ea6\u65f6\u51fa\u73b0\u9519\u8bef: " + e.getMessage());
            }
        }
    }

    public BizBaseRoad cacheRoadMap(String eventRoadId) {
        String cacheKey = ROAD_CACHE_KET + eventRoadId;
        String json = (String)this.redisUtil.get(cacheKey, String.class);
        if (json != null) {
            return (BizBaseRoad)((Object)JSON.parseObject((String)json, BizBaseRoad.class));
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(BizOrgReflection::getEventRoadId, (Object)eventRoadId);
        List list = this.bizOrgReflectionManager.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BizBaseRoad baseRoad = (BizBaseRoad)((Object)this.bizBaseRoadManager.getById((Serializable)((Object)((BizOrgReflection)((Object)list.get(0))).getRoadId())));
            this.redisUtil.set(cacheKey, (Object)JSON.toJSONString((Object)((Object)baseRoad)), 600L);
            return baseRoad;
        }
        return null;
    }

    public static Integer parseCarCount(String carDescription) {
        if (carDescription == null || carDescription.isEmpty()) {
            return null;
        }
        HashMap<String, Integer> chineseNumberMap = new HashMap<String, Integer>();
        chineseNumberMap.put("\u4e00", 1);
        chineseNumberMap.put("\u5355", 1);
        chineseNumberMap.put("\u4e8c", 2);
        chineseNumberMap.put("\u4e24", 2);
        chineseNumberMap.put("\u4e09", 3);
        chineseNumberMap.put("\u56db", 4);
        chineseNumberMap.put("\u4e94", 5);
        chineseNumberMap.put("\u516d", 6);
        chineseNumberMap.put("\u4e03", 7);
        chineseNumberMap.put("\u516b", 8);
        chineseNumberMap.put("\u4e5d", 9);
        chineseNumberMap.put("\u5341", 10);
        String firstChar = carDescription.substring(0, 1);
        return chineseNumberMap.get(firstChar) != null ? (Integer)chineseNumberMap.get(firstChar) : Integer.valueOf(0);
    }

    private String getMeasureType(String measureContent) {
        if (StringUtil.isEmpty((String)measureContent)) {
            return null;
        }
        if ("\u5168\u5e45\u5c01\u95ed".equals(measureContent)) {
            return "1";
        }
        if (measureContent.contains("\u901a\u884c") || measureContent.contains("\u9650\u5236")) {
            return "2";
        }
        if ("\u534a\u5e45\u5c01\u95ed".equals(measureContent)) {
            return "3";
        }
        if (measureContent.contains("\u5360\u7528")) {
            return "4";
        }
        if (measureContent.contains("\u5355\u9053\u53cc\u901a")) {
            return "5";
        }
        if (measureContent.contains("\u5c01\u95ed\u5165\u53e3")) {
            return "6";
        }
        if (measureContent.contains("\u5c01\u95ed\u51fa\u53e3")) {
            return "7";
        }
        if (measureContent.contains("\u5c01\u95edETC\u8f66\u9053") || measureContent.contains("\u5c01\u95ed\u4eba\u5de5\u8f66\u9053") || measureContent.contains("\u5c01\u95ed\u8d85\u5bbd\u8f66\u9053")) {
            return "8";
        }
        return null;
    }
}

