/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.rescue.base.manager.BizBaseTeamMemberManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseTeamMember;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.vo.OrgInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizBaseTeamMember/v1/"})
@Api(tags={"\u57fa\u7840\u4fe1\u606f-\u5de1\u68c0\u6551\u63f4\u961f\u5458\u4fe1\u606f"})
@ApiGroup(group={"group_biz_rescue"})
public class BizBaseTeamMemberController
extends BaseController<BizBaseTeamMemberManager, BizBaseTeamMember> {
    @Resource
    RescueOrgManager orgManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizBaseTeamMember t) {
        boolean res = ((BizBaseTeamMemberManager)this.baseService).saveInfo(t);
        return new CommonResult(res ? "\u6dfb\u52a0\u6210\u529f" : "\u6dfb\u52a0\u5931\u8d25");
    }

    @GetMapping(value={"/user/{userId}"})
    @ApiOperation(value="\u6839\u636euserId\u627e\u5230\u7528\u6237")
    public CommonResult<String> getMemberId(@PathVariable(value="userId") String userId) {
        String id = ((BizBaseTeamMemberManager)this.baseService).getMemberId(userId);
        return CommonResult.success((Object)id, (String)"");
    }

    @PostMapping(value={"/authByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u6839\u636e\u961f\u4f0d\u67e5\u8be2\u4eba\u5458\u4fe1\u606f")
    public PageList<BizBaseTeamMember> findByPage(@RequestBody QueryFilter<BizBaseTeamMember> queryFilter) {
        return ((BizBaseTeamMemberManager)this.baseService).authByPage(queryFilter);
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizBaseTeamMemberManager)this.baseService).deleteByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizBaseTeamMember> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizBaseTeamMember> queryFilter) {
        List roadList = this.orgManager.roadTree().stream().map(OrgInfoVO::getRoadList).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList roadIds = new ArrayList();
        if (roadList.isEmpty()) {
            return new PageList();
        }
        for (List roads : roadList) {
            List ids = roads.stream().map(BizBaseRoad::getId).filter(Objects::nonNull).collect(Collectors.toList());
            roadIds.addAll(ids);
        }
        queryFilter.addFilter("ROAD_ID_", roadIds, QueryOP.IN);
        return ((BizBaseTeamMemberManager)this.baseService).query(queryFilter);
    }
}

