/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.rescue.monitor.utils.EmptyHandler;
import com.artfess.rescue.patrol.dao.BizVideoInspectionDao;
import com.artfess.rescue.patrol.dto.InspectionRow;
import com.artfess.rescue.patrol.dto.RegionInspection;
import com.artfess.rescue.patrol.manager.BizVideoInspectionManager;
import com.artfess.rescue.patrol.model.BizVideoInspection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizVideoInspectionManagerImpl
extends BaseManagerImpl<BizVideoInspectionDao, BizVideoInspection>
implements BizVideoInspectionManager {
    private static final Logger log = LoggerFactory.getLogger(BizVideoInspectionManagerImpl.class);
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> batchSave(List<BizVideoInspection> bizVideoInspections) {
        ArrayList<List<BizVideoInspection>> partitionedList = new ArrayList<List<BizVideoInspection>>();
        int batchSize = 20;
        for (int i = 0; i < bizVideoInspections.size(); i += batchSize) {
            int end = Math.min(i + batchSize, bizVideoInspections.size());
            partitionedList.add(bizVideoInspections.subList(i, end));
        }
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (List list : partitionedList) {
            Future<Boolean> future = this.executorService.submit(() -> this.saveBatch(sublist));
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                if (((Boolean)future.get()).booleanValue()) continue;
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Error in async execution", (Throwable)e);
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
            }
        }
        return new CommonResult();
    }

    @Override
    public CommonResult<List<BizVideoInspection>> importVideoInspection(MultipartFile file) {
        List bizVideoInspections;
        ImportParams params = new ImportParams();
        params.setTitleRows(1);
        params.setHeadRows(1);
        params.setStartSheetIndex(0);
        params.setSheetNum(1);
        params.setVerifyHandler((IExcelVerifyHandler)new EmptyHandler());
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u5bfc\u5165\u89c6\u9891\u5de1\u68c0\u8bb0\u5f55\u89e3\u6790Excel\u6570\u636e\u5f00\u59cb");
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), BizVideoInspection.class, (ImportParams)params);
            long endTime = System.currentTimeMillis() - startTime;
            log.info("\u5bfc\u5165\u89c6\u9891\u5de1\u68c0\u8bb0\u5f55\u89e3\u6790Excel\u6570\u636e\u5f00\u59cb\u5b8c\u6bd5\uff01\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)endTime);
            bizVideoInspections = result.getList();
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6392\u73ed\u4fe1\u606f\u89e3\u6790\u5931\u8d25,errorMsg:{}", (Object)e.getMessage());
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        Iterator iterator = bizVideoInspections.iterator();
        while (iterator.hasNext()) {
            BizVideoInspection inspection = (BizVideoInspection)((Object)iterator.next());
            if (StringUtil.isEmpty((String)inspection.getRoadName())) {
                iterator.remove();
                continue;
            }
            try {
                String inspectionTimeStr = inspection.getInspectionTimeStr();
                if (inspectionTimeStr.length() == 5) {
                    inspectionTimeStr = inspectionTimeStr + ":00";
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                LocalTime inspectionTime = LocalTime.parse(inspectionTimeStr, formatter);
                inspection.setInspectionTime(inspectionTime);
            }
            catch (Exception e) {
                log.error("\u5de1\u68c0\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff0cTime\uff1a{},errorMsg:{}", (Object)inspection.getInspectionTimeStr(), (Object)e.getMessage());
            }
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f\uff01", (Object)bizVideoInspections);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void exportVideoInspection(QueryFilter<BizVideoInspection> queryFilter, HttpServletResponse response) {
        PageList query = this.query(queryFilter);
        List list = query.getRows();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.exportByTemplate(response, list);
        }
    }

    public void exportByTemplate(HttpServletResponse response, List<BizVideoInspection> inspectionList) {
        List regionList = inspectionList.stream().map(BizVideoInspection::getRoadName).filter(StringUtil::isNotEmpty).distinct().sorted().collect(Collectors.toList());
        DateTimeFormatter hourFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH\u70b9");
        TreeMap<String, InspectionRow> rowMap = new TreeMap<String, InspectionRow>();
        for (BizVideoInspection item : inspectionList) {
            String key = item.getInspectionDate().atTime(item.getInspectionTime()).format(hourFormatter);
            rowMap.putIfAbsent(key, new InspectionRow());
            InspectionRow row = (InspectionRow)rowMap.get(key);
            row.setDate(key);
            RegionInspection regionData = new RegionInspection();
            regionData.setTime(this.formatTime(item.getInspectionTime()));
            regionData.setRoad(item.getPlaceName());
            regionData.setResult(this.getCheckMark(item.getInspectionResult()));
            regionData.setRecord(item.getResultRecord());
            regionData.setUser(item.getRecordUser());
            row.getRegionDataMap().put(item.getRoadName(), regionData);
        }
        ArrayList head = new ArrayList();
        ArrayList<String> dateTimeHeader = new ArrayList<String>();
        dateTimeHeader.add("\u65e5\u671f\u65f6\u95f4");
        head.add(dateTimeHeader);
        for (Object region : regionList) {
            ArrayList<Object> timeHeader = new ArrayList<Object>();
            timeHeader.add(region);
            timeHeader.add("\u65f6\u95f4");
            head.add(timeHeader);
            ArrayList<Object> placeHeader = new ArrayList<Object>();
            placeHeader.add(region);
            placeHeader.add("\u5730\u70b9");
            head.add(placeHeader);
            ArrayList<Object> resultHeader = new ArrayList<Object>();
            resultHeader.add(region);
            resultHeader.add("\u5de1\u67e5\u7ed3\u679c");
            head.add(resultHeader);
            ArrayList<Object> recordHeader = new ArrayList<Object>();
            recordHeader.add(region);
            recordHeader.add("\u5f02\u5e38\u8bb0\u5f55");
            head.add(recordHeader);
            ArrayList<Object> userHeader = new ArrayList<Object>();
            userHeader.add(region);
            userHeader.add("\u8bb0\u5f55\u4eba");
            head.add(userHeader);
        }
        ArrayList dataList = new ArrayList();
        for (InspectionRow row : rowMap.values()) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(row.getDate());
            for (String region : regionList) {
                RegionInspection reg = row.getRegionDataMap().getOrDefault(region, new RegionInspection());
                rowData.add(Optional.ofNullable(reg.getTime()).orElse(""));
                rowData.add(Optional.ofNullable(reg.getRoad()).orElse(""));
                rowData.add(Optional.ofNullable(reg.getResult()).orElse(""));
                rowData.add(Optional.ofNullable(reg.getRecord()).orElse(""));
                rowData.add(Optional.ofNullable(reg.getUser()).orElse(""));
            }
            dataList.add(rowData);
        }
        try {
            String fileName = URLEncoder.encode("\u89c6\u9891\u5de1\u67e5\u8bb0\u5f55", "UTF-8").replaceAll("\\+", "%20");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(head)).sheet("\u8bb0\u5f55").doWrite(dataList);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25", e);
        }
    }

    private String formatTime(LocalTime time) {
        return time != null ? time.format(DateTimeFormatter.ofPattern("HH:mm")) : "";
    }

    private String getCheckMark(String result) {
        return "1".equals(result) ? "\u221a" : ("2".equals(result) ? "X" : "");
    }
}

