/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.InspectTypeEnum;
import com.artfess.base.enums.InspectionTypeEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.enums.WorkclassEnum;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.rescue.patrol.dto.ReplaceCarVO;
import com.artfess.rescue.patrol.manager.BizInspectionResultManager;
import com.artfess.rescue.patrol.model.BizInspectionResult;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patrol/bizInspectionResult/v1/"})
@Api(tags={"\u5de1\u68c0\u5de1\u67e5-\u5de1\u68c0\u4efb\u52a1\u7ed3\u679c\u8868"})
@ApiGroup(group={"group_biz_rescue"})
public class BizInspectionResultController
extends BaseController<BizInspectionResultManager, BizInspectionResult> {
    @Resource
    UCFeignService feignService;
    @Resource
    BaseContext baseContext;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizInspectionResult t) {
        boolean result = ((BizInspectionResultManager)this.baseService).saveInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizInspectionResult> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizInspectionResult> queryFilter) {
        if (!this.baseContext.getCurrentOrgId().equals("1766017468444450816") && !this.baseContext.isAdmin().booleanValue()) {
            String deptId = this.baseContext.getCurrentDeptId();
            List childOrg = this.feignService.getChildOrg(deptId);
            ArrayList<String> collect = new ArrayList<String>();
            for (ObjectNode jsonNodes : childOrg) {
                String id = jsonNodes.get("id").asText();
                collect.add(id);
            }
            collect.add(deptId);
            String orgIds = collect.stream().collect(Collectors.joining(","));
            queryFilter.addFilter("r.CREATE_COMPANY_ID_", (Object)String.join((CharSequence)"','", orgIds), QueryOP.IN, FieldRelation.AND);
        }
        return ((BizInspectionResultManager)this.baseService).findByPage(queryFilter);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizInspectionResult getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizInspectionResultManager)this.baseService).findById(id);
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizInspectionResult t) {
        boolean result = ((BizInspectionResultManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizInspectionResult> queryFilter) throws Exception {
        PageList<BizInspectionResult> page = ((BizInspectionResultManager)this.baseService).findByPage(queryFilter);
        page.getRows().forEach(result -> {
            result.setWorkclass(WorkclassEnum.getDesc((String)result.getWorkclass()));
            result.setInspectType(InspectTypeEnum.getDesc((String)result.getInspectType()));
            result.setType(InspectionTypeEnum.getDesc((String)result.getType()));
        });
        ExcelUtils util = new ExcelUtils(BizInspectionResult.class);
        util.exportExcel(response, request, page.getRows(), "\u5de1\u68c0\u7ed3\u679c\u5bfc\u51fa");
    }

    @PostMapping(value={"/replaceCar"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8f66\u8f86\u66ff\u6362")
    public CommonResult<String> replaceCar(@RequestBody ReplaceCarVO carVO) {
        boolean car = ((BizInspectionResultManager)this.baseService).replaceCar(carVO);
        return new CommonResult(car ? "\u66ff\u6362\u6210\u529f" : "\u66ff\u6362\u5931\u8d25");
    }
}

