/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.external.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.config.UploadResult;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.event.manager.BizRescueHandleManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.model.BizRescueHandle;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.external.dao.BizDataReceiveDao;
import com.artfess.rescue.external.enums.RescueNodeEnum;
import com.artfess.rescue.external.manager.BizDataReceiveManager;
import com.artfess.rescue.external.manager.ReceiveEventManager;
import com.artfess.rescue.external.model.BizDataReceive;
import com.artfess.rescue.external.model.RescueNode;
import com.artfess.rescue.external.model.RescueNodeFile;
import com.artfess.rescue.external.utils.ConvertUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import fr.opensagres.odfdom.converter.core.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class BizDataReceiveManagerImpl
extends BaseManagerImpl<BizDataReceiveDao, BizDataReceive>
implements BizDataReceiveManager {
    private static final Logger log = LoggerFactory.getLogger(BizDataReceiveManagerImpl.class);
    @Resource
    private ReceiveEventManager receiveEventManager;
    @Resource
    private BizRescueInfoManager bizRescueInfoManager;
    @Resource
    private BizRescueHandleManager bizRescueHandleManager;
    @Resource
    private FileManager fileManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void RetryReceive(LocalDate localDate) throws Exception {
        LocalDateTime startOfDay = localDate.atStartOfDay();
        LocalDateTime endOfDay = localDate.plusDays(1L).atStartOfDay();
        ArrayList<Integer> errStatus = new ArrayList<Integer>(Arrays.asList(0, 2));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizDataReceive::getProcessStatus, errStatus);
        wrapper.ge(BizDataReceive::getReceiveTime, (Object)startOfDay);
        wrapper.lt(BizDataReceive::getReceiveTime, (Object)endOfDay);
        List list = this.list((Wrapper)wrapper);
        for (BizDataReceive bizDataReceive : list) {
            if (bizDataReceive.getSourceSystem().equals("\u9633\u5149\u6551\u63f4")) {
                if ("\u6551\u63f4\u8fc7\u7a0b\u4fe1\u606f\u540c\u6b65".equals(bizDataReceive.getBusinessType())) {
                    RescueNode rescueNode = (RescueNode)JSON.parseObject((String)bizDataReceive.getContent(), RescueNode.class);
                    try {
                        String orderId = rescueNode.getOrderId();
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(BizRescueInfo::getOrderId, (Object)orderId);
                        BizRescueInfo bizRescueInfo = (BizRescueInfo)((Object)this.bizRescueInfoManager.getOne((Wrapper)queryWrapper));
                        if (Objects.isNull((Object)bizRescueInfo)) {
                            throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u6839\u636e\u6551\u63f4\u5de5\u5355ID\u65e0\u6cd5\u83b7\u53d6\u6551\u63f4\u5355\u4fe1\u606f\uff01");
                        }
                        BizRescueHandle rescueHandle = new BizRescueHandle();
                        rescueHandle.setNodeId(rescueNode.getId());
                        rescueHandle.setRescueId(bizRescueInfo.getId());
                        rescueHandle.setRescueNode(RescueNodeEnum.getXcCodeByName(rescueNode.getProcessName()));
                        rescueHandle.setHandleUserId(rescueNode.getProcessUser());
                        rescueHandle.setHandleUserName(rescueNode.getProcessUser());
                        rescueHandle.setHandleTeamId(bizRescueInfo.getTeamId());
                        rescueHandle.setHandleTeamId(bizRescueInfo.getTeamName());
                        rescueHandle.setHandleTime(ConvertUtils.convertToLocalDateTime(rescueNode.getProcessTime()));
                        rescueHandle.setHandleInfo(rescueNode.getProcessContent());
                        rescueHandle.setHandleLat(rescueNode.getLat() != null ? String.valueOf(rescueNode.getLat()) : null);
                        rescueHandle.setHandleLng(rescueNode.getLng() != null ? String.valueOf(rescueNode.getLng()) : null);
                        this.bizRescueHandleManager.save((Object)rescueHandle);
                        bizDataReceive.setProcessStatus(1);
                        continue;
                    }
                    catch (Exception e) {
                        bizDataReceive.setProcessStatus(2);
                        bizDataReceive.setErrorMessage(e.getMessage());
                        log.error("\u63a5\u6536\u9633\u5149\u6551\u63f4\u8282\u70b9\u5904\u7406\u5931\u8d25\uff01\u9519\u8bef\uff1a{}", (Object)e.getMessage());
                        continue;
                    }
                    finally {
                        this.saveOrUpdate((Object)bizDataReceive);
                        continue;
                    }
                }
                if (!"\u6551\u63f4\u56fe\u7247\u4fe1\u606f".equals(bizDataReceive.getBusinessType())) continue;
                RescueNodeFile rescueNodeFile = (RescueNodeFile)JSON.parseObject((String)bizDataReceive.getContent(), RescueNodeFile.class);
                try {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    String rescueNode = RescueNodeEnum.getXcCodeByCode(String.valueOf(rescueNodeFile.getProcessId()));
                    queryWrapper.eq(BizRescueHandle::getRescueNode, (Object)rescueNode);
                    queryWrapper.eq(BizRescueHandle::getRescueId, (Object)rescueNodeFile.getOrderId());
                    BizRescueHandle bizRescueHandle = (BizRescueHandle)((Object)this.bizRescueHandleManager.getOne((Wrapper)queryWrapper));
                    if (Objects.isNull((Object)bizRescueHandle)) {
                        throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u6839\u636e\u6551\u63f4\u5de5\u5355ID\u65e0\u6cd5\u83b7\u53d6\u6551\u63f4\u5355\u4fe1\u606f\uff01");
                    }
                    ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
                    MultipartFile multipartFile = BizDataReceiveManagerImpl.base64ToMultipart(rescueNodeFile.getFileData(), rescueNodeFile.getFileName());
                    files.add(multipartFile);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("storeType", (Object)"minio");
                    DefaultFile file = (DefaultFile)JsonUtil.toBean((String)jsonObject.toString(), DefaultFile.class);
                    UploadResult uploadResult = this.fileManager.uploadFile(file, files, null, null, null);
                    this.fileManager.updateFileBizIdByIds(Collections.singletonList(uploadResult.getFileId()), bizRescueHandle.getId());
                    bizDataReceive.setProcessStatus(1);
                    continue;
                }
                catch (Exception e) {
                    bizDataReceive.setProcessStatus(2);
                    bizDataReceive.setErrorMessage(e.getMessage());
                    log.error("\u63a5\u6536\u9633\u5149\u6551\u63f4\u8282\u70b9\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01\u9519\u8bef\uff1a{}", (Object)e.getMessage());
                    continue;
                }
                finally {
                    this.saveOrUpdate((Object)bizDataReceive);
                    continue;
                }
            }
            this.receiveEventManager.retryReceive(bizDataReceive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void RetryReceive(LocalDateTime startDate, LocalDateTime endDate) throws Exception {
        ArrayList<Integer> errStatus = new ArrayList<Integer>(Arrays.asList(0, 2));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizDataReceive::getProcessStatus, errStatus);
        wrapper.ge(BizDataReceive::getReceiveTime, (Object)startDate);
        wrapper.lt(BizDataReceive::getReceiveTime, (Object)endDate);
        List list = this.list((Wrapper)wrapper);
        for (BizDataReceive bizDataReceive : list) {
            if (bizDataReceive.getSourceSystem().equals("\u9633\u5149\u6551\u63f4")) {
                if ("\u6551\u63f4\u8fc7\u7a0b\u4fe1\u606f\u540c\u6b65".equals(bizDataReceive.getBusinessType())) {
                    RescueNode rescueNode = (RescueNode)JSON.parseObject((String)bizDataReceive.getContent(), RescueNode.class);
                    try {
                        String orderId = rescueNode.getOrderId();
                        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                        queryWrapper.eq(BizRescueInfo::getOrderId, (Object)orderId);
                        BizRescueInfo bizRescueInfo = (BizRescueInfo)((Object)this.bizRescueInfoManager.getOne((Wrapper)queryWrapper));
                        if (Objects.isNull((Object)bizRescueInfo)) {
                            throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u6839\u636e\u6551\u63f4\u5de5\u5355ID\u65e0\u6cd5\u83b7\u53d6\u6551\u63f4\u5355\u4fe1\u606f\uff01");
                        }
                        BizRescueHandle rescueHandle = new BizRescueHandle();
                        rescueHandle.setNodeId(rescueNode.getId());
                        rescueHandle.setRescueId(bizRescueInfo.getId());
                        rescueHandle.setRescueNode(RescueNodeEnum.getXcCodeByName(rescueNode.getProcessName()));
                        rescueHandle.setHandleUserId(rescueNode.getProcessUser());
                        rescueHandle.setHandleUserName(rescueNode.getProcessUser());
                        rescueHandle.setHandleTeamId(bizRescueInfo.getTeamId());
                        rescueHandle.setHandleTeamId(bizRescueInfo.getTeamName());
                        rescueHandle.setHandleTime(ConvertUtils.convertToLocalDateTime(rescueNode.getProcessTime()));
                        rescueHandle.setHandleInfo(rescueNode.getProcessContent());
                        rescueHandle.setHandleLat(rescueNode.getLat() != null ? String.valueOf(rescueNode.getLat()) : null);
                        rescueHandle.setHandleLng(rescueNode.getLng() != null ? String.valueOf(rescueNode.getLng()) : null);
                        this.bizRescueHandleManager.save((Object)rescueHandle);
                        bizDataReceive.setProcessStatus(1);
                        continue;
                    }
                    catch (Exception e) {
                        bizDataReceive.setProcessStatus(2);
                        bizDataReceive.setErrorMessage(e.getMessage());
                        log.error("\u63a5\u6536\u9633\u5149\u6551\u63f4\u8282\u70b9\u5904\u7406\u5931\u8d25\uff01\u9519\u8bef\uff1a{}", (Object)e.getMessage());
                        continue;
                    }
                    finally {
                        this.saveOrUpdate((Object)bizDataReceive);
                        continue;
                    }
                }
                if (!"\u6551\u63f4\u56fe\u7247\u4fe1\u606f".equals(bizDataReceive.getBusinessType())) continue;
                RescueNodeFile rescueNodeFile = (RescueNodeFile)JSON.parseObject((String)bizDataReceive.getContent(), RescueNodeFile.class);
                try {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    String rescueNode = RescueNodeEnum.getXcCodeByCode(String.valueOf(rescueNodeFile.getProcessId()));
                    queryWrapper.eq(BizRescueHandle::getRescueNode, (Object)rescueNode);
                    queryWrapper.eq(BizRescueHandle::getRescueId, (Object)rescueNodeFile.getOrderId());
                    BizRescueHandle bizRescueHandle = (BizRescueHandle)((Object)this.bizRescueHandleManager.getOne((Wrapper)queryWrapper));
                    if (Objects.isNull((Object)bizRescueHandle)) {
                        throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u6839\u636e\u6551\u63f4\u5de5\u5355ID\u65e0\u6cd5\u83b7\u53d6\u6551\u63f4\u5355\u4fe1\u606f\uff01");
                    }
                    ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
                    MultipartFile multipartFile = BizDataReceiveManagerImpl.base64ToMultipart(rescueNodeFile.getFileData(), rescueNodeFile.getFileName());
                    files.add(multipartFile);
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("storeType", (Object)"minio");
                    DefaultFile file = (DefaultFile)JsonUtil.toBean((String)jsonObject.toString(), DefaultFile.class);
                    UploadResult uploadResult = this.fileManager.uploadFile(file, files, null, null, null);
                    this.fileManager.updateFileBizIdByIds(Collections.singletonList(uploadResult.getFileId()), bizRescueHandle.getId());
                    bizDataReceive.setProcessStatus(1);
                    continue;
                }
                catch (Exception e) {
                    bizDataReceive.setProcessStatus(2);
                    bizDataReceive.setErrorMessage(e.getMessage());
                    log.error("\u63a5\u6536\u9633\u5149\u6551\u63f4\u8282\u70b9\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01\u9519\u8bef\uff1a{}", (Object)e.getMessage());
                    continue;
                }
                finally {
                    this.saveOrUpdate((Object)bizDataReceive);
                    continue;
                }
            }
            this.receiveEventManager.retryReceive(bizDataReceive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultipartFile base64ToMultipart(String base64, String fileName) throws IOException {
        CommonsMultipartFile commonsMultipartFile;
        block35: {
            if (base64 == null || base64.isEmpty()) {
                throw new IllegalArgumentException("Base64\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (fileName == null || fileName.isEmpty()) {
                throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] parts = base64.split(",");
            String data = parts.length == 2 ? parts[1] : base64;
            byte[] fileBytes = Base64.getDecoder().decode(data);
            if (!fileName.contains(".")) {
                String mimeType = parts.length == 2 ? parts[0].split(";")[0].split("/")[1] : "jpg";
                fileName = fileName + "." + mimeType;
            }
            Path tempFile = null;
            try {
                tempFile = Files.createTempFile("upload_", "_" + fileName, new FileAttribute[0]);
                Files.write(tempFile, fileBytes, new OpenOption[0]);
                String contentType = parts.length == 2 ? parts[0].split(";")[0].replace("data:", "") : Files.probeContentType(tempFile);
                DiskFileItem fileItem = new DiskFileItem("file", contentType != null ? contentType : "application/octet-stream", false, fileName, (int)Files.size(tempFile), tempFile.getParent().toFile());
                try (InputStream input = Files.newInputStream(tempFile, new OpenOption[0]);
                     OutputStream os = fileItem.getOutputStream();){
                    IOUtils.copy((InputStream)input, (OutputStream)os);
                }
                commonsMultipartFile = new CommonsMultipartFile((FileItem)fileItem);
                if (tempFile == null) break block35;
            }
            catch (Throwable throwable) {
                if (tempFile != null) {
                    try {
                        Files.deleteIfExists(tempFile);
                    }
                    catch (IOException e) {
                        log.warn("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25: {}", tempFile, (Object)e);
                    }
                }
                throw throwable;
            }
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException e) {
                log.warn("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u5931\u8d25: {}", (Object)tempFile, (Object)e);
            }
        }
        return commonsMultipartFile;
    }
}

