/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.job;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.StringUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.rescue.patrol.manager.BizInspectionVideoConfManager;
import com.artfess.rescue.patrol.manager.BizInspectionVideoManager;
import com.artfess.rescue.patrol.manager.BizInspectionVideoTaskManager;
import com.artfess.rescue.patrol.manager.BizTaskConfVideoManager;
import com.artfess.rescue.patrol.model.BizInspectionVideo;
import com.artfess.rescue.patrol.model.BizInspectionVideoConf;
import com.artfess.rescue.patrol.model.BizInspectionVideoTask;
import com.artfess.rescue.patrol.model.BizTaskConfVideo;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizInspectionVideoTaskJob
extends BaseJob {
    private static final Logger log = LoggerFactory.getLogger(BizInspectionVideoTaskJob.class);
    @Resource
    BizInspectionVideoConfManager confManager;
    @Resource
    BizInspectionVideoTaskManager videoTaskManager;
    @Resource
    SysIdentityManager sysIdentityManager;
    @Resource
    private BizInspectionVideoManager videoManager;
    @Resource
    private BizTaskConfVideoManager taskConfVideoManager;

    public void executeJob(JobExecutionContext context) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String id = jobDataMap.getString("id");
        String logId = (String)jobDataMap.get((Object)"logId");
        String confId = jobDataMap.getString("confId");
        log.info("\u5b9a\u65f6\u8ba1\u5212\u6d4b\u8bd5\u6b63\u5e38com.artfess.rescue.patrol.job.BizInspectionVideoTaskJob\uff0ctaskConfId:{}\uff0cid:{}\uff0clogId:{}", new Object[]{confId, id, logId});
        if (StringUtil.isEmpty((String)confId)) {
            log.error("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\u5b9a\u65f6\u5668\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u914d\u7f6eID\u4e3a\u7a7a\uff01", (Object)((Object)((Object)this)).getClass().getName());
            throw new BaseException("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u914d\u7f6eID\u4e3a\u7a7a");
        }
        BizInspectionVideoConf videoConf = (BizInspectionVideoConf)this.confManager.get((Serializable)((Object)confId));
        if (null == videoConf) {
            log.error("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\u5b9a\u65f6\u5668\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u914d\u7f6e\u4e0d\u5b58\u5728\uff01", (Object)((Object)((Object)this)).getClass().getName());
            throw new BaseException("\u5b9a\u65f6\u8ba1\u5212\u6267\u884c\u5931\u8d25:\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        BizInspectionVideoTask inspectionTask = new BizInspectionVideoTask();
        String taskCode = this.sysIdentityManager.nextId("spxjdjh");
        inspectionTask.setTaskNo(taskCode);
        inspectionTask.setTaskName(videoConf.getConfName() + "_" + LocalDate.now());
        inspectionTask.setTaskConfId(videoConf.getId());
        inspectionTask.setInspectDate(LocalDate.now());
        inspectionTask.setType(videoConf.getType());
        inspectionTask.setUserIds(videoConf.getUserIds());
        inspectionTask.setUserNames(videoConf.getUserNames());
        inspectionTask.setRoadId(videoConf.getRoadId());
        inspectionTask.setRoadName(videoConf.getRoadName());
        inspectionTask.setTaskStatus(0);
        this.videoTaskManager.save((Object)inspectionTask);
        ArrayList<BizInspectionVideo> inspectionVideos = new ArrayList<BizInspectionVideo>();
        List<BizTaskConfVideo> taskConfVideos = this.taskConfVideoManager.getInfoListByTaskConfId(videoConf.getId());
        for (BizTaskConfVideo taskConfVideo : taskConfVideos) {
            BizInspectionVideo inspectionVideo = new BizInspectionVideo();
            inspectionVideo.setTaskId(inspectionTask.getId());
            inspectionVideo.setVideoId(taskConfVideo.getVideoId());
            inspectionVideo.setVideoName(taskConfVideo.getVideoName());
            inspectionVideo.setRank(taskConfVideo.getRank());
            inspectionVideo.setTaskStatus(0);
            inspectionVideos.add(inspectionVideo);
        }
        this.videoManager.saveBatch(inspectionVideos);
    }
}

