/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.rescue.patrol.manager.BizInspectionPlanManager;
import com.artfess.rescue.patrol.model.BizInspectionPlan;
import com.artfess.rescue.utils.UserControlUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.SchedulerException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patrol/bizInspectionPlan/v1/"})
@Api(tags={"\u5de1\u68c0\u8ba1\u5212"})
@ApiGroup(group={"group_biz_rescue"})
public class BizInspectionPlanController
extends BaseController<BizInspectionPlanManager, BizInspectionPlan> {
    @Resource
    BaseContext baseContext;
    @Resource
    UserControlUtils userControlUtils;

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u4fee\u6539\u5de1\u68c0\u4efb\u52a1")
    public CommonResult<String> saveOrUpdate(@ApiParam(name="model", value="\u5de1\u68c0\u4efb\u52a1") @Validated(value={AddGroup.class, UpdateGroup.class}) @RequestBody BizInspectionPlan trainTaskConf) throws Exception {
        boolean rtn = BeanUtils.validClass((String)trainTaskConf.getPlanClass());
        if (rtn) {
            boolean result = ((BizInspectionPlanManager)this.baseService).saveOrUpdateInfo(trainTaskConf);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u64cd\u4f5c\u5931\u8d25!");
            }
        } else {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25!", null);
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        try {
            boolean result = false;
            result = ((BizInspectionPlanManager)this.baseService).deleteById(id);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
            }
            return new CommonResult("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/toggleTriggerRun"})
    @ApiOperation(value="\u542f\u7528\u6216\u505c\u6b62\u5de1\u68c0\u4efb\u52a1", httpMethod="POST", notes="\u542f\u7528\u6216\u505c\u6b62\u5de1\u68c0\u4efb\u52a1")
    public CommonResult<String> start(@ApiParam(name="id", value="\u914d\u7f6eid", required=false) @RequestParam String id) throws Exception {
        boolean result = ((BizInspectionPlanManager)this.baseService).toggleTriggerRun(id);
        if (result) {
            return new CommonResult("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/executeJob"})
    @ApiOperation(value="\u6267\u884c\u5de1\u68c0\u4efb\u52a1", httpMethod="POST", notes="\u6267\u884c\u5de1\u68c0\u4efb\u52a1")
    public CommonResult<String> executeJob(@ApiParam(name="id", value="\u4efb\u52a1id", required=true) @RequestParam String id) throws SchedulerException {
        boolean result = ((BizInspectionPlanManager)this.baseService).executeJob(Collections.singletonList(id));
        if (result) {
            return new CommonResult("\u6267\u884c\u5de1\u68c0\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u6267\u884c\u5de1\u68c0\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizInspectionPlan getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizInspectionPlanManager)this.baseService).findById(id);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizInspectionPlan> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizInspectionPlan> queryFilter) {
        if (!this.baseContext.getCurrentOrgId().equals("1766017468444450816") && !this.baseContext.isAdmin().booleanValue()) {
            this.userControlUtils.addDeptPermission(queryFilter);
        }
        return ((BizInspectionPlanManager)this.baseService).findByPage(queryFilter);
    }

    @GetMapping(value={"/push"})
    @ApiOperation(value="\u53d1\u5e03\u5de1\u68c0\u4efb\u52a1")
    public CommonResult<String> push(@ApiParam(name="id", value="\u5b9e\u4f53id") @RequestParam String id) {
        boolean result = ((BizInspectionPlanManager)this.baseService).push(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u53d1\u5e03\u5de1\u68c0\u4efb\u52a1\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/executeJob/list"})
    @ApiOperation(value="\u6267\u884c\u5de1\u68c0\u4efb\u52a1-\u6279\u91cf\u6267\u884c", httpMethod="POST", notes="\u6267\u884c\u5de1\u68c0\u4efb\u52a1-\u6279\u91cf\u6267\u884c")
    public CommonResult<String> executeJobList(@ApiParam(name="ids", value="\u4efb\u52a1ids", required=true) @RequestParam List<String> ids) throws SchedulerException {
        boolean result = ((BizInspectionPlanManager)this.baseService).executeJob(ids);
        if (result) {
            return new CommonResult("\u6267\u884c\u5de1\u68c0\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u6267\u884c\u5de1\u68c0\u4efb\u52a1\u5931\u8d25\uff01");
    }
}

