/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import com.alibaba.fastjson.JSON;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.rescue.event.dao.BizCompensationInfoDao;
import com.artfess.rescue.event.enums.EventGradeEnum;
import com.artfess.rescue.event.manager.BizCompensationDetailsManager;
import com.artfess.rescue.event.manager.BizCompensationInfoManager;
import com.artfess.rescue.event.manager.BizEventInfoManager;
import com.artfess.rescue.event.model.BizCompensationDetails;
import com.artfess.rescue.event.model.BizCompensationInfo;
import com.artfess.rescue.event.model.BizEventInfo;
import com.artfess.rescue.event.vo.CompensationInfoVO;
import com.artfess.rescue.event.vo.CountCompensationNumVO;
import com.artfess.rescue.event.vo.CountCompensationTypeVO;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizCompensationInfoManagerImpl
extends BaseManagerImpl<BizCompensationInfoDao, BizCompensationInfo>
implements BizCompensationInfoManager {
    @Resource
    BizCompensationDetailsManager detailsManager;
    @Resource
    BizEventInfoManager eventInfoManager;
    @Resource
    SysDictionaryManager sdm;
    @Resource
    SystemConfigFeignService systemConfigFeignService;

    @Override
    @Transactional
    public boolean saveInfo(BizCompensationInfo entity) {
        List<BizCompensationDetails> details = entity.getCompensationDetails();
        if (details != null && !details.isEmpty()) {
            BigDecimal sumTotle = details.stream().map(BizCompensationDetails::getTotle).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setLoss(sumTotle);
            String serNumber = this.systemConfigFeignService.getNextIdByAlias("pcdjh");
            String compensationNo = JSON.parseObject((String)serNumber).get((Object)"value").toString();
            entity.setCompensationNo(compensationNo);
            boolean save = this.save((Object)entity);
            if (!save) {
                return false;
            }
            details.forEach(d -> {
                d.setCompensationId(entity.getId());
                if (entity.getEventId() != null) {
                    d.setEventId(entity.getEventId());
                }
            });
            this.detailsManager.saveBatch(details);
        } else {
            entity.setLoss(BigDecimal.ZERO);
            String serNumber = this.systemConfigFeignService.getNextIdByAlias("pcdjh");
            String compensationNo = JSON.parseObject((String)serNumber).get((Object)"value").toString();
            entity.setCompensationNo(compensationNo);
            boolean save = this.save((Object)entity);
            if (!save) {
                return false;
            }
        }
        this.setEvenLoss(entity);
        return true;
    }

    @Override
    @Transactional
    public boolean updateInfo(BizCompensationInfo entity) {
        List<BizCompensationDetails> details = entity.getCompensationDetails();
        if (details != null && !details.isEmpty()) {
            BigDecimal sumTotle = details.stream().map(BizCompensationDetails::getTotle).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setLoss(sumTotle);
            boolean update = this.updateById((Object)entity);
            if (!update) {
                return false;
            }
            details.forEach(d -> {
                d.setCompensationId(entity.getId());
                d.setEventId(entity.getEventId());
            });
            this.detailsManager.saveOrUpdateBatch(details);
        } else {
            entity.setLoss(BigDecimal.ZERO);
            boolean update = this.updateById((Object)entity);
            if (!update) {
                return false;
            }
        }
        this.setEvenLoss(entity);
        return true;
    }

    void setEvenLoss(BizCompensationInfo entity) {
        if (entity.getEventId() != null) {
            BigDecimal loss = ((BizCompensationInfoDao)this.baseMapper).sumLoss(entity.getEventId());
            LambdaUpdateWrapper eventWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)eventWrapper.eq(BizEventInfo::getId, (Object)entity.getEventId())).eq(BizDelModel::getIsDele, (Object)"0")).set(BizEventInfo::getLoss, (Object)loss);
            this.eventInfoManager.update((Wrapper)eventWrapper);
        }
    }

    @Override
    public void export(HttpServletResponse response, HttpServletRequest request, QueryFilter<BizCompensationInfo> queryFilter) {
        IPage<CompensationInfoVO> iPag = ((BizCompensationInfoDao)this.baseMapper).queryByPage((IPage<BizCompensationInfo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizCompensationInfo>)this.convert2Wrapper(queryFilter, BizCompensationInfo.class));
        Map sjly = this.sdm.dictMapByCode("sjly");
        Map sjlx = this.sdm.dictMapByCode("sjlx");
        List records = iPag.getRecords();
        records.forEach(p -> {
            List sjlxDict;
            p.setEventLevelText(EventGradeEnum.getDesc(p.getEventLevel()));
            List sjlyDict = (List)sjly.get(p.getEventType());
            if (sjlyDict != null && !sjlyDict.isEmpty()) {
                p.setEventTypeText(((DictModel)sjlyDict.get(0)).getName());
            }
            if ((sjlxDict = (List)sjlx.get(p.getEventSrc())) != null && !sjlxDict.isEmpty()) {
                p.setEventSrcText(((DictModel)sjlxDict.get(0)).getName());
            }
        });
        ExcelUtils util = new ExcelUtils(CompensationInfoVO.class);
        util.exportExcel(response, request, records, "\u8def\u635f\u8d54\u507f\u4fe1\u606f");
    }

    @Override
    public BizCompensationInfo getById(String id) {
        BizCompensationInfo entity = (BizCompensationInfo)this.get((Serializable)((Object)id));
        if (entity == null) {
            return new BizCompensationInfo();
        }
        LambdaUpdateWrapper detailsWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)detailsWrapper.eq(BizCompensationDetails::getCompensationId, (Object)entity.getId())).eq(BizDelModel::getIsDele, (Object)"0");
        List list = this.detailsManager.list((Wrapper)detailsWrapper);
        entity.setCompensationDetails(list);
        return entity;
    }

    @Override
    public CommonResult<List<CountCompensationNumVO>> countFrequency(QueryFilter<BizCompensationInfo> queryFilter) {
        return null;
    }

    @Override
    public CommonResult<List<CountCompensationTypeVO>> countType(QueryFilter<BizCompensationInfo> queryFilter) {
        return null;
    }
}

