/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.common.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PointUtil {
    private static final Logger log = LoggerFactory.getLogger(PointUtil.class);
    private final String BASE_URL_ = "https://digit-adm.hope.cmet1965.com:58000";
    private final String POINT_URL_ = "/route/pointMapping";
    private final String POINT_DISTANCE_URL_ = "/route/lineSpace";
    private final String MAPPING_POINT_URL_ = "/route/mappingPoint";
    private static final String GCJ2_WGS = "/route/gcj2wgs";
    private static final String WGS_GCJ2 = "/route/wgs2gcj";

    public String pointMapping(double lat, double lon, String pointType, String routeCode, String upDown) {
        String urlStr = String.format("https://digit-adm.hope.cmet1965.com:58000/route/pointMapping?lat=%f&lon=%f&pointType=%s&routeCode=%s&upDown=%s", lat, lon, pointType, routeCode, upDown);
        String result = HttpRequest.get((String)urlStr).timeout(-1).execute().body();
        try {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if ("SUCCESS".equals(jsonResp.getString("msgState"))) {
                String msgContent = jsonResp.getString("msgContent");
                if (msgContent == null) {
                    throw new BaseException("\u672a\u83b7\u53d6\u5230\u76f8\u5173\u4fe1\u606f");
                }
                return msgContent;
            }
            throw new BaseException("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        catch (JSONException e) {
            throw new BaseException("JSON\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
    }

    public String mappingPoint(String pointType, String routeCode, double stakeNum, String upDown) {
        String urlStr = String.format("https://digit-adm.hope.cmet1965.com:58000/route/mappingPoint?pointType=%s&routeCode=%s&stakeNum=%f&upDown=%s", pointType, routeCode, stakeNum, upDown);
        String result = HttpRequest.get((String)urlStr).timeout(-1).execute().body();
        try {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if ("SUCCESS".equals(jsonResp.getString("msgState"))) {
                String msgContent = jsonResp.getString("msgContent");
                if (msgContent.equals("{}")) {
                    return "";
                }
                return msgContent;
            }
            throw new BaseException("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        catch (JSONException e) {
            throw new BaseException("JSON\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
    }

    public String distancePoint(double qdLat, double qdLon, double zdLat, double zdLon) {
        String urlStr = String.format("https://digit-adm.hope.cmet1965.com:58000/route/lineSpace?qd_lat=%f&qd_lon=%f&zd_lat=%s&zd_lon=%s", qdLat, qdLon, zdLat, zdLon);
        String result = HttpRequest.get((String)urlStr).timeout(-1).execute().body();
        try {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if ("SUCCESS".equals(jsonResp.getString("msgState"))) {
                String msgContent = jsonResp.getString("msgContent");
                if (msgContent == null) {
                    throw new BaseException("\u672a\u83b7\u53d6\u5230\u76f8\u5173\u4fe1\u606f");
                }
                return msgContent;
            }
            throw new BaseException("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        catch (JSONException e) {
            throw new BaseException("JSON\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
    }

    public Map<String, String> Ggj2ToWgs84(Double lng, Double lat) {
        if (lng == null || lat == null) {
            return null;
        }
        String urlStr = String.format("https://digit-adm.hope.cmet1965.com:58000/route/gcj2wgs?lon=%s&lat=%s", lng, lat);
        try {
            String result = HttpRequest.get((String)urlStr).timeout(-1).execute().body();
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (!"SUCCESS".equals(jsonResp.getString("msgState"))) {
                throw new BaseException("\u5750\u6807\u8f6c\u6362\u5931\u8d25\uff1a" + jsonResp.toJSONString());
            }
            String msgContent = jsonResp.getString("msgContent");
            if (msgContent == null || msgContent.contains("\u8d85\u8303\u56f4")) {
                log.warn("\u5750\u6807\u8f6c\u6362\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)msgContent);
                return Collections.emptyMap();
            }
            String[] coordinates = msgContent.split(",");
            if (coordinates.length != 2) {
                throw new BaseException("\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u5f02\u5e38: " + msgContent);
            }
            String lon = coordinates[0].trim();
            String latVal = coordinates[1].trim();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("lon", lon);
            map.put("lat", latVal);
            return map;
        }
        catch (JSONException | NumberFormatException e) {
            throw new BaseException("JSON\u89e3\u6790\u9519\u8bef\u6216\u6570\u636e\u683c\u5f0f\u5f02\u5e38", e);
        }
    }

    public Map<String, String> Wgs84ToGgj2(String lng, String lat) {
        if (StringUtil.isEmpty((String)lng) || StringUtil.isEmpty((String)lat)) {
            return null;
        }
        String urlStr = String.format("https://digit-adm.hope.cmet1965.com:58000/route/wgs2gcj?lon=%s&lat=%s", Long.valueOf(lng), Long.valueOf(lat));
        try {
            String result = HttpRequest.get((String)urlStr).timeout(-1).execute().body();
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (!"SUCCESS".equals(jsonResp.getString("msgState"))) {
                throw new BaseException("\u5750\u6807\u8f6c\u6362\u5931\u8d25\uff1a" + jsonResp.toJSONString());
            }
            String msgContent = jsonResp.getString("msgContent");
            if (msgContent == null || msgContent.contains("\u8d85\u8303\u56f4")) {
                log.warn("\u5750\u6807\u8f6c\u6362\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)msgContent);
                return Collections.emptyMap();
            }
            String[] coordinates = msgContent.split(",");
            if (coordinates.length != 2) {
                throw new BaseException("\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u5f02\u5e38: " + msgContent);
            }
            String lon = coordinates[0].trim();
            String latVal = coordinates[1].trim();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("lon", lon);
            map.put("lat", latVal);
            return map;
        }
        catch (JSONException | NumberFormatException e) {
            throw new BaseException("JSON\u89e3\u6790\u9519\u8bef\u6216\u6570\u636e\u683c\u5f0f\u5f02\u5e38", e);
        }
    }
}

