/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.rescue.base.dao.BizBaseRoadsideFacilitiesDao;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.manager.BizBaseRoadsideFacilitiesManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseRoadsideFacilities;
import com.artfess.rescue.integrate.consts.YhxtConsts;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizBaseRoadsideFacilitiesManagerImpl
extends BaseManagerImpl<BizBaseRoadsideFacilitiesDao, BizBaseRoadsideFacilities>
implements BizBaseRoadsideFacilitiesManager {
    private static final Logger log = LoggerFactory.getLogger(BizBaseRoadsideFacilitiesManagerImpl.class);
    @Resource
    YhxtConsts yhxtConsts;
    @Resource
    BizBaseRoadManager bizBaseRoadManager;

    @Override
    @Transactional
    public void synData() {
        List<BizBaseRoadsideFacilities> roadSideFacilities = this.validateAndGetFacilities();
        this.cleanupInvalidFacilities(roadSideFacilities);
        Map<String, BizBaseRoad> roadMap = this.prepareRoadMap();
        String userName = ContextUtil.getCurrentUserName();
        LocalDateTime now = LocalDateTime.now();
        long timestamp = now.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        this.updateFacilitiesWithRoadInfo(roadSideFacilities, roadMap, timestamp, userName);
        long start = System.currentTimeMillis();
        this.saveOrUpdateFacilities(roadSideFacilities);
        long end = System.currentTimeMillis();
        log.info("\u6279\u91cf\u63d2\u5165\u8017\u65f6: {}ms", (Object)(end - start));
    }

    private List<BizBaseRoadsideFacilities> validateAndGetFacilities() {
        List<BizBaseRoadsideFacilities> facilities = this.yhxtConsts.getRoadSideFacilities();
        if (CollectionUtils.isEmpty(facilities)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u9053\u8def\u8bbe\u65bd\u6570\u636e\u4fe1\u606f");
        }
        return facilities;
    }

    private void cleanupInvalidFacilities(List<BizBaseRoadsideFacilities> validFacilities) {
        List validIds = validFacilities.stream().map(BizBaseRoadsideFacilities::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.notIn(BizBaseRoadsideFacilities::getId, validIds);
        this.remove((Wrapper)wrapper);
    }

    private Map<String, BizBaseRoad> prepareRoadMap() {
        return this.bizBaseRoadManager.list().stream().collect(Collectors.toMap(BizBaseRoad::getId, Function.identity(), (existing, replacement) -> existing));
    }

    private void updateFacilitiesWithRoadInfo(List<BizBaseRoadsideFacilities> facilities, Map<String, BizBaseRoad> roadMap, Long lastTime, String userName) {
        facilities.forEach(facility -> {
            BizBaseRoad road = (BizBaseRoad)((Object)((Object)roadMap.get(facility.getRoadSegmentId())));
            if (road != null) {
                facility.setCompanyId(road.getCompanyId());
                facility.setCompanyIds(road.getCompanyIds());
                facility.setCompanyName(road.getCompanyName());
                facility.setLastTime(lastTime);
                facility.setUpdateName(userName);
            }
        });
    }

    private void saveOrUpdateFacilities(List<BizBaseRoadsideFacilities> facilities) {
        if (!CollectionUtils.isEmpty(facilities)) {
            super.saveOrUpdateBatch(facilities);
        }
    }
}

