/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.rescue.base.manager.BizBaseTeamManager;
import com.artfess.rescue.base.model.BizBaseTeam;
import com.artfess.rescue.base.vo.TeamInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizBaseTeam/v1/"})
@Api(tags={"\u5de1\u68c0\u6551\u63f4\u961f\u4f0d\u4fe1\u606f"})
@ApiGroup(group={"group_biz_rescue"})
public class BizBaseTeamController
extends BaseController<BizBaseTeamManager, BizBaseTeam> {
    @PostMapping(value={"/query"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2")
    public PageList<BizBaseTeam> query(@RequestBody QueryFilter<BizBaseTeam> queryFilter) {
        return ((BizBaseTeamManager)this.baseService).findByPage(queryFilter);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizBaseTeam getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizBaseTeamManager)this.baseService).findById(id);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizBaseTeam t) {
        ((BizBaseTeamManager)this.baseService).saveInfo(t);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizBaseTeam t) {
        boolean res = ((BizBaseTeamManager)this.baseService).updateInfo(t);
        if (!res) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult("\u66f4\u65b0\u5b9e\u4f53\u6210\u529f");
    }

    @GetMapping(value={"/getTeamData"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public CommonResult<TeamInfoVO> getTeamData(@RequestParam(value="id") String id) {
        TeamInfoVO vo = ((BizBaseTeamManager)this.baseService).findTeamInfoById(id);
        return CommonResult.success((Object)vo, (String)"");
    }
}

