/* 巡查救援 */

export default [
  // 首页
  {
    path: 'patrolAndRescue',
    name: 'patrolAndRescue',
    component: () => import('@/views/patrolAndRescue/HomePage')  // 页面开发中的占位组件
  },
  // 巡查救援 >主数据管理
  ...[
    // 巡查救援 > 主数据管理 > 路线信息
    {
      path: 'patrolAndRescue/masterData/routeInfo',
      name: 'routeInfo',
      component: () => import('@/views/patrolAndRescue/masterData/RouteInfo')
    },
    // 巡查救援 > 主数据管理 > 路段信息
    {
      path: 'patrolAndRescue/masterData/roadSectionInfo',
      name: 'roadSectionInfo',
      component: () => import('@/views/patrolAndRescue/masterData/RoadSectionInfo')
    },
    // 巡查救援 > 主数据管理 > 桥梁信息
    {
      path: 'patrolAndRescue/masterData/bridgeInfo',
      name: 'bridgeInfo',
      component: () => import('@/views/patrolAndRescue/masterData/BridgeInfo')
    },
    // 巡查救援 > 主数据管理 > 隧道信息
    {
      path: 'patrolAndRescue/masterData/tunnelInfo',
      name: 'tunnelInfo',
      component: () => import('@/views/patrolAndRescue/masterData/TunnelInfo')
    },
    // 巡查救援 > 主数据管理 > 边坡信息
    {
      path: 'patrolAndRescue/masterData/slopeInfo',
      name: 'slopeInfo',
      component: () => import('@/views/patrolAndRescue/masterData/SlopeInfo')
    },
    // 巡查救援 > 主数据管理 > 涵洞信息
    {
      path: 'patrolAndRescue/masterData/culvertInfo',
      name: 'culvertInfo',
      component: () => import('@/views/patrolAndRescue/masterData/CulvertInfo')
    },
    // 巡查救援 > 主数据管理 > 沿线信息
    {
      path: 'patrolAndRescue/masterData/alongRouteInfo',
      name: 'alongRouteInfo',
      component: () => import('@/views/patrolAndRescue/masterData/AlongRouteInfo')
    }
  ],
  // 巡查救援 > 基础信息管理
  ...[
    // 巡查救援 > 基础信息管理 > 救援驻点管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/rescueSiteMgmt',
      name: 'rescueSiteMgmt',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/RescueSiteMgmt')
    },
    // 巡查救援 > 基础信息管理 > 巡查驻点管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/infoMgmtPatrolsManage',
      name: 'infoMgmtPatrolsManage',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/infoMgmtPatrolsManage')
    },
    // 巡查救援 > 基础信息管理 > 巡查点位管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/inspectionPointMgmt',
      name: 'inspectionPointMgmt',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/InspectionPointMgmt')
    },
    // 巡查救援 > 基础信息管理 > 外包公司管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/outsourcingCompanyMgmt',
      name: 'outsourcingCompanyMgmt',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/OutsourcingCompanyMgmt')
    },
    // 巡查救援 > 基础信息管理 > 巡查人员管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/patrolAndRescuePersonnelMgmt',
      name: 'patrolAndRescuePersonnelMgmt',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/PatrolAndRescuePersonnelMgmt')
    },
    // 巡查救援 > 基础信息管理 > 救援人员管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/rescuePersonnelMgmt',
      name: 'rescuePersonnelMgmt',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/rescuePersonnelMgmt')
    },
    // 巡查救援 > 基础信息管理 > 巡查救援车辆管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/patrolAndRescueVehicleMgmt',
      name: 'patrolAndRescueVehicleMgmt',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/PatrolAndRescueVehicleMgmt')
    },
    // 巡查救援 > 基础信息管理 > 巡查巡查队伍管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/patrolAndRescueTeamsMgmt',
      name: 'patrolAndRescueTeamsMgmt',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/PatrolAndRescueTeamsMgmt')
    },
    // 巡查救援 > 基础信息管理 > 巡查救援队伍管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/infoMgmtPatrolsRescuesTeam',
      name: 'infoMgmtPatrolsRescuesTeam',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/infoMgmtPatrolsRescuesTeam')
    },
    // 巡查救援 > 基础信息管理 > 路损项目明细管理
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/roadDamageProjectDetails',
      name: 'roadDamageProjectDetails',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/RoadDamageProjectDetails')
    },
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/electronicFence',
      name: 'electronicFence',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/electronicFence')
    },
    // //队伍关联车辆
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/bindCar',
      name: 'bindCar',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/bindCar')
    },
    {
      path: 'patrolAndRescue/infoMgmtPatrolsRescues/bindUser',
      name: 'bindUser',
      component: () => import('@/views/patrolAndRescue/infoMgmtPatrolsRescues/bindUser')
    }
  ],

  // 巡查救援 > 道路巡查
  ...[
    // 巡查救援 > 道路巡查 > 巡检计划
    {
      path: 'patrolAndRescue/roadWatch/inspectionPlan',
      name: 'inspectionPlan',
      component: () => import('@/views/patrolAndRescue/roadWatch/InspectionPlan')
    },
    // 巡查救援 > 道路巡查 > 巡检结果查询
    {
      path: 'patrolAndRescue/roadWatch/inspectionResults',
      name: 'inspectionResults',
      component: () => import('@/views/patrolAndRescue/roadWatch/InspectionResults')
    },
    // 巡查救援 > 道路巡查 > 巡检异常处理
    {
      path: 'patrolAndRescue/roadWatch/abnormalHandling',
      name: 'abnormalHandling',
      component: () => import('@/views/patrolAndRescue/roadWatch/AbnormalHandling')
    },
    // 巡查救援 > 道路巡查 > 巡检统计
    {
      path: 'patrolAndRescue/roadWatch/inspectionStats',
      name: 'inspectionStats',
      component: () => import('@/views/patrolAndRescue/roadWatch/InspectionStats')  // 页面开发中的占位组件
    },
    // 巡查救援 > 道路巡查 > 人员排班
    {
      path: 'patrolAndRescue/roadWatch/inspectScheduling',
      name: 'inspectScheduling',
      component: () => import('@/components/EmptyRouteComponent/index.vue'),
      redirect: 'patrolAndRescue/roadWatch/inspectScheduling/inspectWorkGroupContent',
      children: [
        // 巡查救援 > 道路巡查 > 人员排班-排班管理
        {
          path: 'inspectWorkUserContent',
          name: 'inspectWorkUserContent',
          component: () =>
            import('@/views/patrolAndRescue/roadWatch/inspectScheduling/inspectWorkUserContent/index.vue')
        },
        // 巡查救援 > 道路巡查 > 人员排班-班组管理
        {
          path: 'inspectWorkGroupContent',
          name: 'inspectWorkGroupContent',
          component: () =>
            import('@/views/patrolAndRescue/roadWatch/inspectScheduling/inspectWorkGroupContent/index.vue')
        }
      ]
    }
  ],

  // 巡查救援 > 视频巡查
  ...[
    // 巡查救援 > 视频巡查 > 视频巡检记录
    {
      path: 'patrolAndRescue/videoPatrol/videoPatrolRecord',
      name: 'videoConfig',
      component: () => import('@/views/patrolAndRescue/videoPatrol/videoPatrolRecord')
    },
    // 巡查救援 > 视频巡查 > 视频巡检配置
    {
      path: 'patrolAndRescue/videoPatrol/videoConfig',
      name: 'videoConfig',
      component: () => import('@/views/patrolAndRescue/videoPatrol/videoConfig')
    },
    // 巡查救援 > 视频巡查 > 视频巡检
    {
      path: 'patrolAndRescue/videoPatrol/videoInspection',
      name: 'videoInspection',
      component: () => import('@/views/patrolAndRescue/videoPatrol/videoInspection')
    },
    // 巡查救援 > 视频巡查 > 巡检结果查询
    {
      path: 'patrolAndRescue/videoPatrol/videoInspectionResults',
      name: 'videoInspectionResults',
      component: () => import('@/views/patrolAndRescue/videoPatrol/videoInspectionResults')
    }
  ],

  // 巡查救援 > 指挥调度
  ...[
    // 巡查救援 > 指挥调度 > 上报事件查询
    {
      path: 'patrolAndRescue/commandDispatch/reportEventQuery',
      name: 'reportEventQuery',
      component: () => import('@/views/patrolAndRescue/commandDispatch/ReportEventQuery')
    },
    // 巡查救援 > 指挥调度 > 事件登记
    {
      path: 'patrolAndRescue/commandDispatch/eventRegistration',
      name: 'eventRegistration',
      component: () => import('@/views/patrolAndRescue/commandDispatch/EventRegistration')
    },
    // 巡查救援 > 指挥调度 > 事件管理
    {
      path: 'patrolAndRescue/commandDispatch/eventManagement',
      name: 'eventManagement',
      component: () => import('@/views/patrolAndRescue/commandDispatch/EventManagement')
    },
    // 巡查救援 > 指挥调度 > 事件查询
    {
      path: 'patrolAndRescue/commandDispatch/eventInquiry',
      name: 'eventInquiry',
      component: () => import('@/views/patrolAndRescue/commandDispatch/EventInquiry')  // 页面开发中的占位组件
    },
    // 巡查救援 > 指挥调度 > 事件统计
    {
      path: 'patrolAndRescue/commandDispatch/eventStatistics',
      name: 'eventStatistics',
      component: () => import('@/views/patrolAndRescue/commandDispatch/EventStatistics')  // 页面开发中的占位组件
    },
    // 巡查救援 > 指挥调度 > 统计报表
    {
      path: 'patrolAndRescue/commandDispatch/statisticalReports',
      name: 'statisticalReports',
      component: () => import('@/views/patrolAndRescue/commandDispatch/StatisticalReports')  // 页面开发中的占位组件
    },
    // 巡查救援 > 指挥调度 > 路网报表
    {
      path: 'patrolAndRescue/commandDispatch/RoadNetworkReport',
      name: 'RoadNetworkReport',
      component: () => import('@/views/patrolAndRescue/commandDispatch/RoadNetworkReport')  // 页面开发中的占位组件
    },
    // 巡查救援 > 指挥调度 > 报表管理
    {
      path: 'patrolAndRescue/commandDispatch/reportManagement',
      name: 'reportManagement',
      component: () => import('@/components/EmptyRouteComponent/index.vue'),
      redirect: 'patrolAndRescue/commandDispatch/reportManagement/dutyRecords',
      children: [
        // 巡查救援 > 指挥调度 > 报表管理 > 值班记录
        {
          path: 'dutyRecords',
          name: 'dutyRecords',
          component: () =>
            import('@/views/patrolAndRescue/commandDispatch/ReportManagement/dutyRecords/index.vue')
        },
        // 巡查救援 > 道路巡查 > 报表管理 > 来电咨询记录表
        {
          path: 'callInquiryRecords',
          name: 'callInquiryRecords',
          component: () =>
            import('@/views/patrolAndRescue/commandDispatch/ReportManagement/callInquiryRecords/index.vue')
        },
        // 巡查救援 > 道路巡查 > 报表管理 > 信息发布情况记录表
        {
          path: 'informationReleaseRecords',
          name: 'informationReleaseRecords',
          component: () =>
            import('@/views/patrolAndRescue/commandDispatch/ReportManagement/informationReleaseRecords/index.vue')
        }
      ]
    }
  ],

  // 巡查救援 > 清障救援
  ...[
    // 巡查救援 > 清障救援 > 上报救援查询
    {
      path: 'patrolAndRescue/obstacleClearingRescue/reportRescueQuery',
      name: 'reportRescueQuery',
      component: () => import('@/views/patrolAndRescue/obstacleClearingRescue/ReportRescueQuery')  // 页面开发中的占位组件
    },
    // 巡查救援 > 清障救援 > 救援登记
    {
      path: 'patrolAndRescue/obstacleClearingRescue/rescueRegistration',
      name: 'rescueRegistration',
      component: () => import('@/views/patrolAndRescue/obstacleClearingRescue/RescueRegistration')  // 页面开发中的占位组件
    },
    // 巡查救援 > 清障救援 > 救援查询
    {
      path: 'patrolAndRescue/obstacleClearingRescue/rescueInquiry',
      name: 'rescueInquiry',
      component: () => import('@/views/patrolAndRescue/obstacleClearingRescue/RescueInquiry')  // 页面开发中的占位组件
    },
    // 巡查救援 > 清障救援 > 救援回访
    {
      path: 'patrolAndRescue/obstacleClearingRescue/rescueFollowUp',
      name: 'rescueFollowUp',
      component: () => import('@/views/patrolAndRescue/obstacleClearingRescue/RescueFollowUp')  // 页面开发中的占位组件
      // component: () => import('@/components/UnderDevelopmentPage')
    },
    // 巡查救援 > 清障救援 > 救援统计
    {
      path: 'patrolAndRescue/obstacleClearingRescue/rescueStatistics',
      name: 'rescueStatistics',
      component: () => import('@/views/patrolAndRescue/obstacleClearingRescue/RescueStatistics')  // 页面开发中的占位组件
    }
  ],

  // 巡查救援 > 路损赔偿
  ...[
    // 巡查救援 > 路损赔偿 > 路损登记
    {
      path: 'patrolAndRescue/commandDispatch/commandDispatchRoadDam',
      name: 'roadDamageRegister',
      component: () => import('@/views/patrolAndRescue/roadDamageComp/RoadDamageRegister')  // 页面开发中的占位组件
    },
    // 巡查救援 > 路损赔偿 > 路损查询
    {
      path: 'patrolAndRescue/roadDamageComp/roadDamageInquiry',
      name: 'roadDamageInquiry',
      component: () => import('@/views/patrolAndRescue/roadDamageComp/RoadDamageInquiry')  // 页面开发中的占位组件
    },
    // 巡查救援 > 路损赔偿 > 路损统计
    {
      path: 'patrolAndRescue/commandDispatch/commandDispatchRoadTotal',
      name: 'roadDamageStats',
      component: () => import('@/views/patrolAndRescue/roadDamageComp/RoadDamageStats')  // 页面开发中的占位组件
    }
  ],
  ...[
    // 救援收费-重庆区域
    {
      path: 'patrolAndRescue/RescueFeeStandard/RescueFeeCq',
      name: 'RescueFeeCq',
      component: () => import('@/views/patrolAndRescue/RescueFeeStandard/RescueFeeCq')  // 页面开发中的占位组件
    }
  ],

  // 巡查救援 > 运行监测管理
  ...[
    // 运行监测管理-排班信息管理
    {
      path: 'patrolAndRescue/operationalMonitoring/shiftInformationManagement',
      name: 'shiftInformationManagement',
      component: () => import('@/components/EmptyRouteComponent/index.vue'),
      redirect: 'patrolAndRescue/operationalMonitoring/shiftInformationManagement/workGroupContent',
      children: [
        // 运行监测管理-排班信息管理-排班管理
        {
          path: 'workUserContent',
          name: 'workUserContent',
          component: () =>
            import('@/views/patrolAndRescue/operationalMonitoring/shiftInformationManagement/workUserContent/index.vue')
        },
        // 运行监测管理-排班信息管理-班组管理
        {
          path: 'workGroupContent',
          name: 'workGroupContent',
          component: () =>
            import('@/views/patrolAndRescue/operationalMonitoring/shiftInformationManagement/workGroupContent/index.vue')
        }
      ]
    },
    // 运行监测管理-预警信息管理
    {
      path: 'patrolAndRescue/operationalMonitoring/informatiOnForAttention',
      name: 'informatiOnForAttention',
      component: () => import('@/views/patrolAndRescue/operationalMonitoring/informatiOnForAttention')
    },
    // 运行监测管理-预警信息管理(四川)
    {
      path: 'patrolAndRescue/operationalMonitoring/specialWarningInformation',
      name: 'specialWarningInformation',
      component: () => import('@/views/patrolAndRescue/operationalMonitoring/specialWarningInformation')
    },
    // 运行监测管理-预警叫应管理
    {
      path: 'patrolAndRescue/operationalMonitoring/calledPartyAnswer',
      name: 'calledPartyAnswer',
      component: () => import('@/views/patrolAndRescue/operationalMonitoring/calledPartyAnswer')
    },
    // 运行监测管理-台账投诉管理
    {
      path: 'patrolAndRescue/operationalMonitoring/complaintLedgerManagement',
      name: 'complaintLedgerManagement',
      component: () => import('@/views/patrolAndRescue/operationalMonitoring/complaintLedgerManagement')
    },
    // 运行监测管理-智能坐席统计
    {
      path: 'patrolAndRescue/operationalMonitoring/intelligentSeat',
      name: 'intelligentSeat',
      component: () => import('@/views/patrolAndRescue/operationalMonitoring/intelligentSeat')
    },
    // 运行监测管理-通话记录管理
    {
      path: 'patrolAndRescue/operationalMonitoring/callLogs',
      name: 'callLogs',
      component: () => import('@/views/patrolAndRescue/operationalMonitoring/callLogs')
    },
    // 运行监测管理-通话记录统计
    {
      path: 'patrolAndRescue/operationalMonitoring/callLedger',
      name: 'callLedger',
      component: () => import('@/views/patrolAndRescue/operationalMonitoring/callLedger')
    }
  ]
]
